/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.network.channel.internal;

import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionProvider;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionRequest;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionRequestResponse;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionResult;
import de.rcenvironment.core.communication.uplink.client.session.api.ClientSideUplinkSessionEventHandler;
import de.rcenvironment.core.communication.uplink.common.internal.MessageType;
import de.rcenvironment.core.communication.uplink.network.api.MessageBlockPriority;
import de.rcenvironment.core.communication.uplink.network.channel.internal.AbstractExecutionChannelEndpoint;
import de.rcenvironment.core.communication.uplink.network.channel.internal.ToolExecutionChannelState;
import de.rcenvironment.core.communication.uplink.network.channel.internal.ToolExecutionProviderEventCollectorImpl;
import de.rcenvironment.core.communication.uplink.network.channel.internal.ToolExecutionProviderEventTransferObject;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.communication.uplink.session.api.UplinkSession;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import java.io.IOException;
import java.util.List;

public class ToolExecutionChannelProviderEndpoint
extends AbstractExecutionChannelEndpoint {
    private final ClientSideUplinkSessionEventHandler sessionEventHandler;
    private final String destinationId;
    private ToolExecutionProvider toolExecutionProvider;
    private AbstractExecutionChannelEndpoint.DirectoryDownloadWrapper directoryDownloadWrapper;

    public ToolExecutionChannelProviderEndpoint(UplinkSession session, long channelId, ClientSideUplinkSessionEventHandler sessionEventHandler, String destinationId) {
        super(session, channelId);
        this.sessionEventHandler = sessionEventHandler;
        this.destinationId = destinationId;
        this.channelState = ToolExecutionChannelState.EXPECTING_EXECUTION_REQUEST;
    }

    @Override
    public synchronized void dispose() {
        if (this.toolExecutionProvider != null) {
            this.toolExecutionProvider.onContextClosing();
        }
    }

    @Override
    protected synchronized boolean processMessageInternal(MessageBlock messageBlock) throws IOException {
        MessageType messageType = messageBlock.getType();
        if (messageType == MessageType.TOOL_CANCELLATION_REQUEST) {
            this.ensure(this.toolExecutionProvider != null);
            this.toolExecutionProvider.requestCancel();
            return true;
        }
        switch (this.channelState) {
            case EXPECTING_EXECUTION_REQUEST: {
                this.validateActualVersusExpectedMessageType(messageType, MessageType.TOOL_EXECUTION_REQUEST);
                ToolExecutionRequestResponse response = this.processToolExecutionRequest(this.messageConverter.decodeToolExecutionRequest(messageBlock));
                this.enqueueMessageBlockForSending(this.messageConverter.encodeToolExecutionRequestResponse(response), MessageBlockPriority.BLOCKABLE_CHANNEL_OPERATION, true);
                if (response.isAccepted()) {
                    this.ensureNotDefinedYet(this.directoryDownloadWrapper);
                    this.directoryDownloadWrapper = new AbstractExecutionChannelEndpoint.DirectoryDownloadWrapper(this, this.toolExecutionProvider.getInputDirectoryReceiver());
                    this.channelState = ToolExecutionChannelState.EXPECTING_DIRECTORY_DOWNLOAD;
                }
                return true;
            }
            case EXPECTING_DIRECTORY_DOWNLOAD: {
                this.ensure(this.directoryDownloadWrapper != null);
                this.directoryDownloadWrapper.processMessageBlock(messageBlock);
                if (this.directoryDownloadWrapper.isFinished()) {
                    this.channelState = ToolExecutionChannelState.EXPECTING_NO_MESSAGES;
                    ConcurrencyUtils.getAsyncTaskService().execute("Uplink: tool execution and output file sending", () -> {
                        try {
                            this.runToolExecution();
                        }
                        catch (OperationFailureException | IOException e) {
                            this.log.warn((Object)"Error during tool execution", e);
                            return;
                        }
                        try {
                            this.uploadOutputFiles();
                        }
                        catch (IOException e) {
                            this.log.warn((Object)"Error uploading execution output files", (Throwable)e);
                            return;
                        }
                    });
                }
                return true;
            }
        }
        return this.refuseUnexpectedMessageType(messageBlock);
    }

    private ToolExecutionRequestResponse processToolExecutionRequest(ToolExecutionRequest toolExecutionRequest) throws ProtocolException {
        this.ensureNotDefinedYet(this.toolExecutionProvider);
        this.toolExecutionProvider = this.sessionEventHandler.setUpToolExecutionProvider(toolExecutionRequest);
        return new ToolExecutionRequestResponse(true);
    }

    private void runToolExecution() throws IOException, OperationFailureException {
        ToolExecutionProviderEventCollectorImpl eventCollector = new ToolExecutionProviderEventCollectorImpl(batch -> {
            try {
                this.enqueueMessageBlockForSending(this.messageConverter.encodeToolExecutionEvents((List<ToolExecutionProviderEventTransferObject>)batch), MessageBlockPriority.BLOCKABLE_CHANNEL_OPERATION, true);
            }
            catch (IOException e) {
                this.log.error((Object)("Error while trying to forward one or more tool execution events: " + e.toString()));
            }
        }, ConcurrencyUtils.getFactory()){};
        ToolExecutionResult executionResult = this.toolExecutionProvider.execute(eventCollector);
        try {
            eventCollector.shutdownAndAwaitCompletion();
        }
        catch (InterruptedException e) {
            this.log.warn((Object)("Interrupted while waiting for event queue to complete: " + e.toString()));
            Thread.currentThread().interrupt();
            return;
        }
        this.enqueueMessageBlockForSending(this.messageConverter.encodeToolExecutionResult(executionResult), MessageBlockPriority.BLOCKABLE_CHANNEL_OPERATION, true);
    }

    private void uploadOutputFiles() throws IOException {
        new AbstractExecutionChannelEndpoint.DirectoryUploadWrapper(this, this.toolExecutionProvider.getOutputDirectoryProvider()).performDirectoryUpload();
    }
}

