/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.network.channel.internal;

import de.rcenvironment.core.communication.uplink.common.internal.MessageType;
import de.rcenvironment.core.communication.uplink.common.internal.UplinkProtocolMessageConverter;
import de.rcenvironment.core.communication.uplink.network.api.AsyncMessageBlockSender;
import de.rcenvironment.core.communication.uplink.network.api.MessageBlockPriority;
import de.rcenvironment.core.communication.uplink.network.channel.api.ChannelEndpoint;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractChannelEndpoint
implements ChannelEndpoint {
    private static final boolean DEBUG_OUTPUT_ENABLED = DebugSettings.getVerboseLoggingEnabled((String)"uplink.endpoints");
    protected final AsyncMessageBlockSender asyncMessageBlockSender;
    protected final UplinkProtocolMessageConverter messageConverter;
    protected final String sessionId;
    protected final long channelId;
    protected final Log log = LogFactory.getLog(this.getClass());

    public AbstractChannelEndpoint(AsyncMessageBlockSender asyncMessageBlockSender, String sessionId, long channelId) {
        this.asyncMessageBlockSender = asyncMessageBlockSender;
        this.sessionId = sessionId;
        this.messageConverter = new UplinkProtocolMessageConverter(String.valueOf(this.sessionId) + "/c" + channelId);
        this.channelId = channelId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void processMessage(MessageBlock messageBlock) throws IOException {
        MessageType messageType;
        if (DEBUG_OUTPUT_ENABLED) {
            this.log.debug((Object)StringUtils.format((String)"Processing a message of type %s in channel '%s'", (Object[])new Object[]{messageBlock.getType(), this.sessionId}));
        }
        if ((messageType = messageBlock.getType()) == MessageType.HEARTBEAT) {
            this.sendHeartbeatResponse();
            return;
        }
        if (messageType == MessageType.HEARTBEAT_RESPONSE) {
            this.log.warn((Object)("Unexpected " + MessageType.HEARTBEAT_RESPONSE.name() + " message at channel endpoint " + this.sessionId));
            return;
        }
        try {
            AbstractChannelEndpoint abstractChannelEndpoint = this;
            synchronized (abstractChannelEndpoint) {
                if (!this.processMessageInternal(messageBlock) && DEBUG_OUTPUT_ENABLED) {
                    this.log.debug((Object)("Uplink channel " + this.channelId + " is terminating"));
                }
            }
        }
        catch (IOException e) {
            throw new IOException(StringUtils.format((String)"Error while processing a message of type %s in channel '%s'", (Object[])new Object[]{messageBlock.getType(), this.sessionId}), e);
        }
    }

    protected abstract boolean processMessageInternal(MessageBlock var1) throws IOException;

    protected final void enqueueMessageBlockForSending(MessageBlock messageBlock, MessageBlockPriority priority, boolean allowBlocking) throws ProtocolException {
        this.asyncMessageBlockSender.enqueueMessageBlockForSending(this.channelId, messageBlock, priority, allowBlocking);
    }

    protected final boolean refuseUnexpectedMessageType(MessageBlock message) throws ProtocolException {
        this.log.error((Object)("Received an invalid or unexpected message of type " + (Object)((Object)message.getType()) + " from session " + this.sessionId + "; the session will be terminated"));
        return false;
    }

    private void sendHeartbeatResponse() {
        try {
            this.asyncMessageBlockSender.enqueueMessageBlockForSending(this.channelId, new MessageBlock(MessageType.HEARTBEAT_RESPONSE), MessageBlockPriority.HIGH, false);
        }
        catch (ProtocolException e) {
            this.log.debug((Object)("Error attempting to send an Uplink heartbeat response: " + e.toString()));
        }
    }
}

