/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.client.session.internal;

import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionClientSideSetup;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionEventHandler;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionRequest;
import de.rcenvironment.core.communication.uplink.client.session.api.ClientSideUplinkSession;
import de.rcenvironment.core.communication.uplink.client.session.api.ClientSideUplinkSessionEventHandler;
import de.rcenvironment.core.communication.uplink.client.session.api.ToolDescriptorListUpdate;
import de.rcenvironment.core.communication.uplink.client.session.api.ToolExecutionHandle;
import de.rcenvironment.core.communication.uplink.client.session.internal.ClientSideUplinkSessionParameters;
import de.rcenvironment.core.communication.uplink.common.internal.MessageType;
import de.rcenvironment.core.communication.uplink.common.internal.UplinkProtocolMessageConverter;
import de.rcenvironment.core.communication.uplink.entities.ChannelCreationRequest;
import de.rcenvironment.core.communication.uplink.entities.ChannelCreationResponse;
import de.rcenvironment.core.communication.uplink.entities.ToolDocumentationRequest;
import de.rcenvironment.core.communication.uplink.network.api.MessageBlockPriority;
import de.rcenvironment.core.communication.uplink.network.channel.api.ChannelEndpoint;
import de.rcenvironment.core.communication.uplink.network.channel.internal.AbstractChannelEndpoint;
import de.rcenvironment.core.communication.uplink.network.channel.internal.DocumentationChannelInitiatorEndpoint;
import de.rcenvironment.core.communication.uplink.network.channel.internal.DocumentationChannelProviderEndpoint;
import de.rcenvironment.core.communication.uplink.network.channel.internal.ToolExecutionChannelInitiatorEndpoint;
import de.rcenvironment.core.communication.uplink.network.channel.internal.ToolExecutionChannelProviderEndpoint;
import de.rcenvironment.core.communication.uplink.network.internal.ClientSideUplinkLowLevelProtocolWrapper;
import de.rcenvironment.core.communication.uplink.network.internal.CommonUplinkLowLevelProtocolWrapper;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkConnectionLowLevelEventHandler;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkConnectionRefusedException;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkProtocolErrorType;
import de.rcenvironment.core.communication.uplink.session.api.UplinkSessionState;
import de.rcenvironment.core.communication.uplink.session.internal.AbstractUplinkSessionImpl;
import de.rcenvironment.core.utils.common.SizeValidatedDataSource;
import de.rcenvironment.core.utils.common.StreamConnectionEndpoint;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import de.rcenvironment.toolkit.modules.concurrency.api.BlockingResponseMapper;
import de.rcenvironment.toolkit.modules.concurrency.api.ConcurrencyUtilsFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientSideUplinkSessionImpl
extends AbstractUplinkSessionImpl
implements ClientSideUplinkSession {
    private static final int CHANNEL_REQUEST_RESULT_TIMEOUT = 20000;
    private static final int DOCUMENTATION_REQUEST_RESULT_TIMEOUT = 20000;
    private static final AtomicInteger sharedSessionIdGenerator = new AtomicInteger(0);
    private final String localSessionId;
    private final ClientSideUplinkSessionParameters sessionParameters;
    private final ClientSideUplinkSessionEventHandler sessionEventHandler;
    private final ClientSideUplinkLowLevelProtocolWrapper lowLevelProtocolWrapper;
    private final UplinkProtocolMessageConverter messageConverter;
    private final BlockingResponseMapper<String, Object> responseMapper;
    private final Map<Long, ChannelEndpoint> channelEndpointMap = Collections.synchronizedMap(new HashMap());
    private final DefaultChannelClientEndpoint defaultChannelEndpoint;
    private final AtomicInteger requestIdCounter = new AtomicInteger(0);

    public ClientSideUplinkSessionImpl(StreamConnectionEndpoint connectionEndpoint, ClientSideUplinkSessionParameters sessionParameters, ClientSideUplinkSessionEventHandler eventHandler, ConcurrencyUtilsFactory concurrencyUtilsFactory) {
        super(concurrencyUtilsFactory);
        this.localSessionId = "c" + Integer.toString(sharedSessionIdGenerator.incrementAndGet());
        this.messageConverter = new UplinkProtocolMessageConverter(this.localSessionId);
        this.updateLogDescriptor();
        ClientSideUplinkLowLevelEventHandlerImpl lowLevelEventHandler = new ClientSideUplinkLowLevelEventHandlerImpl();
        this.sessionParameters = sessionParameters;
        this.sessionEventHandler = eventHandler;
        this.responseMapper = concurrencyUtilsFactory.createBlockingResponseMapper();
        this.lowLevelProtocolWrapper = new ClientSideUplinkLowLevelProtocolWrapper(connectionEndpoint, lowLevelEventHandler, this.getLocalSessionId());
        this.defaultChannelEndpoint = new DefaultChannelClientEndpoint(this);
    }

    @Override
    public boolean runSession() {
        this.lowLevelProtocolWrapper.runSession();
        return this.getState() == UplinkSessionState.CLEAN_SHUTDOWN;
    }

    @Override
    public void publishToolDescriptorListUpdate(ToolDescriptorListUpdate update) throws IOException {
        MessageBlock messageBlock = this.messageConverter.encodeToolDescriptorListUpdate(update);
        this.enqueueMessageBlockForSending(0L, messageBlock, MessageBlockPriority.TOOL_DESCRIPTOR_UPDATES, false);
    }

    @Override
    public Optional<ToolExecutionHandle> initiateToolExecution(ToolExecutionClientSideSetup executionSetup, ToolExecutionEventHandler executionEventHandler) {
        Optional<ChannelCreationResponse> result;
        try {
            result = this.performChannelCreationRequest(executionSetup.getDestinationId(), "exec", "tool execution");
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            this.log.error((Object)("Error opening a tool execution channel: " + e.toString()));
            return Optional.empty();
        }
        if (!result.isPresent()) {
            this.log.debug((Object)("Creation of a tool execution channel to " + executionSetup.getDestinationId() + " failed; see above log message for details"));
            return Optional.empty();
        }
        long relayAssignedChannelId = result.get().getChannelId();
        ToolExecutionChannelInitiatorEndpoint initiatorEndpoint = new ToolExecutionChannelInitiatorEndpoint(this, relayAssignedChannelId, this.sessionEventHandler);
        this.channelEndpointMap.put(relayAssignedChannelId, initiatorEndpoint);
        try {
            initiatorEndpoint.initiateToolExecution(new ToolExecutionRequest(executionSetup.getExecutionRequest()), executionEventHandler);
        }
        catch (IOException e) {
            executionEventHandler.onError("Exception while initiating the tool execution: " + e.toString());
            return Optional.empty();
        }
        return Optional.of(initiatorEndpoint.getExecutionHandle());
    }

    @Override
    public Optional<SizeValidatedDataSource> fetchDocumentationData(String destinationId, String docReferenceId) {
        try {
            Optional<ChannelCreationResponse> result = this.performChannelCreationRequest(destinationId, "docs", "documentation fetching");
            if (!result.isPresent()) {
                return Optional.empty();
            }
            long relayAssignedChannelId = result.get().getChannelId();
            this.channelEndpointMap.put(relayAssignedChannelId, new DocumentationChannelInitiatorEndpoint(this, relayAssignedChannelId, optionalDocumentationStream -> this.responseMapper.registerResponse((Object)("channel_" + relayAssignedChannelId), optionalDocumentationStream)));
            this.enqueueMessageBlockForSending(relayAssignedChannelId, this.messageConverter.encodeDocumentationRequest(new ToolDocumentationRequest(docReferenceId)), MessageBlockPriority.BLOCKABLE_CHANNEL_OPERATION, true);
            Optional optionalDocResponse = (Optional)this.responseMapper.registerRequest((Object)("channel_" + relayAssignedChannelId), 20000).get();
            if (!optionalDocResponse.isPresent()) {
                return Optional.empty();
            }
            return (Optional)optionalDocResponse.get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            this.log.error((Object)("Error retrieving documentation data for id " + docReferenceId + " from " + destinationId), (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public CommonUplinkLowLevelProtocolWrapper getProtocolWrapper() {
        return this.lowLevelProtocolWrapper;
    }

    @Override
    public String getLocalSessionId() {
        return this.localSessionId;
    }

    private String generateRequestId() {
        return Integer.toString(this.requestIdCounter.incrementAndGet());
    }

    private Optional<ChannelCreationResponse> performChannelCreationRequest(String destinationId, String channelType, String intention) throws ProtocolException, InterruptedException, ExecutionException {
        String requestId = this.generateRequestId();
        ChannelCreationRequest request = new ChannelCreationRequest(channelType, destinationId, -1L, requestId);
        this.enqueueMessageBlockForSending(0L, this.messageConverter.encodeChannelCreationRequest(request), MessageBlockPriority.CHANNEL_INITIATION, false);
        Optional optionalResponse = (Optional)this.responseMapper.registerRequest((Object)requestId, 20000).get();
        if (!optionalResponse.isPresent()) {
            this.log.warn((Object)("Attempted to open a message channel for " + intention + ", but received no response within the given timeout"));
            return Optional.empty();
        }
        ChannelCreationResponse response = (ChannelCreationResponse)optionalResponse.get();
        if (!response.isSuccess()) {
            this.log.warn((Object)("Failed to open a message channel for " + intention + "; if you have access to the relay's log files, " + "you may inspect them for details"));
            return Optional.empty();
        }
        this.log.debug((Object)("Successfully opened channel " + response.getChannelId() + " for " + intention));
        return Optional.of(response);
    }

    @Override
    protected void onSessionStateChanged(UplinkSessionState oldState, UplinkSessionState newState) {
        if (newState == UplinkSessionState.ACTIVE) {
            this.sessionEventHandler.onSessionActivating(this.getAssignedNamespaceId(), this.getDestinationIdPrefix());
        }
        if (oldState == UplinkSessionState.ACTIVE) {
            this.sessionEventHandler.onActiveSessionTerminating();
        }
    }

    @Override
    protected void onTerminalStateReached(UplinkSessionState newState, Optional<UplinkProtocolErrorType> fatalError) {
        if (fatalError.isPresent()) {
            if (newState != UplinkSessionState.UNCLEAN_SHUTDOWN && newState != UplinkSessionState.SESSION_REFUSED_OR_HANDSHAKE_ERROR) {
                this.log.warn((Object)(String.valueOf(this.logPrefix) + "Unexpected combination: A fatal error of type " + fatalError.get().name() + " was registered, but the session ended in state " + (Object)((Object)newState)));
            }
            this.sessionEventHandler.onSessionInFinalState(fatalError.get().getClientRetryFlag());
        } else {
            if (newState != UplinkSessionState.CLEAN_SHUTDOWN) {
                this.log.debug((Object)(String.valueOf(this.logPrefix) + "Session ended in state " + (Object)((Object)newState) + " without a previous fatal error message"));
            }
            this.sessionEventHandler.onSessionInFinalState(true);
        }
    }

    @Override
    protected void handleFatalError(UplinkProtocolErrorType errorType, String errorMessage) {
        if (this.getState() != UplinkSessionState.SESSION_REFUSED_OR_HANDSHAKE_ERROR) {
            this.sessionEventHandler.onFatalErrorMessage(errorType, "Connection closed by the remote side: " + errorMessage);
        }
        super.handleFatalError(errorType, errorMessage);
    }

    @Override
    public CommonUplinkLowLevelProtocolWrapper getLowLevelProtocolWrapper() {
        return this.lowLevelProtocolWrapper;
    }

    @Override
    protected String getRemoteSideInformationString() {
        return "Uplink server";
    }

    private final class ClientSideUplinkLowLevelEventHandlerImpl
    implements UplinkConnectionLowLevelEventHandler {
        private ClientSideUplinkLowLevelEventHandlerImpl() {
        }

        @Override
        public void provideOrProcessHandshakeData(Map<String, String> incomingData, Map<String, String> outgoingData) {
            if (incomingData == null && outgoingData != null) {
                outgoingData.put("protocolVersion", "0.2");
                String clientVersionString = ClientSideUplinkSessionImpl.this.sessionParameters.getClientVersionInfo();
                if (clientVersionString != null) {
                    outgoingData.put("clientVersion", clientVersionString);
                }
                String sessionQualifier = StringUtils.nullSafe((String)ClientSideUplinkSessionImpl.this.sessionParameters.getSessionQualifier(), (String)"default");
                outgoingData.put("sessionQualifier", sessionQualifier);
                if (ClientSideUplinkSessionImpl.this.sessionParameters.getCustomHandshakeData() != null) {
                    outgoingData.putAll(ClientSideUplinkSessionImpl.this.sessionParameters.getCustomHandshakeData());
                }
                ClientSideUplinkSessionImpl.this.markClientHandshakeSentOrReceived();
            } else if (incomingData != null && outgoingData == null) {
                ClientSideUplinkSessionImpl.this.markServerHandshakeSentOrReceived();
                String serverAssignedNamespaceId = incomingData.get("namespace");
                if (StringUtils.isNullorEmpty((String)serverAssignedNamespaceId)) {
                    serverAssignedNamespaceId = "<error: handshake data did not include a namespace id>/";
                } else {
                    ClientSideUplinkSessionImpl.this.setAssignedNamespaceId(serverAssignedNamespaceId);
                    ClientSideUplinkSessionImpl.this.updateLogDescriptor();
                }
            } else {
                throw new IllegalStateException();
            }
        }

        @Override
        public void onHandshakeComplete() {
            ClientSideUplinkSessionImpl.this.markHandshakeSuccessful();
        }

        @Override
        public void onHandshakeFailedOrConnectionRefused(UplinkConnectionRefusedException e) {
            ClientSideUplinkSessionImpl.this.sessionEventHandler.onFatalErrorMessage(e.getType(), e.getRawMessage());
            ClientSideUplinkSessionImpl.this.markHandshakeFailed(e);
        }

        @Override
        public void onMessageBlock(long channelId, MessageBlock messageBlock) {
            ClientSideUplinkSessionImpl.this.incomingProcessingQueue.enqueue(() -> {
                try {
                    if (channelId == 0L) {
                        ClientSideUplinkSessionImpl.this.defaultChannelEndpoint.processMessage(messageBlock);
                    } else {
                        ChannelEndpoint channelEndpoint = (ChannelEndpoint)ClientSideUplinkSessionImpl.this.channelEndpointMap.get(channelId);
                        if (channelEndpoint == null) {
                            ClientSideUplinkSessionImpl.this.log.error((Object)StringUtils.format((String)"%s Received a message of type %s for channel %d but found no registered endpoint to handle it", (Object[])new Object[]{ClientSideUplinkSessionImpl.this.logPrefix, messageBlock.getType(), channelId}));
                            return;
                        }
                        channelEndpoint.processMessage(messageBlock);
                    }
                }
                catch (IOException e) {
                    ClientSideUplinkSessionImpl.this.log.error((Object)(String.valueOf(ClientSideUplinkSessionImpl.this.logPrefix) + "Error while processing incoming message of type " + (Object)((Object)messageBlock.getType()) + ", closing session"), (Throwable)e);
                }
            });
        }

        @Override
        public void onRegularGoodbyeMessage() {
            ClientSideUplinkSessionImpl.this.handleRegularRemoteGoodbyeMessage();
        }

        @Override
        public void onErrorGoodbyeMessage(UplinkProtocolErrorType errorType, String errorMessage) {
            ClientSideUplinkSessionImpl.this.handleFatalError(errorType, errorMessage);
        }

        @Override
        public void onIncomingStreamClosedOrEOF() {
            ClientSideUplinkSessionImpl.this.handleIncomingStreamClosedOrEOF();
        }

        @Override
        public void onStreamReadError(IOException e) {
            ClientSideUplinkSessionImpl.this.log.error((Object)("Error reading from stream " + ClientSideUplinkSessionImpl.this.getLogDescriptor() + ": " + e.toString()));
            ClientSideUplinkSessionImpl.this.handleFatalError(UplinkProtocolErrorType.LOW_LEVEL_CONNECTION_ERROR, e.toString());
        }

        @Override
        public void onStreamWriteError(IOException e) {
            ClientSideUplinkSessionImpl.this.handleStreamWriteError(e);
        }

        @Override
        public void onNonProtocolError(Exception exception) {
            ClientSideUplinkSessionImpl.this.handleFatalError(UplinkProtocolErrorType.INTERNAL_CLIENT_ERROR, exception.toString());
        }
    }

    public class DefaultChannelClientEndpoint
    extends AbstractChannelEndpoint {
        public DefaultChannelClientEndpoint(ClientSideUplinkSession session) {
            super(session, session.getLocalSessionId(), 0L);
        }

        @Override
        protected boolean processMessageInternal(MessageBlock messageBlock) throws IOException {
            MessageType messageType = messageBlock.getType();
            switch (messageType) {
                case TOOL_DESCRIPTOR_LIST_UPDATE: {
                    ToolDescriptorListUpdate update = this.messageConverter.decodeToolDescriptorListUpdate(messageBlock);
                    ClientSideUplinkSessionImpl.this.sessionEventHandler.processToolDescriptorListUpdate(update);
                    return true;
                }
                case CHANNEL_INIT: {
                    String channelType;
                    ChannelCreationRequest request = this.messageConverter.decodeChannelCreationRequest(messageBlock);
                    long relayProvidedChannelId = request.getChannelId();
                    switch (channelType = request.getType()) {
                        case "docs": {
                            ClientSideUplinkSessionImpl.this.channelEndpointMap.put(relayProvidedChannelId, new DocumentationChannelProviderEndpoint(ClientSideUplinkSessionImpl.this, relayProvidedChannelId, ClientSideUplinkSessionImpl.this.sessionEventHandler, request.getDestinationId()));
                            break;
                        }
                        case "exec": {
                            ClientSideUplinkSessionImpl.this.channelEndpointMap.put(relayProvidedChannelId, new ToolExecutionChannelProviderEndpoint(ClientSideUplinkSessionImpl.this, relayProvidedChannelId, ClientSideUplinkSessionImpl.this.sessionEventHandler, request.getDestinationId()));
                            break;
                        }
                        default: {
                            this.log.error((Object)("Ignoring channel request for invalid type " + channelType));
                            return true;
                        }
                    }
                    this.log.debug((Object)("Accepting offered message channel " + relayProvidedChannelId + " of type '" + channelType + "'"));
                    ChannelCreationResponse responseToSend = new ChannelCreationResponse(relayProvidedChannelId, request.getRequestId(), true);
                    this.enqueueMessageBlockForSending(this.messageConverter.encodeChannelCreationResponse(responseToSend), MessageBlockPriority.CHANNEL_INITIATION, false);
                    return true;
                }
                case CHANNEL_INIT_RESPONSE: {
                    ChannelCreationResponse receivedResponse = this.messageConverter.decodeChannelCreationResponse(messageBlock);
                    ClientSideUplinkSessionImpl.this.responseMapper.registerResponse((Object)receivedResponse.getRequestId(), (Object)receivedResponse);
                    return true;
                }
            }
            this.log.warn((Object)("Ignoring message of unhandled type " + (Object)((Object)messageType)));
            return true;
        }

        @Override
        public void dispose() {
        }
    }
}

