/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import jodd.mail.EmailFilter;
import jodd.mail.JoddMail;
import jodd.mail.MailException;
import jodd.mail.ReceivedEmail;

public class ReceiveMailSession {
    protected static final String DEFAULT_FOLDER = "INBOX";
    protected final Session session;
    protected final Store store;
    protected Folder folder;

    public ReceiveMailSession(Session session, Store store) {
        this.session = session;
        this.store = store;
    }

    public void open() {
        try {
            this.store.connect();
        }
        catch (MessagingException msex) {
            throw new MailException("Open session error", msex);
        }
    }

    public String[] getAllFolders() {
        Folder[] folders;
        try {
            folders = this.store.getDefaultFolder().list("*");
        }
        catch (MessagingException msex) {
            throw new MailException("Failed to connect to folder", msex);
        }
        String[] folderNames = new String[folders.length];
        for (int i = 0; i < folders.length; ++i) {
            Folder folder = folders[i];
            folderNames[i] = folder.getFullName();
        }
        return folderNames;
    }

    public void useFolder(String folderName) {
        this.closeFolderIfOpened();
        try {
            this.folder = this.store.getFolder(folderName);
        }
        catch (MessagingException msex) {
            throw new MailException("Failed to connect to folder: " + folderName, msex);
        }
        try {
            this.folder.open(2);
        }
        catch (MessagingException ignore) {
            try {
                this.folder.open(1);
            }
            catch (MessagingException msex) {
                throw new MailException("Failed to open folder: " + folderName, msex);
            }
        }
    }

    public void useDefaultFolder() {
        this.closeFolderIfOpened();
        this.useFolder(DEFAULT_FOLDER);
    }

    public int getMessageCount() {
        if (this.folder == null) {
            this.useDefaultFolder();
        }
        try {
            return this.folder.getMessageCount();
        }
        catch (MessagingException mex) {
            throw new MailException(mex);
        }
    }

    public int getNewMessageCount() {
        if (this.folder == null) {
            this.useDefaultFolder();
        }
        try {
            return this.folder.getNewMessageCount();
        }
        catch (MessagingException mex) {
            throw new MailException(mex);
        }
    }

    public int getUnreadMessageCount() {
        if (this.folder == null) {
            this.useDefaultFolder();
        }
        try {
            return this.folder.getUnreadMessageCount();
        }
        catch (MessagingException mex) {
            throw new MailException(mex);
        }
    }

    public int getDeletedMessageCount() {
        if (this.folder == null) {
            this.useDefaultFolder();
        }
        try {
            return this.folder.getDeletedMessageCount();
        }
        catch (MessagingException mex) {
            throw new MailException(mex);
        }
    }

    public ReceivedEmail[] receiveEmail() {
        return this.receive(null, null);
    }

    public ReceivedEmail[] receiveEmail(EmailFilter emailFilter) {
        return this.receive(emailFilter, null);
    }

    public ReceivedEmail[] receiveEmailAndMarkSeen() {
        return this.receiveEmailAndMarkSeen(null);
    }

    public ReceivedEmail[] receiveEmailAndMarkSeen(EmailFilter emailFilter) {
        Flags flags = new Flags();
        flags.add(Flags.Flag.SEEN);
        return this.receive(emailFilter, flags);
    }

    public ReceivedEmail[] receiveEmailAndDelete() {
        return this.receiveEmailAndDelete(null);
    }

    public ReceivedEmail[] receiveEmailAndDelete(EmailFilter emailFilter) {
        Flags flags = new Flags();
        flags.add(Flags.Flag.SEEN);
        flags.add(Flags.Flag.DELETED);
        return this.receive(emailFilter, flags);
    }

    public ReceivedEmail[] receive(EmailFilter filter, Flags flagsToSet) {
        if (this.folder == null) {
            this.useDefaultFolder();
        }
        try {
            Message[] messages = filter == null ? this.folder.getMessages() : this.folder.search(filter.getSearchTerm());
            if (messages.length == 0) {
                return null;
            }
            ReceivedEmail[] emails = new ReceivedEmail[messages.length];
            for (int i = 0; i < messages.length; ++i) {
                Message msg = messages[i];
                if (flagsToSet != null) {
                    msg.setFlags(flagsToSet, true);
                }
                emails[i] = new ReceivedEmail(msg);
                if (flagsToSet != null || emails[i].isSeen()) continue;
                msg.setFlag(Flags.Flag.SEEN, false);
            }
            return emails;
        }
        catch (MessagingException msex) {
            throw new MailException("Failed to fetch messages", msex);
        }
    }

    protected void closeFolderIfOpened() {
        if (this.folder != null) {
            try {
                this.folder.close(true);
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
    }

    public void close() {
        this.closeFolderIfOpened();
        try {
            this.store.close();
        }
        catch (MessagingException mex) {
            throw new MailException(mex);
        }
    }

    static {
        JoddMail.mailSystem.defineJavaMailSystemProperties();
    }
}

