/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.gui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.wizards.AbstractExtensionWizardRegistry;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.IWizardRegistry;

public final class UnwantedUIRemover {
    private static final String[] PERSPECTIVES = new String[]{"org.eclipse.debug.ui.DebugPerspective", "org.eclipse.team.ui.TeamSynchronizingPerspective", "org.eclipse.ui.resourcePerspective", "org.eclipse.wst.xml.ui.perspective"};
    private static final String[] NEW_WIZARDS = new String[]{"org.eclipse.wst.xml.ui.XMLExampleProjectCreationWizard", "org.eclipse.wst.dtd.ui.internal.wizard.NewDTDWizard", "org.eclipse.wst.xml.ui.internal.wizards.NewXMLWizard", "org.eclipse.wst.xsd.ui.internal.wizards.NewXSDWizard"};
    private static final String[] VIEWS = new String[]{"org.eclipse.debug.ui.BreakpointView", "org.eclipse.debug.ui.DebugView", "org.eclipse.debug.ui.ExpressionView", "org.eclipse.debug.ui.MemoryView", "org.eclipse.debug.ui.ModuleView", "org.eclipse.debug.ui.RegisterView", "org.eclipse.debug.ui.VariableView", "org.eclipse.team.sync.views.SynchronizeView", "org.eclipse.team.ui.GenericHistoryView", "org.eclipse.ui.console.ConsoleView", "org.eclipse.ui.views.BookmarkView"};
    private static final String[] EXPORT_WIZARDS = new String[]{"org.eclipse.debug.internal.ui.importexport.breakpoints.WizardExportBreakpoints", "org.eclipse.debug.ui.export.launchconfigurations", "org.eclipse.equinox.p2.replication.export", "org.eclipse.team.ui.ProjectSetExportWizard", "org.eclipse.wst.xml.ui.internal.wizards.ExportXMLCatalogWizard"};
    private static final String[] IMPORT_WIZARDS = new String[]{"org.eclipse.debug.internal.ui.importexport.breakpoints.WizardImportBreakpoints", "org.eclipse.debug.ui.import.launchconfigurations", "org.eclipse.equinox.p2.replication.import", "org.eclipse.equinox.p2.replication.importfrominstallation", "org.eclipse.team.ui.ProjectSetImportWizard", "org.eclipse.wst.xml.ui.internal.wizards.ImportXMLCatalogWizard"};
    private static final String[] MENU_ITEM_PATHS = new String[]{"window/org.eclipse.ui.editors"};

    private UnwantedUIRemover() {
    }

    public static void removeUnwantedPerspectives() {
        List<String> ignoredPerspectives = Arrays.asList(PERSPECTIVES);
        IPerspectiveRegistry perspectiveRegistry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] perspectiveDescriptors = perspectiveRegistry.getPerspectives();
        ArrayList<IPerspectiveDescriptor> removePerspectiveDesc = new ArrayList<IPerspectiveDescriptor>();
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = perspectiveDescriptors;
        int n = perspectiveDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IPerspectiveDescriptor perspectiveDescriptor = iPerspectiveDescriptorArray[n2];
            if (ignoredPerspectives.contains(perspectiveDescriptor.getId())) {
                removePerspectiveDesc.add(perspectiveDescriptor);
            }
            ++n2;
        }
        IExtensionChangeHandler extChgHandler = (IExtensionChangeHandler)perspectiveRegistry;
        extChgHandler.removeExtension(null, removePerspectiveDesc.toArray());
    }

    public static void removeUnwantedViews() {
        List<String> ignoredViews = Arrays.asList(VIEWS);
        IViewRegistry viewRegistry = PlatformUI.getWorkbench().getViewRegistry();
        IViewDescriptor[] viewDescriptors = viewRegistry.getViews();
        ArrayList<IViewDescriptor> removeViewDesc = new ArrayList<IViewDescriptor>();
        IViewDescriptor[] iViewDescriptorArray = viewDescriptors;
        int n = viewDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IViewDescriptor d = iViewDescriptorArray[n2];
            if (ignoredViews.contains(d.getId())) {
                removeViewDesc.add(d);
            }
            ++n2;
        }
        Platform.getExtensionRegistry().removeExtension(null, (Object)removeViewDesc.toArray());
    }

    public static void removeUnwantedNewWizards() {
        List<String> ignoredWizards = Arrays.asList(NEW_WIZARDS);
        IWizardRegistry wizardRegistry = PlatformUI.getWorkbench().getNewWizardRegistry();
        IWizardDescriptor[] wizardDescriptors = UnwantedUIRemover.getAllWizards(wizardRegistry.getRootCategory());
        AbstractExtensionWizardRegistry aewr = (AbstractExtensionWizardRegistry)WorkbenchPlugin.getDefault().getNewWizardRegistry();
        IWizardDescriptor[] iWizardDescriptorArray = wizardDescriptors;
        int n = wizardDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardDescriptor d = iWizardDescriptorArray[n2];
            WorkbenchWizardElement a = (WorkbenchWizardElement)d;
            if (ignoredWizards.contains(d.getId())) {
                aewr.removeExtension(a.getConfigurationElement().getDeclaringExtension(), new Object[]{d});
            }
            ++n2;
        }
    }

    public static void removeUnwantedImportWizards() {
        List<String> ignoredWizards = Arrays.asList(IMPORT_WIZARDS);
        IWizardRegistry wizardRegistry = PlatformUI.getWorkbench().getImportWizardRegistry();
        IWizardDescriptor[] wizardDescriptors = UnwantedUIRemover.getAllWizards(wizardRegistry.getRootCategory());
        AbstractExtensionWizardRegistry aewr = (AbstractExtensionWizardRegistry)WorkbenchPlugin.getDefault().getImportWizardRegistry();
        IWizardDescriptor[] iWizardDescriptorArray = wizardDescriptors;
        int n = wizardDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardDescriptor d = iWizardDescriptorArray[n2];
            WorkbenchWizardElement a = (WorkbenchWizardElement)d;
            if (ignoredWizards.contains(d.getId())) {
                aewr.removeExtension(a.getConfigurationElement().getDeclaringExtension(), new Object[]{d});
            }
            ++n2;
        }
    }

    public static void removeUnwantedExportWizards() {
        List<String> ignoredWizards = Arrays.asList(EXPORT_WIZARDS);
        IWizardRegistry wizardRegistry = PlatformUI.getWorkbench().getExportWizardRegistry();
        IWizardDescriptor[] wizardDescriptors = UnwantedUIRemover.getAllWizards(wizardRegistry.getRootCategory());
        AbstractExtensionWizardRegistry aewr = (AbstractExtensionWizardRegistry)WorkbenchPlugin.getDefault().getExportWizardRegistry();
        IWizardDescriptor[] iWizardDescriptorArray = wizardDescriptors;
        int n = wizardDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardDescriptor d = iWizardDescriptorArray[n2];
            WorkbenchWizardElement a = (WorkbenchWizardElement)d;
            if (ignoredWizards.contains(d.getId())) {
                aewr.removeExtension(a.getConfigurationElement().getDeclaringExtension(), new Object[]{d});
            }
            ++n2;
        }
    }

    public static void removeUnwantedMenuEntries() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IMenuManager menubarManager = ((WorkbenchWindow)workbenchWindow).getMenuBarManager();
        String[] stringArray = MENU_ITEM_PATHS;
        int n = MENU_ITEM_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String menuItemPath = stringArray[n2];
            IContributionItem contributionItem = menubarManager.findUsingPath(menuItemPath);
            if (contributionItem != null) {
                contributionItem.setVisible(false);
            }
            ++n2;
        }
    }

    private static IWizardDescriptor[] getAllWizards(IWizardCategory ... categories) {
        ArrayList<IWizardDescriptor> results = new ArrayList<IWizardDescriptor>();
        IWizardCategory[] iWizardCategoryArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardCategory wizardCategory = iWizardCategoryArray[n2];
            results.addAll(Arrays.asList(wizardCategory.getWizards()));
            results.addAll(Arrays.asList(UnwantedUIRemover.getAllWizards(wizardCategory.getCategories())));
            ++n2;
        }
        return results.toArray(new IWizardDescriptor[0]);
    }
}

