/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.testutils;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.SerializationException;
import de.rcenvironment.core.communication.messaging.NetworkRequestHandler;
import de.rcenvironment.core.communication.messaging.internal.InternalMessagingException;
import de.rcenvironment.core.communication.messaging.internal.NetworkRequestUtils;
import de.rcenvironment.core.communication.model.NetworkRequest;
import de.rcenvironment.core.communication.model.NetworkResponse;
import de.rcenvironment.core.communication.protocol.NetworkResponseFactory;
import java.io.Serializable;

public class TestNetworkRequestHandler
implements NetworkRequestHandler {
    private InstanceNodeSessionId ownNodeId;

    public TestNetworkRequestHandler(InstanceNodeSessionId ownNodeId) {
        this.ownNodeId = ownNodeId;
    }

    @Override
    public NetworkResponse handleRequest(NetworkRequest request, InstanceNodeSessionId lastHopNodeId) throws InternalMessagingException {
        Serializable content = NetworkRequestUtils.deserializeWithExceptionHandling(request);
        if (!(content instanceof String)) {
            throw new RuntimeException("Test request handler received a non-string request: " + content);
        }
        try {
            return NetworkResponseFactory.generateSuccessResponse(request, (Serializable)((Object)TestNetworkRequestHandler.getTestResponse((String)((Object)content), this.ownNodeId)));
        }
        catch (SerializationException e) {
            throw new InternalMessagingException("Failed to serialize the result of  test call " + content, e);
        }
    }

    public static String getTestResponse(String content, InstanceNodeSessionId respondingNodeId) {
        return String.valueOf(content) + ".response.from=" + respondingNodeId.getInstanceNodeSessionIdString();
    }
}

