/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.wrapper.impl;

import de.rcenvironment.core.component.wrapper.sandboxed.ExecutionEnvironment;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.executor.CommandLineExecutor;
import de.rcenvironment.core.utils.executor.LocalCommandLineExecutor;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalExecutionEnvironment
implements ExecutionEnvironment {
    private File localSandboxDir;
    private Log log = LogFactory.getLog(this.getClass());

    @Override
    public void setupStaticEnvironment() throws IOException {
    }

    @Override
    public CommandLineExecutor setupExecutorWithSandbox() throws IOException {
        this.localSandboxDir = TempFileServiceAccess.getInstance().createManagedTempDir("sandbox");
        this.log.debug((Object)("Prepared local sandbox at " + this.localSandboxDir));
        return new LocalCommandLineExecutor(this.localSandboxDir);
    }

    @Override
    public String createUniqueTemporaryStoragePath() throws IOException {
        return TempFileServiceAccess.getInstance().createManagedTempDir("static-session-storage").getAbsolutePath();
    }

    @Override
    public void tearDownSandbox(CommandLineExecutor executor) throws IOException {
        if (this.localSandboxDir != null) {
            this.log.debug((Object)("Cleaning local sandbox at " + this.localSandboxDir.getAbsolutePath()));
            TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(this.localSandboxDir);
        } else {
            this.log.warn((Object)"Failed to clean local sandbox as local sandbox directory was null.");
        }
    }

    @Override
    public void tearDownStaticEnvironment() {
    }
}

