/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.command.api.CommandExecutionResult;
import de.rcenvironment.core.command.api.CommandExecutionService;
import de.rcenvironment.core.embedded.ssh.api.SshAccount;
import de.rcenvironment.core.embedded.ssh.internal.InteractiveShellHandler;
import de.rcenvironment.core.embedded.ssh.internal.SshAuthenticationManager;
import de.rcenvironment.core.embedded.ssh.internal.SshConfiguration;
import de.rcenvironment.core.embedded.ssh.internal.SshConsoleOutputAdapter;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.session.ServerSession;

public class SshCommandHandler
implements Command,
Runnable,
SessionAware {
    private InputStream in;
    private String sshCommand;
    private String loginName;
    private ExitCallback callback;
    private Environment environment;
    private SshAuthenticationManager authenticationManager;
    private CommandExecutionService commandExecutionService;
    private SshConsoleOutputAdapter outputAdapter;
    private final Log logger = LogFactory.getLog(this.getClass());
    private SshAccount userAccount;

    public SshCommandHandler(String sshCommand, SshAuthenticationManager authenticationManager, CommandExecutionService commandExecutionService, SshConfiguration sshConfiguration) {
        this.sshCommand = sshCommand;
        this.authenticationManager = authenticationManager;
        this.commandExecutionService = commandExecutionService;
        this.outputAdapter = new SshConsoleOutputAdapter(commandExecutionService);
    }

    public void start(ChannelSession channelSession, Environment env) throws IOException {
        this.environment = env;
        this.loginName = (String)this.environment.getEnv().get("USER");
        this.userAccount = this.authenticationManager.getAccountByLoginName(this.loginName, false);
        if (this.userAccount == null) {
            this.outputAdapter.addOutput("Invalid/unknown login name: " + this.loginName);
            this.logger.warn((Object)("Blocked unrecognized SSH account " + this.loginName));
            this.callback.onExit(0);
        }
        if (this.isPotentiallyAllowedToRunCommands()) {
            this.outputAdapter.setActiveUser(this.loginName);
            ConcurrencyUtils.getAsyncTaskService().execute((Runnable)this);
        } else {
            this.outputAdapter.addOutput("Your account is not allowed to run an interactive shell or execute commands.");
            this.logger.warn((Object)("Blocked command/shell access for account " + this.loginName));
            this.callback.onExit(0);
        }
    }

    private boolean isPotentiallyAllowedToRunCommands() {
        return this.authenticationManager.isAllowedToOpenShell(this.loginName);
    }

    @Override
    @TaskDescription(value="SSH command session")
    public void run() {
        block9: {
            try {
                if (this.sshCommand == null) {
                    this.logger.debug((Object)StringUtils.format((String)"Starting interactive shell for user \"%s\"", (Object[])new Object[]{this.loginName}));
                    this.runInteractiveShellLoop();
                    this.callback.onExit(0);
                    this.logger.debug((Object)StringUtils.format((String)"Finished interactive shell for user \"%s\"", (Object[])new Object[]{this.loginName}));
                    break block9;
                }
                long startTime = System.currentTimeMillis();
                CommandExecutionResult result = null;
                try {
                    result = this.executeSingleCommand(this.sshCommand);
                    switch (result) {
                        case DEFAULT: 
                        case EXIT_REQUESTED: {
                            this.callback.onExit(0);
                            break;
                        }
                        case ERROR: 
                        case INTERRUPTED: {
                            this.callback.onExit(1);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
                catch (Throwable throwable) {
                    long execTimeMsec = System.currentTimeMillis() - startTime;
                    this.logger.debug((Object)StringUtils.format((String)"Finished execution of console command for SSH user \"%s\" (result code %s, duration %d msec): %s", (Object[])new Object[]{this.loginName, result, execTimeMsec, this.sshCommand}));
                    throw throwable;
                }
                long execTimeMsec = System.currentTimeMillis() - startTime;
                this.logger.debug((Object)StringUtils.format((String)"Finished execution of console command for SSH user \"%s\" (result code %s, duration %d msec): %s", (Object[])new Object[]{this.loginName, result, execTimeMsec, this.sshCommand}));
            }
            catch (IOException e) {
                this.logger.error((Object)StringUtils.format((String)"I/O error in SSH session - the client may have closed the connection (user \"%s\"): %s", (Object[])new Object[]{this.loginName, e.toString()}));
                this.callback.onExit(1);
            }
        }
    }

    public void destroy(ChannelSession channelSession) {
        try {
            this.in.close();
        }
        catch (IOException e) {
            this.logger.error((Object)"Could not close input stream. ", (Throwable)e);
        }
        this.outputAdapter.destroy();
        this.callback.onExit(0);
    }

    private void runInteractiveShellLoop() throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(this.in));
        InteractiveShellHandler commandBuffer = new InteractiveShellHandler(this.outputAdapter);
        this.outputAdapter.printWelcome();
        this.outputAdapter.printConsolePrompt();
        while (true) {
            int newCharCode;
            if ((newCharCode = r.read()) == 13) {
                String command = commandBuffer.getCurrentCommand();
                this.outputAdapter.addOutput("", true, false);
                CommandExecutionResult result = this.executeSingleCommand(command);
                if (result == CommandExecutionResult.EXIT_REQUESTED) {
                    return;
                }
                this.outputAdapter.printConsolePrompt();
                continue;
            }
            if (!commandBuffer.processInputChar(newCharCode)) continue;
            if (newCharCode != 127) {
                this.outputAdapter.addOutput("" + (char)newCharCode, false, false);
                continue;
            }
            this.outputAdapter.addOutput("\b \b", false, false);
        }
    }

    private CommandExecutionResult executeSingleCommand(String command) throws IOException {
        if (command != null && !command.isEmpty()) {
            if (this.authenticationManager.isAllowedToExecuteConsoleCommand(this.loginName, command)) {
                if (command.equalsIgnoreCase("exit")) {
                    return CommandExecutionResult.EXIT_REQUESTED;
                }
                return this.sendToExecutionService(command, this.userAccount);
            }
            this.logger.debug((Object)("User " + this.loginName + " tried to execute command " + command + ". Attempt was blocked because of missing role privileges."));
            this.outputAdapter.addOutput("\r\nCommand " + command + " not executed. You either do not have the privileges to execute this command or it does not exist.", true, false);
            return CommandExecutionResult.ERROR;
        }
        return CommandExecutionResult.DEFAULT;
    }

    private CommandExecutionResult sendToExecutionService(String command, Object invokerInfo) {
        if (command.startsWith("rce")) {
            command = command.replaceFirst("rce", "");
        }
        List<String> tokens = Arrays.asList(command.trim().split("\\s+"));
        Future resultFuture = this.commandExecutionService.asyncExecMultiCommand(tokens, (TextOutputReceiver)this.outputAdapter, invokerInfo);
        try {
            return (CommandExecutionResult)resultFuture.get();
        }
        catch (InterruptedException e) {
            this.outputAdapter.addOutput("Command execution interrupted: " + e.toString());
            this.logger.error((Object)"Interrupted while waiting for asynchronous command to finish", (Throwable)e);
            return CommandExecutionResult.INTERRUPTED;
        }
        catch (ExecutionException e) {
            this.outputAdapter.addOutput("Error during command execution: " + e.toString());
            this.logger.error((Object)"Error during command execution", (Throwable)e);
            return CommandExecutionResult.ERROR;
        }
    }

    public void setInputStream(InputStream inParam) {
        this.in = inParam;
    }

    public void setOutputStream(OutputStream out) {
        this.outputAdapter.setOutputStream(out);
    }

    public void setErrorStream(OutputStream err) {
        this.outputAdapter.setErrorStream(err);
    }

    public void setExitCallback(ExitCallback callbackParam) {
        this.callback = callbackParam;
    }

    public void setSession(ServerSession sessionParam) {
    }
}

