/*
 * Decompiled with CFR 0.152.
 */
package de.vonloesch.pdf4eclipse.editors.handlers;

import de.vonloesch.pdf4eclipse.editors.PDFEditor;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ZoomHandler
extends AbstractHandler {
    private static final String PARAMATER = "PDFViewer.command.parameter.zoom";
    private static final String FIT_HORIZONTAL = "fith";
    private static final String FIT_COMPLETE = "fit";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (!"de.vonloesch.pdf4eclipse.editors.PDFEditor".equals(HandlerUtil.getActiveEditorId((ExecutionEvent)event))) {
            return null;
        }
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor == null) {
            return null;
        }
        if (!(editor instanceof PDFEditor)) {
            return null;
        }
        String msg = event.getParameter(PARAMATER);
        if (msg == null) {
            return null;
        }
        float zoomFactor = 1.0f;
        if (msg.charAt(0) == '+') {
            zoomFactor = ((PDFEditor)editor).pv.getZoomFactor() + Float.parseFloat(msg.substring(1));
        } else if (msg.charAt(0) == '-') {
            zoomFactor = ((PDFEditor)editor).pv.getZoomFactor() - Float.parseFloat(msg.substring(1));
        } else if (msg.charAt(0) == '=') {
            zoomFactor = Float.parseFloat(msg.substring(1));
        } else {
            if (msg.toLowerCase().equals(FIT_HORIZONTAL)) {
                ((PDFEditor)editor).fitHorizontal();
                return null;
            }
            if (msg.toLowerCase().equals(FIT_COMPLETE)) {
                ((PDFEditor)editor).fit();
                return null;
            }
        }
        ((PDFEditor)editor).pv.setZoomFactor(zoomFactor);
        return null;
    }
}

