/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.Serializable;
import net.sf.saxon.expr.sort.IntHashMap;
import net.sf.saxon.lib.URIChecker;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NotationSet;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.StringToDouble;

public class ConversionRules
implements Serializable {
    private NameChecker nameChecker;
    private StringToDouble stringToDouble;
    private NotationSet notationSet;
    private URIChecker uriChecker;
    private boolean allowYearZero;
    private ThreadLocal<IntHashMap<Converter>> converterCache = new ThreadLocal();
    private ThreadLocal<IntHashMap<StringConverter>> stringConverterCache = new ThreadLocal();

    public ConversionRules copy() {
        ConversionRules cr = new ConversionRules();
        cr.nameChecker = this.nameChecker;
        cr.stringToDouble = this.stringToDouble;
        cr.notationSet = this.notationSet;
        cr.uriChecker = this.uriChecker;
        cr.allowYearZero = this.allowYearZero;
        return cr;
    }

    public void setNameChecker(NameChecker checker) {
        this.nameChecker = checker;
    }

    public NameChecker getNameChecker() {
        return this.nameChecker;
    }

    public void setStringToDoubleConverter(StringToDouble converter) {
        this.stringToDouble = converter;
    }

    public StringToDouble getStringToDoubleConverter() {
        return this.stringToDouble;
    }

    public void setNotationSet(NotationSet notations) {
        this.notationSet = notations;
    }

    public boolean isDeclaredNotation(String uri, String local) {
        if (this.notationSet == null) {
            return true;
        }
        return this.notationSet.isDeclaredNotation(uri, local);
    }

    public void setURIChecker(URIChecker checker) {
        this.uriChecker = checker;
    }

    public boolean isValidURI(CharSequence string) {
        return this.uriChecker == null || this.uriChecker.isValidURI(string);
    }

    public void setAllowYearZero(boolean allowed) {
        this.allowYearZero = allowed;
    }

    public boolean isAllowYearZero() {
        return this.allowYearZero;
    }

    public Converter getConverter(AtomicType source, AtomicType target) {
        Converter converter;
        int key = source.getPrimitiveType() << 20 | target.getFingerprint();
        IntHashMap<Converter> converters = this.converterCache.get();
        if (converters == null) {
            converters = new IntHashMap(50);
            this.converterCache.set(converters);
        }
        if ((converter = converters.get(key)) == null) {
            converter = Converter.getConverter(source, target, this);
            if (converter != null) {
                converters.put(key, converter);
            } else {
                return null;
            }
        }
        return converter;
    }

    public StringConverter getStringConverter(AtomicType target) {
        StringConverter converter;
        int key = target.getFingerprint();
        IntHashMap<StringConverter> stringConverters = this.stringConverterCache.get();
        if (stringConverters == null) {
            stringConverters = new IntHashMap(50);
            this.stringConverterCache.set(stringConverters);
        }
        if ((converter = stringConverters.get(key)) == null) {
            converter = StringConverter.getStringConverter(target, this);
            stringConverters.put(key, converter);
        }
        return converter;
    }
}

