/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.workflow.execution.function;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Objects;

public class EndpointAdapter {
    private boolean isInputAdapter;
    private String workflowNodeIdentifier;
    private String internalEndpointName;
    private String externalEndpointName;
    private DataType adaptedDataType;
    private EndpointDefinition.InputDatumHandling datumHandling;
    private EndpointDefinition.InputExecutionContraint executionContraint;

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.workflowNodeIdentifier == null ? 0 : this.workflowNodeIdentifier.hashCode());
        result = 31 * result + (this.internalEndpointName == null ? 0 : this.internalEndpointName.hashCode());
        result = 31 * result + (String.valueOf(this.isInputAdapter) == null ? 0 : String.valueOf(this.isInputAdapter).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EndpointAdapter other = (EndpointAdapter)obj;
        if (!this.workflowNodeIdentifier.equals(other.workflowNodeIdentifier)) {
            return false;
        }
        if (this.isInputAdapter != other.isInputAdapter) {
            return false;
        }
        return this.internalEndpointName.equals(other.internalEndpointName);
    }

    public static Builder inputAdapterBuilder() {
        Builder returnValue = new Builder();
        returnValue.product.isInputAdapter = true;
        return returnValue;
    }

    public static Builder outputAdapterBuilder() {
        Builder returnValue = new Builder();
        returnValue.product.isInputAdapter = false;
        return returnValue;
    }

    public static Builder adapterBuilder() {
        return new Builder();
    }

    public String toString() {
        if (this.isInputAdapter) {
            return StringUtils.format((String)"%s --[%s,%s,%s]-> %s @ %s", (Object[])new Object[]{this.getExternalName(), this.getDataType(), this.datumHandling, this.executionContraint, this.getInternalName(), this.getWorkflowNodeIdentifier()});
        }
        return StringUtils.format((String)"%s @ %s --[%s]-> %s", (Object[])new Object[]{this.getInternalName(), this.getWorkflowNodeIdentifier(), this.getDataType(), this.getExternalName()});
    }

    public boolean isInputAdapter() {
        return this.isInputAdapter;
    }

    public boolean isOutputAdapter() {
        return !this.isInputAdapter;
    }

    public String getWorkflowNodeIdentifier() {
        return this.workflowNodeIdentifier;
    }

    public String getInternalName() {
        return this.internalEndpointName;
    }

    public String getExternalName() {
        return this.externalEndpointName;
    }

    public DataType getDataType() {
        return this.adaptedDataType;
    }

    public EndpointDefinition.InputExecutionContraint getInputExecutionConstraint() {
        return this.executionContraint;
    }

    public EndpointDefinition.InputDatumHandling getInputDatumHandling() {
        return this.datumHandling;
    }

    public void setExternalName(String externalName) {
        this.externalEndpointName = externalName;
    }

    public static class Builder {
        private final EndpointAdapter product = new EndpointAdapter();

        protected Builder() {
        }

        public Builder isInputAdapter(Boolean isInputAdapter) {
            this.product.isInputAdapter = isInputAdapter;
            return this;
        }

        public Builder internalEndpointName(String name) {
            this.product.internalEndpointName = name;
            return this;
        }

        public Builder externalEndpointName(String name) {
            this.product.externalEndpointName = name;
            return this;
        }

        public Builder workflowNodeIdentifier(String id) {
            this.product.workflowNodeIdentifier = id;
            return this;
        }

        public Builder dataType(DataType type) {
            this.product.adaptedDataType = type;
            return this;
        }

        public Builder inputHandling(EndpointDefinition.InputDatumHandling inputDatumHandling) {
            this.product.datumHandling = inputDatumHandling;
            return this;
        }

        public Builder inputExecutionConstraint(EndpointDefinition.InputExecutionContraint executionConstraint) {
            this.product.executionContraint = executionConstraint;
            return this;
        }

        private void assertProductIsValid() {
            Objects.requireNonNull(this.product.internalEndpointName);
            Objects.requireNonNull(this.product.externalEndpointName);
            Objects.requireNonNull(this.product.workflowNodeIdentifier);
            if (this.product.isInputAdapter) {
                this.assertInputDefinitionsSet();
            }
        }

        private void assertInputDefinitionsSet() {
            if (this.product.datumHandling == null) {
                throw new IllegalStateException("Input handling must be set before constructing input adapter");
            }
            if (this.product.executionContraint == null) {
                throw new IllegalStateException("Input execution constraint must be set before constructing input adapter");
            }
        }

        public EndpointAdapter build() {
            this.assertProductIsValid();
            return this.product;
        }
    }
}

