/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.authorization;

import de.rcenvironment.core.gui.utils.common.ClipboardHelper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportGroupKeyDialog
extends Dialog {
    private static final int DEFAULT_TEXTFIELD_WIDTH = 300;
    private String groupKeyToExport = "";
    private Text exportGroupKeyTextfield;

    protected ExportGroupKeyDialog(Shell parentShell, String groupKeyToExport) {
        super(parentShell);
        this.groupKeyToExport = groupKeyToExport;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Export Group Key");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout containerLayout = new GridLayout(2, false);
        container.setLayout((Layout)containerLayout);
        Label exportGroupKeyLabel = new Label(container, 0);
        exportGroupKeyLabel.setText("Group Key to export: ");
        this.exportGroupKeyTextfield = new Text(container, 2056);
        GridData exportGroupKeyGridData = new GridData(4, 4, true, false);
        exportGroupKeyGridData.widthHint = 300;
        this.exportGroupKeyTextfield.setLayoutData((Object)exportGroupKeyGridData);
        this.exportGroupKeyTextfield.setText(this.groupKeyToExport);
        this.exportGroupKeyTextfield.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.exportGroupKeyTextfield.setSelection(0, this.exportGroupKeyTextfield.getText().length());
        Button copyToClipboardButton = new Button(container, 8);
        copyToClipboardButton.setText("Copy to Clipboard");
        GridData copyToClipboardButtonGridData = new GridData(4, 4, true, false);
        copyToClipboardButtonGridData.horizontalSpan = 2;
        copyToClipboardButtonGridData.horizontalAlignment = 131072;
        copyToClipboardButton.setLayoutData((Object)copyToClipboardButtonGridData);
        copyToClipboardButton.addSelectionListener((SelectionListener)new CopyToClipboardSelectionListener());
        return container;
    }

    private final class CopyToClipboardSelectionListener
    implements SelectionListener {
        private CopyToClipboardSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            ClipboardHelper.setContent((String)ExportGroupKeyDialog.this.exportGroupKeyTextfield.getText());
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }
    }
}

