/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.authorization;

import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.api.UserComponentIdMappingService;
import de.rcenvironment.core.component.authorization.api.NamedComponentAuthorizationSelector;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.model.api.ComponentImageContainerService;
import de.rcenvironment.core.gui.authorization.AuthorizationConstants;
import de.rcenvironment.core.gui.resources.api.ColorManager;
import de.rcenvironment.core.gui.resources.api.ColorSource;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardColors;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.util.Optional;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class AuthorizationLabelProvider
extends LabelProvider
implements IColorProvider {
    private static final String ERROR_FALLBACK_LABEL_TEXT = "<Error>";
    private final AuthorizationService authorizationService;
    private final UserComponentIdMappingService userComponentIdMappingService;
    private final DistributedComponentKnowledgeService componentRegistryService;
    private boolean showGroupID = false;
    private boolean showComponentID = false;

    public AuthorizationLabelProvider() {
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
        this.userComponentIdMappingService = (UserComponentIdMappingService)serviceRegistryAccess.getService(UserComponentIdMappingService.class);
        this.authorizationService = (AuthorizationService)serviceRegistryAccess.getService(AuthorizationService.class);
        this.componentRegistryService = (DistributedComponentKnowledgeService)serviceRegistryAccess.getService(DistributedComponentKnowledgeService.class);
    }

    public String getText(Object element) {
        if (element instanceof NamedComponentAuthorizationSelector) {
            return this.getNameForComponentAuthorizationSelector((NamedComponentAuthorizationSelector)element);
        }
        if (element instanceof AuthorizationAccessGroup) {
            return this.getNameForAuthorizationAccessGroup((AuthorizationAccessGroup)element);
        }
        return ERROR_FALLBACK_LABEL_TEXT;
    }

    private String getNameForComponentAuthorizationSelector(NamedComponentAuthorizationSelector selector) {
        String internalId;
        try {
            internalId = this.userComponentIdMappingService.fromExternalToInternalId(selector.getId());
        }
        catch (OperationFailureException operationFailureException) {
            this.logIdMappingFailure(selector.getId());
            return ERROR_FALLBACK_LABEL_TEXT;
        }
        boolean isAvailable = this.componentRegistryService.getCurrentSnapshot().getAllLocalInstallations().stream().anyMatch(entry -> entry.getComponentInterface().getIdentifier().equals(internalId));
        StringBuilder displayNameBuilder = new StringBuilder(selector.getDisplayName());
        if (this.showComponentID) {
            displayNameBuilder.append(" (" + selector.getId() + ")");
        }
        if (!isAvailable) {
            displayNameBuilder.append(" <not available>");
        }
        return displayNameBuilder.toString();
    }

    private void logIdMappingFailure(String externalId) {
        String logMessage = StringUtils.format((String)"Could not map external component id %s to internal id", (Object[])new Object[]{externalId});
        LogFactory.getLog(((Object)((Object)this)).getClass()).warn((Object)logMessage);
    }

    private String getNameForAuthorizationAccessGroup(AuthorizationAccessGroup group) {
        if (this.showGroupID || this.authorizationService.isPublicAccessGroup(group)) {
            return group.getDisplayName();
        }
        return group.getName();
    }

    public Image getImage(Object object) {
        if (object instanceof AuthorizationAccessGroup) {
            return this.getImageForAuthorizationAccessGroup((AuthorizationAccessGroup)object);
        }
        if (object instanceof NamedComponentAuthorizationSelector) {
            return this.getImageForComponentAuthorizationSelector((NamedComponentAuthorizationSelector)object);
        }
        return this.getDefaultImage();
    }

    private Image getDefaultImage() {
        return ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.RCE_LOGO_16);
    }

    private Image getImageForAuthorizationAccessGroup(AuthorizationAccessGroup group) {
        if (this.authorizationService.isPublicAccessGroup(group)) {
            return AuthorizationConstants.PUBLIC_ICON.createImage();
        }
        return AuthorizationConstants.GROUP_ICON.createImage();
    }

    private Image getImageForComponentAuthorizationSelector(NamedComponentAuthorizationSelector selector) {
        Optional<DistributedComponentEntry> firstMatchingEntry = this.componentRegistryService.getCurrentSnapshot().getAllInstallations().stream().filter(entry -> {
            try {
                String internalId = entry.getComponentInterface().getIdentifier();
                String externalId = this.userComponentIdMappingService.fromInternalToExternalId(internalId);
                return externalId.equals(selector.getId()) && entry.getType().isLocal();
            }
            catch (OperationFailureException operationFailureException) {
                this.logIdMappingFailure(selector.getId());
                return false;
            }
        }).findFirst();
        if (firstMatchingEntry.isPresent()) {
            return ((ComponentImageContainerService)ServiceRegistry.createAccessFor((Object)((Object)this)).getService(ComponentImageContainerService.class)).getComponentImageContainer(firstMatchingEntry.get().getComponentInterface()).getComponentIcon16();
        }
        return this.getDefaultIconForComponentAuthorizationSelector();
    }

    private Image getDefaultIconForComponentAuthorizationSelector() {
        return ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.INTEGRATED_TOOL_DEFAULT_16);
    }

    public void setShowGroupID(boolean showGroupID) {
        this.showGroupID = showGroupID;
    }

    public void setShowComponentID(boolean showComponentID) {
        this.showComponentID = showComponentID;
    }

    public Color getBackground(Object arg0) {
        return null;
    }

    public Color getForeground(Object element) {
        String internalId;
        if (!(element instanceof NamedComponentAuthorizationSelector)) {
            return null;
        }
        NamedComponentAuthorizationSelector selector = (NamedComponentAuthorizationSelector)element;
        try {
            internalId = this.userComponentIdMappingService.fromExternalToInternalId(selector.getId());
        }
        catch (OperationFailureException operationFailureException) {
            this.logIdMappingFailure(selector.getId());
            return null;
        }
        boolean isAvailable = this.componentRegistryService.getCurrentSnapshot().getAllLocalInstallations().stream().anyMatch(entry -> entry.getComponentInterface().getIdentifier().equals(internalId));
        if (isAvailable) {
            return null;
        }
        return ColorManager.getInstance().getSharedColor((ColorSource)StandardColors.RCE_DOVE_GRAY);
    }
}

