/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.log.internal;

import de.rcenvironment.core.log.RemotableLogReaderService;
import de.rcenvironment.core.log.SerializableLogEntry;
import de.rcenvironment.core.log.SerializableLogListener;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.toolkitbridge.transitional.StatsCounter;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedExecutionQueue;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;

public class RemotableLogReaderServiceImpl
implements RemotableLogReaderService {
    private static final long serialVersionUID = -7406557933348370062L;
    private LogReaderService osgiLogReaderService;
    private Map<SerializableLogListener, SingleReceiverOsgiLogForwarder> osgiLogForwardersByExternalListener = new HashMap<SerializableLogListener, SingleReceiverOsgiLogForwarder>();

    protected void bindLogReaderService(LogReaderService newLogReaderService) {
        this.osgiLogReaderService = newLogReaderService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AllowRemoteAccess
    public void addLogListener(SerializableLogListener externalListener) {
        SingleReceiverOsgiLogForwarder osgiLogForwarder = new SingleReceiverOsgiLogForwarder(externalListener);
        Map<SerializableLogListener, SingleReceiverOsgiLogForwarder> map = this.osgiLogForwardersByExternalListener;
        synchronized (map) {
            this.osgiLogForwardersByExternalListener.put(externalListener, osgiLogForwarder);
        }
        this.osgiLogReaderService.addLogListener((LogListener)osgiLogForwarder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AllowRemoteAccess
    public void removeLogListener(SerializableLogListener listener) {
        SingleReceiverOsgiLogForwarder osgiLogForwarder;
        Map<SerializableLogListener, SingleReceiverOsgiLogForwarder> map = this.osgiLogForwardersByExternalListener;
        synchronized (map) {
            osgiLogForwarder = this.osgiLogForwardersByExternalListener.remove(listener);
        }
        if (osgiLogForwarder != null) {
            osgiLogForwarder.shutdown();
            this.osgiLogReaderService.removeLogListener((LogListener)osgiLogForwarder);
        } else {
            LogFactory.getLog(this.getClass()).warn((Object)"Found no registered log forwarder for a remote listener");
        }
    }

    @Override
    @AllowRemoteAccess
    public List<SerializableLogEntry> getLog() {
        LinkedList<SerializableLogEntry> entries = new LinkedList<SerializableLogEntry>();
        Enumeration retrievedEntries = this.osgiLogReaderService.getLog();
        while (retrievedEntries.hasMoreElements()) {
            LogEntry entry = (LogEntry)retrievedEntries.nextElement();
            if (entry.getLevel() == 4) continue;
            String exceptionString = "";
            if (entry.getException() != null) {
                exceptionString = entry.getException().toString();
            }
            entries.add(entries.size(), new SerializableLogEntry(entry.getBundle().getSymbolicName(), entry.getLevel(), entry.getMessage().replaceAll("\n", "#RCEn"), entry.getTime(), exceptionString));
        }
        return entries;
    }

    private final class SingleReceiverOsgiLogForwarder
    implements LogListener {
        private static final String ASYNC_TASK_DESCRIPTION = "Forward log event to listener";
        private final SerializableLogListener externalListener;
        private final AsyncOrderedExecutionQueue orderedExecutionQueue = ConcurrencyUtils.getFactory().createAsyncOrderedExecutionQueue(AsyncCallbackExceptionPolicy.LOG_AND_CANCEL_LISTENER);

        private SingleReceiverOsgiLogForwarder(SerializableLogListener externalListener) {
            this.externalListener = externalListener;
        }

        public void logged(final LogEntry entry) {
            if (entry.getLevel() == 4) {
                return;
            }
            this.orderedExecutionQueue.enqueue(new Runnable(){

                @Override
                @TaskDescription(value="Forward log event to listener")
                public void run() {
                    try {
                        String exceptionString = "";
                        if (entry.getException() != null) {
                            exceptionString = entry.getException().toString();
                        }
                        SingleReceiverOsgiLogForwarder.this.externalListener.logged(new SerializableLogEntry(entry.getBundle().getSymbolicName(), entry.getLevel(), entry.getMessage().replaceAll("\n", "#RCEn"), entry.getTime(), exceptionString));
                    }
                    catch (RemoteOperationException e) {
                        Log localLog = LogFactory.getLog(this.getClass());
                        localLog.debug((Object)("Error while forwarding log event to listener (delivery of log events to this receiver will be cancelled): " + e.toString()));
                        SingleReceiverOsgiLogForwarder.this.orderedExecutionQueue.cancelAsync();
                    }
                    StatsCounter.count((String)"AsyncOrderedExecutionQueue dispatch", (String)SingleReceiverOsgiLogForwarder.ASYNC_TASK_DESCRIPTION);
                }
            });
        }

        public void shutdown() {
            this.orderedExecutionQueue.cancelAsync();
        }
    }
}

