/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.transport.jms.activemq.internal;

import de.rcenvironment.core.communication.channel.ServerContactPoint;
import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.transport.jms.activemq.internal.ActiveMQBroker;
import de.rcenvironment.core.communication.transport.jms.common.JmsArtifactFactory;
import de.rcenvironment.core.communication.transport.jms.common.JmsBroker;
import de.rcenvironment.core.communication.transport.jms.common.RemoteInitiatedMessageChannelFactory;
import de.rcenvironment.core.utils.common.StringUtils;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;

public class ActiveMQJmsFactory
implements JmsArtifactFactory {
    @Override
    public JmsBroker createBroker(ServerContactPoint scp, RemoteInitiatedMessageChannelFactory remoteInitiatedConnectionFactory) {
        return new ActiveMQBroker(scp, remoteInitiatedConnectionFactory);
    }

    @Override
    public ConnectionFactory createConnectionFactory(NetworkContactPoint ncp) {
        String url = StringUtils.format((String)"tcp://%s:%d?keepAlive=true", (Object[])new Object[]{ncp.getHost(), ncp.getPort()});
        ConnectionFactory connectionFactory = this.createConnectionFactory(url);
        return connectionFactory;
    }

    private ConnectionFactory createConnectionFactory(String url) {
        return new ActiveMQConnectionFactory(url);
    }
}

