/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.internal;

import de.rcenvironment.core.configuration.SecureStorageSection;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;

public class SecureStorageSectionSecurePreferencesImpl
implements SecureStorageSection {
    private static final String ERROR_MESSAGE_NO_NULL_KEYS_ALLOWED = "Secure Storage keys must not be null";
    private static final String VALUE_VERIFICATION_PREFIX = "val:";
    private static final String NULL_REPLACEMENT_VALUE = "null";
    private final String sectionId;
    private final ISecurePreferences securePrefsNode;

    public SecureStorageSectionSecurePreferencesImpl(String sectionId, ISecurePreferences securePrefsNode) {
        this.sectionId = sectionId;
        this.securePrefsNode = securePrefsNode;
    }

    @Override
    public void store(String key, String data) throws OperationFailureException {
        Objects.requireNonNull(key, ERROR_MESSAGE_NO_NULL_KEYS_ALLOWED);
        try {
            String valueToStore = data != null ? VALUE_VERIFICATION_PREFIX + data : NULL_REPLACEMENT_VALUE;
            this.securePrefsNode.put(key, valueToStore, true);
            this.securePrefsNode.flush();
        }
        catch (IOException | StorageException e) {
            throw new OperationFailureException("Failed to write secure storage entry " + this.entryDescription(key) + ": " + e.toString());
        }
    }

    @Override
    public String read(String key, String defaultValue) throws OperationFailureException {
        String storedValue;
        block5: {
            Objects.requireNonNull(key, ERROR_MESSAGE_NO_NULL_KEYS_ALLOWED);
            try {
                storedValue = this.securePrefsNode.get(key, null);
                if (storedValue == null) {
                    return defaultValue;
                }
                if (!NULL_REPLACEMENT_VALUE.equals(storedValue)) break block5;
                return null;
            }
            catch (StorageException e) {
                throw new OperationFailureException("Failed to read secure storage entry " + this.entryDescription(key) + ": " + e.toString());
            }
        }
        if (storedValue.startsWith(VALUE_VERIFICATION_PREFIX)) {
            return storedValue.substring(VALUE_VERIFICATION_PREFIX.length());
        }
        throw new OperationFailureException("Failed to read secure storage entry " + this.entryDescription(key) + ": the storage backend returned a value, but it did not pass the consistency check; " + "this is typically caused by a wrong or changed storage password");
    }

    @Override
    public void delete(String key) throws OperationFailureException {
        Objects.requireNonNull(key, ERROR_MESSAGE_NO_NULL_KEYS_ALLOWED);
        try {
            this.securePrefsNode.remove(key);
            this.securePrefsNode.flush();
        }
        catch (IOException e) {
            throw new OperationFailureException("Failed to delete secure storage entry " + this.entryDescription(key) + ": " + e.toString());
        }
    }

    @Override
    public String[] listKeys() {
        return this.securePrefsNode.keys();
    }

    private String entryDescription(String key) {
        return String.valueOf(key) + " in section " + this.sectionId;
    }
}

