/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.workflowintegration.editor.pages;

import de.rcenvironment.core.gui.integration.workflowintegration.editor.mappingtreenodes.MappingNode;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.pages.MappingTreeContentProvider;
import de.rcenvironment.core.utils.common.StringUtils;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TreeViewer;

public class MappingValidator
implements ICellEditorValidator {
    private TreeViewer treeViewer;
    private MappingTreeContentProvider contentProvider;

    public MappingValidator(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        this.contentProvider = (MappingTreeContentProvider)treeViewer.getContentProvider();
    }

    public String isValid(Object value) {
        if (value.toString().trim().isEmpty()) {
            return "The mapped name must have at least one character.";
        }
        MappingNode node = (MappingNode)this.treeViewer.getStructuredSelection().getFirstElement();
        if (!node.getExternalName().trim().equalsIgnoreCase(value.toString().trim()) && this.contentProvider.getMappedNamesOfOtherCheckedNodes(node).contains(value.toString().trim().toLowerCase())) {
            return StringUtils.format((String)"The mapped name \"%s\" already exists. Note: Names are not case sensitive.", (Object[])new Object[]{value.toString().trim()});
        }
        return null;
    }
}

