/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.script.execution.validator;

import de.rcenvironment.components.script.execution.validator.ScriptComponentValidator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ScriptComponentValidatorCache {
    private static final ScriptComponentValidatorCache INSTANCE = new ScriptComponentValidatorCache();
    private final ConcurrentMap<String, ScriptComponentValidator.PythonValidationResult> cache = new ConcurrentHashMap<String, ScriptComponentValidator.PythonValidationResult>();

    private ScriptComponentValidatorCache() {
    }

    public static ScriptComponentValidatorCache getCache() {
        return INSTANCE;
    }

    public boolean isPathValidated(String pythonPath) {
        if (pythonPath == null) {
            return false;
        }
        return this.cache.containsKey(pythonPath);
    }

    public ScriptComponentValidator.PythonValidationResult getValidationResult(String pythonPath) {
        return this.cache.getOrDefault(pythonPath, ScriptComponentValidator.PythonValidationResult.DEFAULT_NONE_PLACEHOLDER);
    }

    public void addOrUpdateValidationResult(ScriptComponentValidator.PythonValidationResult result) {
        if (result.isPlaceholder()) {
            return;
        }
        String pythonPath = result.getPythonPath();
        if (this.cache.containsKey(pythonPath)) {
            this.cache.replace(pythonPath, result);
            return;
        }
        this.cache.putIfAbsent(pythonPath, result);
    }
}

