/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.toolintegration.cpacs;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.component.integration.IntegrationContextType;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.gui.integration.toolintegration.api.ToolIntegrationWizardPage;
import de.rcenvironment.core.gui.integration.toolintegration.cpacs.Messages;
import de.rcenvironment.core.gui.integration.toolintegration.cpacs.RelativeXMLFilePathChooserButtonListener;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class CpacsConfigurationPage
extends ToolIntegrationWizardPage {
    private static final String HELP_CONTEXT_ID = "de.rcenvironment.core.gui.integration.toolintegration.cpacs.integration_cpacs";
    private static final String EMPTY_STRING = "";
    private static final String COLON = ":";
    private static final int INDEX_NULL = -1;
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Map<String, Object> configurationMap;
    private Button alwaysRunCheckbox;
    private Button toolSpecificInputCheckbox;
    private Label labelIncomingCpacsEndpoint;
    private Combo fileEndpointCombo;
    private Label labelInputMappingFile;
    private Text mappingInputFilename;
    private Button mappingInputFileChooser;
    private Label labelOutputMappingFile;
    private Text mappingOutputFilename;
    private Button mappingOutputFileChooser;
    private Label labelCpacsResultFilename;
    private Text cpacsResultFilename;
    private Label labelToolSpecificInput;
    private Label labelToolSpecificMapping;
    private Text toolSpecificInputdataFilename;
    private Text toolSpecificMappingFilename;
    private Button toolSpecificInputFileChooser;
    private Button toolSpecificMappingFileChooser;
    private Label labelToolInputFilename;
    private Label labelToolOutputFilename;
    private Text toolInputFilename;
    private Text toolOutputFilename;
    private final List<RelativeXMLFilePathChooserButtonListener> fileChooseListener = new ArrayList<RelativeXMLFilePathChooserButtonListener>();
    private Label labelOutgoingCpacsEndpoint;
    private Combo fileOutgoingEndpointCombo;
    private boolean pageBuild;

    protected CpacsConfigurationPage(String pageName, Map<String, Object> configurationMap) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(Messages.cpacsPageDescription);
        this.configurationMap = configurationMap;
        this.initDynamicEndpointConfiguration();
    }

    private void initDynamicEndpointConfiguration() {
        if (this.configurationMap.get("integrationType") != null && this.configurationMap.get("integrationType").equals(IntegrationContextType.CPACS.toString())) {
            ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
            try {
                Map inputs = (Map)mapper.readValue(((Object)((Object)this)).getClass().getResource("/resources/inputTemplate.json"), new HashMap().getClass());
                Map outputs = (Map)mapper.readValue(((Object)((Object)this)).getClass().getResource("/resources/outputTemplate.json"), new HashMap().getClass());
                this.configurationMap.put("dynamicInputs", inputs.get("dynamicInputs"));
                this.configurationMap.put("dynamicOutputs", outputs.get("dynamicOutputs"));
            }
            catch (IOException e) {
                this.logger.error((Object)("Could not read templates for dynamic inputs/outputs. " + e));
            }
        }
    }

    private void setDefaultConfigurations() {
        if (this.configurationMap.get("integrationType") != null && this.configurationMap.get("integrationType").equals(IntegrationContextType.CPACS.toString())) {
            this.configurationMap.put("setToolDirAsWorkingDir", Boolean.TRUE);
        }
    }

    public void setConfigMap(Map<String, Object> newConfigurationMap) {
        this.configurationMap = newConfigurationMap;
        this.initDynamicEndpointConfiguration();
        this.setDefaultConfigurations();
        this.updateSelectionListeners();
    }

    private void updateSelectionListeners() {
        for (RelativeXMLFilePathChooserButtonListener l : this.fileChooseListener) {
            l.updateConfiguration(this.configurationMap);
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        Group mappingsGroup = new Group(container, 0);
        mappingsGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Group toolSpecMappingsGroup = new Group(container, 0);
        toolSpecMappingsGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Group alwaysRunGroup = new Group(container, 0);
        alwaysRunGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout layout1 = new GridLayout(3, true);
        mappingsGroup.setLayout((Layout)layout1);
        mappingsGroup.setText(Messages.mappingTitle);
        GridLayout layout2 = new GridLayout(3, true);
        toolSpecMappingsGroup.setLayout((Layout)layout2);
        toolSpecMappingsGroup.setText(Messages.toolSpecMappingTitle);
        GridLayout layout3 = new GridLayout(1, true);
        alwaysRunGroup.setLayout((Layout)layout3);
        alwaysRunGroup.setText(Messages.executionOptionsTitle);
        this.createIncomingCpacsEndpointConfig((Composite)mappingsGroup);
        new Label((Composite)mappingsGroup, 0);
        this.createInputMappingConfig((Composite)mappingsGroup);
        this.createToolInputConfig((Composite)mappingsGroup);
        new Label((Composite)mappingsGroup, 0);
        this.createToolOutputConfig((Composite)mappingsGroup);
        new Label((Composite)mappingsGroup, 0);
        this.createToolOutputMappingConfig((Composite)mappingsGroup);
        this.createCpacsResultConfig((Composite)mappingsGroup);
        this.createOutgoingCpacsEndpointConfig((Composite)mappingsGroup);
        new Label((Composite)mappingsGroup, 0);
        this.createToolSpecificInputConfig((Composite)toolSpecMappingsGroup);
        this.createAlwaysRunConfig((Composite)alwaysRunGroup);
        new Label((Composite)alwaysRunGroup, 0);
        new Label((Composite)alwaysRunGroup, 0);
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), HELP_CONTEXT_ID);
        this.updatePageComplete();
        this.pageBuild = true;
    }

    private void createAlwaysRunConfig(Composite container) {
        this.alwaysRunCheckbox = new Button(container, 32);
        this.alwaysRunCheckbox.setText(Messages.alwaysRunCheckbox);
        this.alwaysRunCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                CpacsConfigurationPage.this.configurationMap.put("alwaysRun", !CpacsConfigurationPage.this.alwaysRunCheckbox.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
    }

    private void enableToolspecific(boolean enable) {
        this.labelToolSpecificInput.setEnabled(enable);
        this.toolSpecificInputdataFilename.setEnabled(enable);
        this.labelToolSpecificMapping.setEnabled(enable);
        this.toolSpecificMappingFilename.setEnabled(enable);
        this.toolSpecificInputFileChooser.setEnabled(enable);
        this.toolSpecificMappingFileChooser.setEnabled(enable);
        if (!enable) {
            this.toolSpecificInputdataFilename.setText(EMPTY_STRING);
            this.toolSpecificMappingFilename.setText(EMPTY_STRING);
        }
    }

    private void createToolSpecificInputConfig(Composite container) {
        this.toolSpecificInputCheckbox = new Button(container, 32);
        this.toolSpecificInputCheckbox.setText(Messages.toolSpecificInputCheckbox);
        this.toolSpecificInputCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (CpacsConfigurationPage.this.configurationMap.get("integrationType").equals(IntegrationContextType.CPACS.toString())) {
                    CpacsConfigurationPage.this.configurationMap.put("hasToolSpecificInput", CpacsConfigurationPage.this.toolSpecificInputCheckbox.getSelection());
                }
                CpacsConfigurationPage.this.enableToolspecific(CpacsConfigurationPage.this.toolSpecificInputCheckbox.getSelection());
                CpacsConfigurationPage.this.updatePageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        new Label(container, 0);
        new Label(container, 0);
        this.labelToolSpecificInput = new Label(container, 0);
        this.labelToolSpecificInput.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.labelToolSpecificInput.setText(String.valueOf(Messages.labelToolSpecificInput) + COLON);
        this.labelToolSpecificInput.setEnabled(false);
        this.toolSpecificInputdataFilename = new Text(container, 2048);
        this.toolSpecificInputdataFilename.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.toolSpecificInputdataFilename.setEnabled(false);
        this.toolSpecificInputdataFilename.addModifyListener((ModifyListener)new TextAreaModifyListener("toolspecificInputdataFilename"));
        this.toolSpecificInputFileChooser = new Button(container, 0);
        this.toolSpecificInputFileChooser.setText(Messages.fileChooser);
        RelativeXMLFilePathChooserButtonListener toolSpecificInputFileChooserListener = new RelativeXMLFilePathChooserButtonListener(Messages.labelToolInputFilename, this.toolSpecificInputdataFilename, this.getShell(), this.configurationMap);
        this.toolSpecificInputFileChooser.addSelectionListener((SelectionListener)toolSpecificInputFileChooserListener);
        this.fileChooseListener.add(toolSpecificInputFileChooserListener);
        this.toolSpecificInputFileChooser.setEnabled(false);
        this.labelToolSpecificMapping = new Label(container, 0);
        this.labelToolSpecificMapping.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.labelToolSpecificMapping.setText(String.valueOf(Messages.labelToolSpecificMapping) + COLON);
        this.labelToolSpecificMapping.setEnabled(false);
        this.toolSpecificMappingFilename = new Text(container, 2048);
        this.toolSpecificMappingFilename.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.toolSpecificMappingFilename.setEnabled(false);
        this.toolSpecificMappingFilename.addModifyListener((ModifyListener)new TextAreaModifyListener("toolspecificMappingFilename"));
        this.toolSpecificMappingFileChooser = new Button(container, 0);
        this.toolSpecificMappingFileChooser.setText(Messages.fileChooser);
        RelativeXMLFilePathChooserButtonListener toolSpecificMappingFileChooserListener = new RelativeXMLFilePathChooserButtonListener(Messages.labelToolSpecificMapping, this.toolSpecificMappingFilename, this.getShell(), this.configurationMap);
        this.toolSpecificMappingFileChooser.addSelectionListener((SelectionListener)toolSpecificMappingFileChooserListener);
        this.fileChooseListener.add(toolSpecificMappingFileChooserListener);
        this.toolSpecificMappingFileChooser.setEnabled(false);
    }

    private void createCpacsResultConfig(Composite container) {
        this.labelCpacsResultFilename = new Label(container, 0);
        this.labelCpacsResultFilename.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.labelCpacsResultFilename.setText(String.valueOf(Messages.labelCpacsResultFilename) + COLON);
        this.cpacsResultFilename = new Text(container, 2048);
        this.cpacsResultFilename.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cpacsResultFilename.addModifyListener((ModifyListener)new TextAreaModifyListener("cpacsResultFilename"));
        new Label(container, 0);
    }

    private void createToolOutputMappingConfig(Composite container) {
        this.labelOutputMappingFile = new Label(container, 0);
        this.labelOutputMappingFile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.labelOutputMappingFile.setText(String.valueOf(Messages.labelOutputMappingFile) + COLON);
        this.mappingOutputFilename = new Text(container, 2048);
        this.mappingOutputFilename.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mappingOutputFilename.addModifyListener((ModifyListener)new TextAreaModifyListener("mappingOutputFilename"));
        this.mappingOutputFileChooser = new Button(container, 0);
        this.mappingOutputFileChooser.setText(Messages.fileChooser);
        RelativeXMLFilePathChooserButtonListener mappingOutputFileChooserListener = new RelativeXMLFilePathChooserButtonListener(Messages.labelOutputMappingFile, this.mappingOutputFilename, this.getShell(), this.configurationMap);
        this.mappingOutputFileChooser.addSelectionListener((SelectionListener)mappingOutputFileChooserListener);
        this.fileChooseListener.add(mappingOutputFileChooserListener);
    }

    private void createToolOutputConfig(Composite container) {
        this.labelToolOutputFilename = new Label(container, 0);
        this.labelToolOutputFilename.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.labelToolOutputFilename.setText(String.valueOf(Messages.labelToolOutputFilename) + COLON);
        this.toolOutputFilename = new Text(container, 2048);
        this.toolOutputFilename.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.toolOutputFilename.addModifyListener((ModifyListener)new TextAreaModifyListener("toolOutputFilename"));
    }

    private void createToolInputConfig(Composite container) {
        this.labelToolInputFilename = new Label(container, 0);
        this.labelToolInputFilename.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.labelToolInputFilename.setText(String.valueOf(Messages.labelToolInputFilename) + COLON);
        this.toolInputFilename = new Text(container, 2048);
        this.toolInputFilename.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.toolInputFilename.addModifyListener((ModifyListener)new TextAreaModifyListener("toolInputFileName"));
    }

    private void createInputMappingConfig(Composite container) {
        this.labelInputMappingFile = new Label(container, 0);
        this.labelInputMappingFile.setText(String.valueOf(Messages.labelInputMappingFile) + COLON);
        this.labelInputMappingFile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mappingInputFilename = new Text(container, 2048);
        this.mappingInputFilename.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mappingInputFilename.addModifyListener((ModifyListener)new TextAreaModifyListener("mappingInputFilename"));
        this.mappingInputFileChooser = new Button(container, 0);
        this.mappingInputFileChooser.setText(Messages.fileChooser);
        RelativeXMLFilePathChooserButtonListener mappingInputFileChooserListener = new RelativeXMLFilePathChooserButtonListener(Messages.labelInputMappingFile, this.mappingInputFilename, this.getShell(), this.configurationMap);
        this.mappingInputFileChooser.addSelectionListener((SelectionListener)mappingInputFileChooserListener);
        this.fileChooseListener.add(mappingInputFileChooserListener);
    }

    private void createIncomingCpacsEndpointConfig(Composite container) {
        this.labelIncomingCpacsEndpoint = new Label(container, 0);
        this.labelIncomingCpacsEndpoint.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.labelIncomingCpacsEndpoint.setText(String.valueOf(Messages.labelIncomingCpacsEndpoint) + COLON);
        this.fileEndpointCombo = new Combo(container, 8);
        this.fileEndpointCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fileEndpointCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CpacsConfigurationPage.this.configurationMap.put("cpacsInitialEndpointName", CpacsConfigurationPage.this.fileEndpointCombo.getItem(CpacsConfigurationPage.this.fileEndpointCombo.getSelectionIndex()));
                CpacsConfigurationPage.this.updatePageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createOutgoingCpacsEndpointConfig(Composite container) {
        this.labelOutgoingCpacsEndpoint = new Label(container, 0);
        this.labelOutgoingCpacsEndpoint.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.labelOutgoingCpacsEndpoint.setText(String.valueOf(Messages.labelOutgoingCpacsEndpoint) + COLON);
        this.fileOutgoingEndpointCombo = new Combo(container, 8);
        this.fileOutgoingEndpointCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fileOutgoingEndpointCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CpacsConfigurationPage.this.configurationMap.put("cpacsOutgoingEndpointName", CpacsConfigurationPage.this.fileOutgoingEndpointCombo.getItem(CpacsConfigurationPage.this.fileOutgoingEndpointCombo.getSelectionIndex()));
                CpacsConfigurationPage.this.updatePageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    public void updatePage() {
        if (this.getControl() != null && this.pageBuild && this.configurationMap.get("integrationType") != null && this.configurationMap.get("integrationType").equals(IntegrationContextType.CPACS.toString())) {
            this.updateComboBoxes(this.fileEndpointCombo, "inputs");
            this.updateComboBoxes(this.fileOutgoingEndpointCombo, "outputs");
            if (this.fileEndpointCombo.getSelectionIndex() < 0 && this.configurationMap.get("cpacsInitialEndpointName") != null && this.configurationMap.get("cpacsInitialEndpointName") != EMPTY_STRING) {
                this.configurationMap.put("cpacsInitialEndpointName", EMPTY_STRING);
            }
            if ((String)this.configurationMap.get("mappingInputFilename") != null) {
                this.mappingInputFilename.setText((String)this.configurationMap.get("mappingInputFilename"));
            } else {
                this.mappingInputFilename.setText(EMPTY_STRING);
            }
            if ((String)this.configurationMap.get("toolInputFileName") != null) {
                this.toolInputFilename.setText((String)this.configurationMap.get("toolInputFileName"));
            } else {
                this.toolInputFilename.setText(EMPTY_STRING);
            }
            if ((String)this.configurationMap.get("toolOutputFilename") != null) {
                this.toolOutputFilename.setText((String)this.configurationMap.get("toolOutputFilename"));
            } else {
                this.toolOutputFilename.setText(EMPTY_STRING);
            }
            if ((String)this.configurationMap.get("mappingOutputFilename") != null) {
                this.mappingOutputFilename.setText((String)this.configurationMap.get("mappingOutputFilename"));
            } else {
                this.mappingOutputFilename.setText(EMPTY_STRING);
            }
            if ((String)this.configurationMap.get("cpacsResultFilename") != null) {
                this.cpacsResultFilename.setText((String)this.configurationMap.get("cpacsResultFilename"));
            } else {
                this.cpacsResultFilename.setText(EMPTY_STRING);
            }
            if ((Boolean)this.configurationMap.get("hasToolSpecificInput") == null && this.configurationMap.get("integrationType").equals(IntegrationContextType.CPACS.toString())) {
                this.configurationMap.put("hasToolSpecificInput", false);
            }
            if ((Boolean)this.configurationMap.get("hasToolSpecificInput") != null) {
                this.toolSpecificInputCheckbox.setSelection(((Boolean)this.configurationMap.get("hasToolSpecificInput")).booleanValue());
            }
            this.enableToolspecific(this.toolSpecificInputCheckbox.getSelection());
            if ((String)this.configurationMap.get("toolspecificInputdataFilename") != null) {
                this.toolSpecificInputdataFilename.setText((String)this.configurationMap.get("toolspecificInputdataFilename"));
            } else {
                this.toolSpecificInputdataFilename.setText(EMPTY_STRING);
            }
            if ((String)this.configurationMap.get("toolspecificMappingFilename") != null) {
                this.toolSpecificMappingFilename.setText((String)this.configurationMap.get("toolspecificMappingFilename"));
            } else {
                this.toolSpecificMappingFilename.setText(EMPTY_STRING);
            }
            if ((Boolean)this.configurationMap.get("alwaysRun") == null) {
                this.configurationMap.put("alwaysRun", true);
            }
            this.alwaysRunCheckbox.setSelection((Boolean)this.configurationMap.get("alwaysRun") == false);
            this.updatePageComplete();
        }
    }

    private void updateComboBoxes(Combo combo, String direction) {
        String cpacsEndpoint;
        String type = direction.equals("outputs") ? "cpacsOutgoingEndpointName" : "cpacsInitialEndpointName";
        this.addAllFileEndpoints(combo, direction, type);
        if (combo.getItemCount() > 0 && combo.getSelectionIndex() >= 0 && ((String)this.configurationMap.get(type) == null || ((String)this.configurationMap.get(type)).equals(EMPTY_STRING))) {
            this.configurationMap.put(type, combo.getItem(combo.getSelectionIndex()));
        }
        if ((cpacsEndpoint = (String)this.configurationMap.get(type)) != null && combo.indexOf(cpacsEndpoint) != -1) {
            combo.select(combo.indexOf(cpacsEndpoint));
        } else if (cpacsEndpoint != null && combo.indexOf(cpacsEndpoint) == -1) {
            this.configurationMap.put(type, EMPTY_STRING);
        }
    }

    private void addAllFileEndpoints(Combo combo, String direction, String type) {
        combo.removeAll();
        List endpointList = (List)this.configurationMap.get(direction);
        if (endpointList != null) {
            for (Map endpoint : endpointList) {
                if (DataType.valueOf((String)((String)endpoint.get("endpointDataType"))) != DataType.FileReference) continue;
                combo.add((String)endpoint.get("endpointName"));
            }
            if (combo.getItemCount() > 0 && this.configurationMap.get(type) == null) {
                combo.select(0);
            }
        }
    }

    private void updatePageComplete() {
        boolean toolSpecificInputConfigNotEmpty;
        boolean configsNotNull = (Boolean)this.configurationMap.get("hasToolSpecificInput") != null && (Boolean)this.configurationMap.get("alwaysRun") != null && (String)this.configurationMap.get("toolspecificMappingFilename") != null && (String)this.configurationMap.get("toolspecificInputdataFilename") != null && (String)this.configurationMap.get("mappingInputFilename") != null && (String)this.configurationMap.get("toolInputFileName") != null && (String)this.configurationMap.get("toolOutputFilename") != null && (String)this.configurationMap.get("mappingOutputFilename") != null && (String)this.configurationMap.get("cpacsResultFilename") != null && (String)this.configurationMap.get("cpacsInitialEndpointName") != null && (String)this.configurationMap.get("cpacsOutgoingEndpointName") != null;
        boolean generalConfigNotEmpty = configsNotNull && !((String)this.configurationMap.get("cpacsInitialEndpointName")).equals(EMPTY_STRING) && !((String)this.configurationMap.get("cpacsOutgoingEndpointName")).equals(EMPTY_STRING) && !((String)this.configurationMap.get("mappingInputFilename")).equals(EMPTY_STRING) && !((String)this.configurationMap.get("toolInputFileName")).equals(EMPTY_STRING) && !((String)this.configurationMap.get("toolOutputFilename")).equals(EMPTY_STRING) && !((String)this.configurationMap.get("mappingOutputFilename")).equals(EMPTY_STRING) && !((String)this.configurationMap.get("cpacsResultFilename")).equals(EMPTY_STRING);
        boolean bl = toolSpecificInputConfigNotEmpty = configsNotNull && ((Boolean)this.configurationMap.get("hasToolSpecificInput") == false || !((String)this.configurationMap.get("toolspecificMappingFilename")).equals(EMPTY_STRING) && !((String)this.configurationMap.get("toolspecificInputdataFilename")).equals(EMPTY_STRING));
        if (this.fileEndpointCombo.getItemCount() == 0) {
            this.setMessage(Messages.errorNoInput, 3);
        } else {
            this.setMessage(null, 0);
        }
        if (this.fileOutgoingEndpointCombo.getItemCount() == 0 && this.getMessage() == null) {
            this.setMessage(Messages.errorNoOutput, 3);
        }
        if (generalConfigNotEmpty && toolSpecificInputConfigNotEmpty) {
            this.setPageComplete(true);
            this.setMessage(null, 0);
        } else {
            this.setPageComplete(false);
            if (this.getMessage() == null) {
                this.setMessage(Messages.configurationValueMissing, 3);
            }
        }
    }

    protected boolean isCurrentPage() {
        return super.isCurrentPage();
    }

    public void performHelp() {
        super.performHelp();
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.displayHelp(HELP_CONTEXT_ID);
    }

    private class TextAreaModifyListener
    implements ModifyListener {
        private final String key;

        TextAreaModifyListener(String key) {
            this.key = key;
        }

        public void modifyText(ModifyEvent arg0) {
            if (CpacsConfigurationPage.this.configurationMap != null && CpacsConfigurationPage.this.configurationMap.get("integrationType") != null && CpacsConfigurationPage.this.configurationMap.get("integrationType").equals(IntegrationContextType.CPACS.toString())) {
                CpacsConfigurationPage.this.configurationMap.put(this.key, ((Text)arg0.getSource()).getText());
            }
            CpacsConfigurationPage.this.updatePageComplete();
        }
    }
}

