/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.xpathchooser.model;

import de.rcenvironment.core.gui.xpathchooser.model.AbstractXSDTreeItem;
import de.rcenvironment.core.gui.xpathchooser.model.AbstractXSDValueHolder;
import de.rcenvironment.core.gui.xpathchooser.model.XSDAttribute;
import de.rcenvironment.core.gui.xpathchooser.model.XSDDocument;
import de.rcenvironment.core.gui.xpathchooser.model.XSDElement;
import de.rcenvironment.core.gui.xpathchooser.model.XSDValue;
import de.rcenvironment.core.gui.xpathchooser.model.XSDValueHolder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class XSDGenerator {
    private static final int NOT_FOUND = -1;

    private XSDGenerator() {
    }

    public static XSDDocument generate(String filename) throws XMLStreamException, IOException {
        File file = new File(filename);
        return XSDGenerator.generate(file);
    }

    public static XSDDocument generate(File file) throws XMLStreamException, IOException {
        FileReader is = new FileReader(file);
        XSDDocument xsdDocument = XSDGenerator.generate(is);
        is.close();
        return xsdDocument;
    }

    public static XSDDocument generate(Reader stream) throws XMLStreamException {
        XSDDocument document = new XSDDocument();
        AbstractXSDTreeItem current = null;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader parser = factory.createXMLStreamReader(stream);
        int curLevel = -1;
        HashMap elementsOnLevel = new HashMap();
        elementsOnLevel.put(curLevel + 1, new ArrayList());
        block0: while (true) {
            int event;
            if ((event = parser.next()) == 8) break;
            if (event == 1) {
                List levelList = (List)elementsOnLevel.get(++curLevel);
                elementsOnLevel.put(curLevel + 1, new ArrayList());
                XSDElement element = new XSDElement((XSDElement)current, parser.getLocalName());
                if (current == null) {
                    document.getElements().add(element);
                } else {
                    int index = ((XSDElement)current).getElements().indexOf(element);
                    if (index != -1) {
                        element = ((XSDElement)current).getElements().get(index);
                    } else {
                        ((XSDElement)current).getElements().add(element);
                    }
                }
                current = element;
                if (!levelList.contains(element)) {
                    levelList.add(element);
                }
                if (current == null) continue;
                int i = 0;
                while (true) {
                    if (i >= parser.getAttributeCount()) continue block0;
                    XSDAttribute attribute = new XSDAttribute((XSDElement)current, parser.getAttributeLocalName(i).toString());
                    int index = ((XSDElement)current).getAttributes().indexOf(attribute);
                    if (index != -1) {
                        attribute = ((XSDElement)current).getAttributes().get(index);
                    } else {
                        ((XSDElement)current).getAttributes().add(attribute);
                    }
                    XSDValue attValue = new XSDValue(attribute, parser.getAttributeValue(i));
                    if (!attribute.getValues().contains(attValue)) {
                        attribute.getValues().add(attValue);
                    }
                    ++i;
                }
            }
            if (event == 4) {
                String tmp = parser.getText().trim();
                if (tmp.equals("")) continue;
                XSDValue value = new XSDValue((XSDValueHolder)((Object)current), tmp);
                if (current == null || ((AbstractXSDValueHolder)current).getValues().contains(value)) continue;
                ((AbstractXSDValueHolder)current).getValues().add(value);
                continue;
            }
            if (current == null || event != 2) continue;
            current = (XSDElement)current.getParent();
            --curLevel;
        }
        parser.close();
        return document;
    }
}

