/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.xpathchooser;

import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.xpathchooser.XPathChooserHelper;
import de.rcenvironment.core.gui.xpathchooser.model.XSDAttribute;
import de.rcenvironment.core.gui.xpathchooser.model.XSDElement;
import de.rcenvironment.core.gui.xpathchooser.model.XSDValue;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public final class XSDLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String COMBO_HINT = "%s  ...";
    private final Image imageElement;
    private final Image imageElements;
    private final Image imageAttribute;
    private Image imageAttributes;
    private final Image imageValue;
    private final Image imageValues;
    private XPathChooserHelper helper;

    public XSDLabelProvider(XPathChooserHelper aHelper) {
        this.helper = aHelper;
        this.imageElement = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.ELEMENT);
        this.imageElements = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.ELEMENTS);
        this.imageAttribute = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.ATTRIBUTE);
        this.imageAttributes = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.ATTRIBUTES);
        this.imageValue = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.COMMON_TEXT_16);
        this.imageValues = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.COMMON_TEXT_NODES_16);
    }

    public String getColumnText(Object element, int column) {
        String string;
        if (element == null || !(element instanceof XSDElement)) {
            return null;
        }
        XSDElement e = (XSDElement)element;
        if ((column == 1 || column == 2) && e.getCurrentAttributeName() == null) {
            this.addElementAttributes(e);
        }
        switch (column) {
            case 0: {
                return e.getName();
            }
            case 1: {
                string = e.getCurrentAttributeName();
                break;
            }
            case 2: {
                string = e.getCurrentAttributeValue();
                break;
            }
            default: {
                return "";
            }
        }
        if (this.helper.getAttributeValuesForCurrentTreeItem(e, column).length > 1) {
            string = StringUtils.format((String)COMBO_HINT, (Object[])new Object[]{string});
        }
        return string;
    }

    public Image getColumnImage(Object element, int column) {
        if (element == null || !(element instanceof XSDElement)) {
            return null;
        }
        XSDElement e = (XSDElement)element;
        if (column == 1 || column == 2) {
            if (e.getCurrentAttributeName() == null) {
                this.addElementAttributes(e);
            }
            if (e.getCurrentAttributeName().equals("")) {
                return null;
            }
        }
        switch (column) {
            case 0: {
                if (!e.getElements().isEmpty()) {
                    return this.imageElements;
                }
                return this.imageElement;
            }
            case 1: {
                if (this.helper.getAttributeValuesForCurrentTreeItem(e, column).length > 1) {
                    return this.imageAttributes;
                }
                return this.imageAttribute;
            }
            case 2: {
                if (this.helper.getAttributeValuesForCurrentTreeItem(e, column).length > 1) {
                    return this.imageValues;
                }
                return this.imageValue;
            }
        }
        return null;
    }

    private void addElementAttributes(XSDElement e) {
        HashSet<String> values = new HashSet<String>();
        for (XSDAttribute a : e.getAttributes()) {
            if (!a.getName().equals("")) {
                for (XSDValue value : a.getValues()) {
                    values.add(value.getName());
                }
                e.setAttributeValues(a.getName(), values);
            }
            values.clear();
        }
        Object[] names = e.getAttributeNames();
        if (names.length == 0) {
            e.setAttributeName("");
            e.setAttributeValue("");
        } else {
            Arrays.sort(names);
            e.setAttributeName((String)names[0]);
            String[] tmp = e.getAttributeValues();
            if (tmp.length == 0) {
                e.setAttributeValue("");
            } else {
                e.setAttributeValue(tmp[0]);
            }
        }
    }
}

