/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.internal;

import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ManagedInstance;
import java.io.File;
import java.util.LinkedList;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GildedManagedInstance {
    private final ManagedInstance instance;
    private final Consumer<String> commandConsolePrinter;
    private final Function<String, String> executeActionOnInstance;

    public GildedManagedInstance(ManagedInstance instance, Consumer<String> commandConsolePrinter, BiFunction<ManagedInstance, String, String> executeActionOnInstance) {
        this.instance = instance;
        this.commandConsolePrinter = commandConsolePrinter;
        this.executeActionOnInstance = command -> (String)executeActionOnInstance.apply(this.instance, (String)command);
    }

    private void printToCommandConsole(String message) {
        this.commandConsolePrinter.accept(message);
    }

    private String executeCommandOnInstance(String action) {
        return this.executeActionOnInstance.apply(action);
    }

    public String exportWorkflowRun(File tmpDirInst, String workflowRun) throws OperationFailureException {
        String outputExportInst = this.executeCommandOnInstance(StringUtils.format((String)"tc export_wf_run %s %s", (Object[])new Object[]{tmpDirInst, workflowRun}));
        this.printToCommandConsole(outputExportInst);
        if (!outputExportInst.contains("Successfully exported workflowrun.")) {
            throw new OperationFailureException(StringUtils.format((String)"Export of workflow run %s on instance %s failed", (Object[])new Object[]{workflowRun, this.instance}));
        }
        return StringUtils.format((String)"%s\\%s.json", (Object[])new Object[]{tmpDirInst, workflowRun.replace(":", "_")});
    }

    public boolean compareWorkflowRuns(String masterPath, String exportedRunPath) {
        String outputComparison = this.executeCommandOnInstance(StringUtils.format((String)"tc compare_wf_runs %s %s", (Object[])new Object[]{masterPath, exportedRunPath}));
        this.printToCommandConsole(outputComparison);
        return outputComparison.contains("The compared workflow runs are identical.");
    }

    public Iterable<String> findWorkflowRunsByPattern(String workflowName) {
        String commandOutput = this.executeCommandOnInstance("wf");
        Pattern p = Pattern.compile("'(" + workflowName + "[\\d-_:]+)'");
        Matcher m = p.matcher(commandOutput);
        LinkedList<String> returnValue = new LinkedList<String>();
        while (m.find()) {
            returnValue.add(m.group(1));
        }
        return returnValue;
    }
}

