/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.bootstrap.internal;

import de.rcenvironment.core.configuration.bootstrap.BootstrapConfiguration;
import de.rcenvironment.core.configuration.bootstrap.ParameterException;
import de.rcenvironment.core.configuration.bootstrap.RuntimeDetection;
import de.rcenvironment.core.configuration.bootstrap.SystemExitException;
import de.rcenvironment.core.configuration.bootstrap.profile.ProfileException;
import de.rcenvironment.core.configuration.bootstrap.ui.ErrorTextUI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final String PROP_RCE_LAUNCHER = "de.rcenvironment.launcher";
    private static final String RCE_LAUNCHER_NOT_USED_ERROR_MESSAGE = "RCE was not started with the RCE launcher.";

    public void start(BundleContext arg0) {
        String schibboleth;
        if (!(RuntimeDetection.isTestEnvironment() || (schibboleth = System.getProperty(PROP_RCE_LAUNCHER)) != null && schibboleth.equals(PROP_RCE_LAUNCHER))) {
            Logger.getLogger("bootstrap").log(Level.SEVERE, RCE_LAUNCHER_NOT_USED_ERROR_MESSAGE);
            new ErrorTextUI(RCE_LAUNCHER_NOT_USED_ERROR_MESSAGE).run();
            System.exit(0);
        }
        try {
            BootstrapConfiguration.initialize();
        }
        catch (ParameterException | ProfileException e) {
            new ErrorTextUI(e.getMessage()).run();
            Logger.getLogger("bootstrap").log(Level.SEVERE, "Error in early startup", e);
            System.exit(0);
        }
        catch (SystemExitException e) {
            System.exit(e.getExitCode());
        }
    }

    public void stop(BundleContext arg0) {
    }
}

