/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.converger.execution.validator;

import de.rcenvironment.components.converger.execution.Messages;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.spi.AbstractLoopComponentValidator;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class ConvergerComponentValidator
extends AbstractLoopComponentValidator {
    public String getIdentifier() {
        return "de.rcenvironment.converger";
    }

    protected List<ComponentValidationMessage> validateLoopComponentSpecific(ComponentDescription componentDescription) {
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        boolean hasInputs = this.hasInputs(componentDescription);
        if (!hasInputs) {
            ComponentValidationMessage noInputMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, "", Messages.noInput, Messages.noInput);
            messages.add(noInputMessage);
        }
        this.checkIfDefined(componentDescription, "epsA", messages);
        this.checkIfDefined(componentDescription, "epsR", messages);
        this.checkIfDefined(componentDescription, "iterationsToConsider", messages);
        return messages;
    }

    protected List<ComponentValidationMessage> validateOnWorkflowStartComponentSpecific(ComponentDescription componentDescription) {
        return null;
    }

    private void checkIfDefined(ComponentDescription componentDescription, String key, List<ComponentValidationMessage> messages) {
        String prop = this.getProperty(componentDescription, key);
        if (prop == null || prop.isEmpty()) {
            String text = StringUtils.format((String)"'%s' is not defined", (Object[])new Object[]{this.getPropertyDisplayName(key)});
            messages.add(new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, key, text, text));
        }
    }

    private String getPropertyDisplayName(String key) {
        if (key.equals("epsA")) {
            return "Absolute convergence";
        }
        if (key.equals("epsR")) {
            return "Relative convergence";
        }
        if (key.equals("iterationsToConsider")) {
            return "Iterations to consider";
        }
        return "";
    }
}

