/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.converger.execution;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.rcenvironment.components.converger.common.ConvergerComponentConstants;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.component.update.api.PersistentComponentDescriptionUpdaterUtils;
import de.rcenvironment.core.component.update.spi.PersistentComponentDescriptionUpdater;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.FloatTD;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;

public class ConvergerPersistentComponentDescriptionUpdater
implements PersistentComponentDescriptionUpdater {
    private static final String START_SUFFIX = "_start";
    private static final String CONVERGED_SUFFIX = "_converged";
    private static final String OUTER_LOOP_DONE = "outerLoopDone";
    private static final String REQUIRED = "Required";
    private static final String INPUT_EXECUTION_CONSTRAINT = "inputExecutionConstraint_4aae3eea";
    private static final String VALUE_TO_CONVERGE = "valueToConverge";
    private static final String SELF_LOOP_ENDPOINT = "SelfLoopEndpoint";
    private static final String LOOP_ENDPOINT_TYPE = "loopEndpointType_5e0ed1cd";
    private static final String OUTER_LOOP_ENDPOINT = "OuterLoopEndpoint";
    private static final String METADATA = "metadata";
    private static final String BOOLEAN = "Boolean";
    private static final String IDENTIFIER = "identifier";
    private static final String NAME = "name";
    private static final String DATATYPE = "datatype";
    private static final String DYNAMIC_OUTPUTS = "dynamicOutputs";
    private static final String DYNAMIC_INPUTS = "dynamicInputs";
    private static final String V1_0 = "1.0";
    private static final String CONFIGURATION = "configuration";
    private static final String EP_IDENTIFIER = "epIdentifier";
    private static final String COLON = ":";
    private static final String STATIC_OUTPUTS = "staticOutputs";
    private static final String STATIC_INPUTS = "staticInputs";
    private static final String V3_0 = "3.0";
    private static final String V3_1 = "3.1";
    private static final String V3_2 = "3.2";
    private static final String V4_0 = "4.0";
    private static final String V4_1 = "4.1";
    private static final String V5_0 = "5";
    private static final String V5_1 = "5.1";
    private static final String V5_1_1 = "5.1.1";
    private static final String V6 = "6";
    private static TypedDatumService typedDatumService;

    public String[] getComponentIdentifiersAffectedByUpdate() {
        return ConvergerComponentConstants.COMPONENT_IDS;
    }

    public int getFormatVersionsAffectedByUpdate(String persistentComponentDescriptionVersion, boolean silent) {
        int versions = 0;
        if (!(silent || persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo(V1_0) >= 0)) {
            versions |= 1;
        }
        if (!silent && persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo(V3_0) < 0) {
            versions |= 2;
        }
        if (!silent && persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo(V6) < 0) {
            versions |= 4;
        }
        if (silent && persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo(V5_1_1) < 0) {
            versions |= 4;
        }
        return versions;
    }

    public PersistentComponentDescription performComponentDescriptionUpdate(int formatVersion, PersistentComponentDescription description, boolean silent) throws IOException {
        block40: {
            block38: {
                block41: {
                    block39: {
                        if (silent) break block38;
                        if (formatVersion != 1) break block39;
                        description = this.firstUpdate(description);
                        description.setComponentVersion(V1_0);
                        break block40;
                    }
                    if (formatVersion != 2) break block41;
                    description = this.secondUpdate(description);
                    description.setComponentVersion(V3_0);
                    break block40;
                }
                if (formatVersion != 4) break block40;
                switch (description.getComponentVersion()) {
                    case "3.0": {
                        description = this.updateFrom30To31(description);
                    }
                    case "3.1": {
                        description = this.updateFrom31To32(description);
                    }
                    case "3.2": {
                        description = this.updateFrom32To40(description);
                    }
                    case "4.0": {
                        description = this.updateFrom40To41(description);
                    }
                    case "4.1": {
                        description = this.updateFrom41To5(description);
                    }
                    case "5": {
                        description = this.updateFrom50To51(description);
                    }
                    case "5.1": {
                        description = this.updateFrom51To511(description);
                    }
                    case "5.1.1": {
                        description = this.updateFrom511To6(description);
                    }
                }
                break block40;
            }
            if (formatVersion != 4) break block40;
            switch (description.getComponentVersion()) {
                case "5": {
                    description = this.updateFrom50To51(description);
                }
                case "5.1": {
                    description = this.updateFrom51To511(description);
                }
            }
        }
        return description;
    }

    private PersistentComponentDescription updateFrom511To6(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        description = PersistentComponentDescriptionUpdaterUtils.removeOuterLoopDoneEndpoints((PersistentComponentDescription)description);
        description = PersistentComponentDescriptionUpdaterUtils.removeEndpointCharacterInfoFromMetaData((PersistentComponentDescription)description);
        description = PersistentComponentDescriptionUpdaterUtils.reassignEndpointIdentifiers((PersistentComponentDescription)description, (String)DYNAMIC_INPUTS, (String)"toForward", (String)"startToForward", (String)START_SUFFIX);
        description = PersistentComponentDescriptionUpdaterUtils.reassignEndpointIdentifiers((PersistentComponentDescription)description, (String)DYNAMIC_OUTPUTS, (String)"toForward", (String)"finalToForward", (String)CONVERGED_SUFFIX);
        description = PersistentComponentDescriptionUpdaterUtils.reassignEndpointIdentifiers((PersistentComponentDescription)description, (String)DYNAMIC_INPUTS, (String)VALUE_TO_CONVERGE, (String)"startToConverge", (String)START_SUFFIX);
        description = PersistentComponentDescriptionUpdaterUtils.reassignEndpointIdentifiers((PersistentComponentDescription)description, (String)DYNAMIC_OUTPUTS, (String)VALUE_TO_CONVERGE, (String)"finalToConverge", (String)CONVERGED_SUFFIX);
        description.setComponentVersion(V6);
        return description;
    }

    private PersistentComponentDescription updateFrom51To511(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        description = PersistentComponentDescriptionUpdaterUtils.updateFaultToleranceOfLoopDriver((PersistentComponentDescription)description);
        description.setComponentVersion(V5_1_1);
        return description;
    }

    private PersistentComponentDescription updateFrom50To51(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ObjectNode configNode = (ObjectNode)node.get(CONFIGURATION);
        configNode.put("notConvIgnore", true);
        configNode.put("notConvFail", false);
        configNode.put("notConvNotAValue", false);
        JsonNode dynamicOutputs = node.get(DYNAMIC_OUTPUTS);
        if (dynamicOutputs != null) {
            ArrayList<ObjectNode> newOutputEndpoints = new ArrayList<ObjectNode>();
            for (JsonNode jsonNode : dynamicOutputs) {
                String outputName = jsonNode.get(NAME).textValue();
                String outputEndpointId = jsonNode.get(EP_IDENTIFIER).textValue();
                if (!outputEndpointId.equals(VALUE_TO_CONVERGE) || outputName.endsWith(CONVERGED_SUFFIX)) continue;
                ObjectNode convergedEndpoint = mapper.createObjectNode();
                convergedEndpoint.put(NAME, (JsonNode)TextNode.valueOf((String)(String.valueOf(outputName) + "_is_converged")));
                convergedEndpoint.put(EP_IDENTIFIER, "auxiliaryValue");
                convergedEndpoint.put(DATATYPE, (JsonNode)TextNode.valueOf((String)BOOLEAN));
                convergedEndpoint.put(IDENTIFIER, (JsonNode)TextNode.valueOf((String)UUID.randomUUID().toString()));
                ObjectNode metaData = mapper.createObjectNode();
                metaData.put(LOOP_ENDPOINT_TYPE, SELF_LOOP_ENDPOINT);
                convergedEndpoint.put(METADATA, (JsonNode)metaData);
                newOutputEndpoints.add(convergedEndpoint);
            }
            for (JsonNode jsonNode : newOutputEndpoints) {
                ((ArrayNode)dynamicOutputs).add(jsonNode);
            }
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        return description;
    }

    /*
     * WARNING - void declaration
     */
    private PersistentComponentDescription updateFrom41To5(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        JsonNode dynamicInputs;
        JsonNode dynamicOutputs;
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        JsonNode staticOutputs = node.get(STATIC_OUTPUTS);
        if (staticOutputs != null) {
            for (JsonNode outputEndpoint : staticOutputs) {
                Iterator metaData;
                if (outputEndpoint.has(METADATA)) {
                    metaData = (ObjectNode)outputEndpoint.get(METADATA);
                } else {
                    metaData = mapper.createObjectNode();
                    ((ObjectNode)outputEndpoint).put(METADATA, (JsonNode)metaData);
                }
                if (outputEndpoint.get(NAME).textValue().equals("Outer loop done")) {
                    metaData.put(LOOP_ENDPOINT_TYPE, "InnerLoopEndpoint");
                    continue;
                }
                if (outputEndpoint.get(NAME).textValue().equals("Converged")) {
                    metaData.put(LOOP_ENDPOINT_TYPE, OUTER_LOOP_ENDPOINT);
                    continue;
                }
                if (outputEndpoint.get(NAME).textValue().equals("Converged absolute")) {
                    metaData.put(LOOP_ENDPOINT_TYPE, OUTER_LOOP_ENDPOINT);
                    continue;
                }
                if (!outputEndpoint.get(NAME).textValue().equals("Converged relative")) continue;
                metaData.put(LOOP_ENDPOINT_TYPE, OUTER_LOOP_ENDPOINT);
            }
        }
        if ((dynamicOutputs = node.get(DYNAMIC_OUTPUTS)) != null) {
            for (JsonNode outputEndpoint : dynamicOutputs) {
                void var8_8;
                if (outputEndpoint.has(METADATA)) {
                    ObjectNode objectNode = (ObjectNode)outputEndpoint.get(METADATA);
                } else {
                    ObjectNode objectNode = mapper.createObjectNode();
                    ((ObjectNode)outputEndpoint).put(METADATA, (JsonNode)objectNode);
                }
                if (outputEndpoint.get(NAME).textValue().endsWith(CONVERGED_SUFFIX)) {
                    var8_8.put(LOOP_ENDPOINT_TYPE, OUTER_LOOP_ENDPOINT);
                    continue;
                }
                var8_8.put(LOOP_ENDPOINT_TYPE, SELF_LOOP_ENDPOINT);
            }
        }
        if ((dynamicInputs = node.get(DYNAMIC_INPUTS)) != null) {
            ArrayList<ObjectNode> startInputs = new ArrayList<ObjectNode>();
            for (JsonNode jsonNode : dynamicInputs) {
                ObjectNode metaData;
                if (jsonNode.has(METADATA)) {
                    metaData = (ObjectNode)jsonNode.get(METADATA);
                } else {
                    metaData = mapper.createObjectNode();
                    ((ObjectNode)jsonNode).put(METADATA, (JsonNode)metaData);
                }
                if (jsonNode.get(EP_IDENTIFIER).textValue().equals(VALUE_TO_CONVERGE)) {
                    metaData.put(LOOP_ENDPOINT_TYPE, SELF_LOOP_ENDPOINT);
                    if (Boolean.valueOf(metaData.get("hasStartValue").asText()).booleanValue()) continue;
                    ObjectNode startInput = JsonNodeFactory.instance.objectNode();
                    startInput.put(IDENTIFIER, UUID.randomUUID().toString());
                    startInput.put(NAME, String.valueOf(jsonNode.get(NAME).asText()) + START_SUFFIX);
                    startInput.put(EP_IDENTIFIER, VALUE_TO_CONVERGE);
                    startInput.put("group", "startValues");
                    startInput.put(DATATYPE, jsonNode.get(DATATYPE).asText());
                    metaData.put(LOOP_ENDPOINT_TYPE, OUTER_LOOP_ENDPOINT);
                    metaData.put(INPUT_EXECUTION_CONSTRAINT, REQUIRED);
                    startInput.put(METADATA, (JsonNode)metaData);
                    startInputs.add(startInput);
                    continue;
                }
                if (!jsonNode.get(EP_IDENTIFIER).textValue().equals(OUTER_LOOP_DONE)) continue;
                metaData.put(LOOP_ENDPOINT_TYPE, OUTER_LOOP_ENDPOINT);
                metaData.put(INPUT_EXECUTION_CONSTRAINT, REQUIRED);
            }
            for (JsonNode jsonNode : startInputs) {
                ((ArrayNode)dynamicInputs).add(jsonNode);
            }
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        PersistentComponentDescription persistentComponentDescription = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        persistentComponentDescription.setComponentVersion(V5_0);
        return persistentComponentDescription;
    }

    private PersistentComponentDescription updateFrom40To41(PersistentComponentDescription description) throws IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        JsonNode dynOutputsNode = node.get(DYNAMIC_OUTPUTS);
        if (dynOutputsNode != null) {
            Iterator nodeIterator = dynOutputsNode.elements();
            while (nodeIterator.hasNext()) {
                ObjectNode dynOutputNode = (ObjectNode)nodeIterator.next();
                if (!dynOutputNode.get(EP_IDENTIFIER).asText().equals("convergedValue")) continue;
                dynOutputNode.put(EP_IDENTIFIER, VALUE_TO_CONVERGE);
            }
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion(V4_1);
        return description;
    }

    private PersistentComponentDescription updateFrom32To40(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ObjectNode configNode = (ObjectNode)node.get(CONFIGURATION);
        JsonNode maxIterNode = configNode.get("maxIterations");
        if (maxIterNode != null) {
            String maxConvChecks = maxIterNode.textValue();
            configNode.remove("maxIterations");
            configNode.put("maxConvChecks", maxConvChecks);
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion(V4_0);
        return description;
    }

    private PersistentComponentDescription updateFrom31To32(PersistentComponentDescription description) throws JsonParseException, IOException {
        description = PersistentComponentDescriptionUpdaterUtils.updateIsNestedLoop((PersistentComponentDescription)description);
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        JsonNode dynInputsNode = node.get(DYNAMIC_INPUTS);
        if (dynInputsNode != null) {
            Iterator nodeIterator = dynInputsNode.elements();
            while (nodeIterator.hasNext()) {
                String hasStartValue;
                JsonNode dynInputNode = (JsonNode)nodeIterator.next();
                ObjectNode jsonNode = (ObjectNode)dynInputNode.get(METADATA);
                JsonNode hasStartValueJsonNode = jsonNode.get("hasStartValue");
                if (hasStartValueJsonNode == null || !(hasStartValue = hasStartValueJsonNode.textValue()).equals("true")) continue;
                FloatTD floatValue = typedDatumService.getFactory().createFloat(Double.valueOf(jsonNode.get("startValue").textValue()).doubleValue());
                jsonNode.put("initValue_dca67e34", typedDatumService.getSerializer().serialize((TypedDatum)floatValue));
            }
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion(V3_2);
        return description;
    }

    private PersistentComponentDescription updateFrom30To31(PersistentComponentDescription description) throws JsonParseException, IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ObjectNode objectNode = (ObjectNode)node.get(CONFIGURATION);
        objectNode.put("iterationsToConsider", "1");
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion(V3_1);
        return description;
    }

    private PersistentComponentDescription secondUpdate(PersistentComponentDescription description) throws JsonParseException, IOException {
        ArrayNode statInputs;
        ArrayNode statOutputs;
        JsonNode dynOutputs;
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        JsonNode dynInputs = node.get(DYNAMIC_INPUTS);
        if (dynInputs != null) {
            for (JsonNode inputEndpoint : dynInputs) {
                if (!inputEndpoint.get(EP_IDENTIFIER).isNull()) continue;
                ((ObjectNode)inputEndpoint).remove(EP_IDENTIFIER);
                if (inputEndpoint.get(DATATYPE).textValue().equals("Float")) {
                    ((ObjectNode)inputEndpoint).put(EP_IDENTIFIER, (JsonNode)TextNode.valueOf((String)VALUE_TO_CONVERGE));
                    continue;
                }
                ((ObjectNode)inputEndpoint).put(EP_IDENTIFIER, (JsonNode)TextNode.valueOf((String)OUTER_LOOP_DONE));
            }
        }
        if ((dynOutputs = node.get(DYNAMIC_OUTPUTS)) != null) {
            for (JsonNode outputEndpoint : dynOutputs) {
                ((ObjectNode)outputEndpoint).remove(EP_IDENTIFIER);
                if (outputEndpoint.get(EP_IDENTIFIER) != null) continue;
                ((ObjectNode)outputEndpoint).put(EP_IDENTIFIER, (JsonNode)TextNode.valueOf((String)VALUE_TO_CONVERGE));
            }
        }
        if ((statOutputs = (ArrayNode)node.get(STATIC_OUTPUTS)) == null) {
            statOutputs = JsonNodeFactory.instance.arrayNode();
            ObjectNode outputEndpoint = JsonNodeFactory.instance.objectNode();
            outputEndpoint.put(NAME, (JsonNode)TextNode.valueOf((String)"Converged"));
            outputEndpoint.put(DATATYPE, (JsonNode)TextNode.valueOf((String)BOOLEAN));
            outputEndpoint.put(IDENTIFIER, (JsonNode)TextNode.valueOf((String)UUID.randomUUID().toString()));
            statOutputs.add((JsonNode)outputEndpoint);
            outputEndpoint = JsonNodeFactory.instance.objectNode();
            outputEndpoint.put(NAME, (JsonNode)TextNode.valueOf((String)"Converged absolute"));
            outputEndpoint.put(DATATYPE, (JsonNode)TextNode.valueOf((String)BOOLEAN));
            outputEndpoint.put(IDENTIFIER, (JsonNode)TextNode.valueOf((String)UUID.randomUUID().toString()));
            statOutputs.add((JsonNode)outputEndpoint);
            outputEndpoint = JsonNodeFactory.instance.objectNode();
            outputEndpoint.put(NAME, (JsonNode)TextNode.valueOf((String)"Converged relative"));
            outputEndpoint.put(DATATYPE, (JsonNode)TextNode.valueOf((String)BOOLEAN));
            outputEndpoint.put(IDENTIFIER, (JsonNode)TextNode.valueOf((String)UUID.randomUUID().toString()));
            statOutputs.add((JsonNode)outputEndpoint);
            ((ObjectNode)node).put(STATIC_OUTPUTS, (JsonNode)statOutputs);
        }
        if ((statInputs = (ArrayNode)node.get(STATIC_INPUTS)) == null) {
            statInputs = JsonNodeFactory.instance.arrayNode();
            ObjectNode inputEndpoint = JsonNodeFactory.instance.objectNode();
            inputEndpoint.put(NAME, (JsonNode)TextNode.valueOf((String)OUTER_LOOP_DONE));
            inputEndpoint.put(DATATYPE, (JsonNode)TextNode.valueOf((String)BOOLEAN));
            inputEndpoint.put(IDENTIFIER, (JsonNode)TextNode.valueOf((String)UUID.randomUUID().toString()));
            inputEndpoint.put("readonly", "true");
            ObjectNode metadata = JsonNodeFactory.instance.objectNode();
            metadata.put("usage", "optional");
            inputEndpoint.put(METADATA, (JsonNode)metadata);
            statInputs.add((JsonNode)inputEndpoint);
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description = PersistentComponentDescriptionUpdaterUtils.updateAllDynamicEndpointsToIdentifier((String)DYNAMIC_OUTPUTS, (String)VALUE_TO_CONVERGE, (PersistentComponentDescription)description);
        return description;
    }

    private PersistentComponentDescription firstUpdate(PersistentComponentDescription description) throws IOException, JsonParseException, JsonProcessingException, JsonGenerationException, JsonMappingException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        description = this.replaceEpsDataType(mapper, node, "epsR");
        description = this.replaceEpsDataType(mapper, node, "epsA");
        description = this.addConvergedOutputs(mapper, node);
        return description;
    }

    private PersistentComponentDescription replaceEpsDataType(ObjectMapper mapper, JsonNode node, String eps) throws JsonParseException, IOException, JsonGenerationException, JsonMappingException {
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        ArrayNode configurationNode = (ArrayNode)node.get(CONFIGURATION);
        ArrayNode newConfigurationNode = JsonNodeFactory.instance.arrayNode();
        JsonNode oldEpsNode = null;
        for (JsonNode n : configurationNode) {
            if (n.textValue().startsWith(String.valueOf(eps) + ":java.lang.Double:")) {
                oldEpsNode = n;
                continue;
            }
            newConfigurationNode.add(n);
        }
        if (oldEpsNode != null) {
            String nodeString = oldEpsNode.textValue();
            String value = "";
            if (nodeString.split(COLON).length > 1) {
                value = nodeString.split(COLON)[2];
            }
            newConfigurationNode.add((JsonNode)TextNode.valueOf((String)(String.valueOf(eps) + ":java.lang.String:" + value)));
            ((ObjectNode)node).remove(CONFIGURATION);
            ((ObjectNode)node).put(CONFIGURATION, (JsonNode)newConfigurationNode);
        }
        PersistentComponentDescription description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        return description;
    }

    private PersistentComponentDescription addConvergedOutputs(ObjectMapper mapper, JsonNode node) throws JsonParseException, JsonGenerationException, JsonMappingException, IOException {
        JsonNode addOutputNode = node.get("addOutput");
        Map<String, String> outputs = this.getOutputs(addOutputNode);
        this.setOutputs(addOutputNode, outputs);
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        PersistentComponentDescription description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        return description;
    }

    private Map<String, String> getOutputs(JsonNode addOutputNode) {
        HashMap<String, String> outputs = new HashMap<String, String>();
        Iterator nodeIterator = addOutputNode.elements();
        while (nodeIterator.hasNext()) {
            String[] output = ((JsonNode)nodeIterator.next()).textValue().split(COLON);
            outputs.put(output[0], output[1]);
        }
        return outputs;
    }

    private JsonNode setOutputs(JsonNode addOutputNode, Map<String, String> outputs) {
        ((ArrayNode)addOutputNode).removeAll();
        for (String outputName : outputs.keySet()) {
            ((ArrayNode)addOutputNode).add(String.valueOf(outputName) + COLON + outputs.get(outputName));
            if (outputName.endsWith(CONVERGED_SUFFIX) || outputs.containsKey(String.valueOf(outputName) + CONVERGED_SUFFIX)) continue;
            ((ArrayNode)addOutputNode).add(String.valueOf(outputName) + CONVERGED_SUFFIX + COLON + outputs.get(outputName));
        }
        return addOutputNode;
    }

    protected void bindTypedDatumService(TypedDatumService newService) {
        typedDatumService = newService;
    }
}

