/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.model.api.testutils;

import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentRevision;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNodeIdentifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.easymock.EasyMock;

public class WorkflowNodeMockBuilder {
    private final WorkflowNode node = (WorkflowNode)EasyMock.createMock(WorkflowNode.class);
    private final Map<String, EndpointDefinition> inputDefinitions = new HashMap<String, EndpointDefinition>();
    private final Map<String, EndpointDefinition> outputDefinitions = new HashMap<String, EndpointDefinition>();
    private String workflowIdentifier;

    public WorkflowNodeMockBuilder addStaticInput(String name, EndpointDefinition inputDefinition) {
        this.inputDefinitions.put(name, inputDefinition);
        return this;
    }

    public WorkflowNodeMockBuilder addStaticOutput(String name, EndpointDefinition outputDefinition) {
        this.outputDefinitions.put(name, outputDefinition);
        return this;
    }

    public WorkflowNodeMockBuilder identifier(String identifier) {
        this.workflowIdentifier = identifier;
        return this;
    }

    public WorkflowNode build() {
        EasyMock.expect((Object)this.node.getInputDescriptionsManager()).andStubAnswer(() -> {
            EndpointDescriptionsManager manager = (EndpointDescriptionsManager)EasyMock.createNiceMock((String)"InputManager", EndpointDescriptionsManager.class);
            EasyMock.expect((Object)manager.getStaticEndpointDefinitions()).andStubAnswer(() -> {
                HashSet<EndpointDefinition> returnValue = new HashSet<EndpointDefinition>();
                for (EndpointDefinition inputDefinition : this.inputDefinitions.values()) {
                    returnValue.add(inputDefinition);
                }
                return returnValue;
            });
            EasyMock.expect((Object)manager.getDynamicEndpointDefinitions()).andStubReturn(Collections.emptySet());
            EasyMock.expect((Object)manager.getStaticEndpointDescriptions()).andStubAnswer(() -> {
                HashSet<EndpointDescription> returnValue = new HashSet<EndpointDescription>();
                for (Map.Entry<String, EndpointDefinition> inputDefinition : this.inputDefinitions.entrySet()) {
                    returnValue.add(new EndpointDescription(inputDefinition.getValue(), inputDefinition.getKey()));
                }
                return returnValue;
            });
            EasyMock.expect((Object)manager.getDynamicEndpointDescriptions()).andStubReturn(Collections.emptySet());
            EasyMock.replay((Object[])new Object[]{manager});
            return manager;
        });
        EasyMock.expect((Object)this.node.getOutputDescriptionsManager()).andStubAnswer(() -> {
            EndpointDescriptionsManager manager = (EndpointDescriptionsManager)EasyMock.createNiceMock((String)"OutputManager", EndpointDescriptionsManager.class);
            EasyMock.expect((Object)manager.getStaticEndpointDefinitions()).andStubAnswer(() -> {
                HashSet<EndpointDefinition> returnValue = new HashSet<EndpointDefinition>();
                for (EndpointDefinition outputDefinition : this.outputDefinitions.values()) {
                    returnValue.add(outputDefinition);
                }
                return returnValue;
            });
            EasyMock.expect((Object)manager.getDynamicEndpointDefinitions()).andStubReturn(Collections.emptySet());
            EasyMock.expect((Object)manager.getStaticEndpointDescriptions()).andStubAnswer(() -> {
                HashSet<EndpointDescription> returnValue = new HashSet<EndpointDescription>();
                for (Map.Entry<String, EndpointDefinition> outputDefinition : this.outputDefinitions.entrySet()) {
                    returnValue.add(new EndpointDescription(outputDefinition.getValue(), outputDefinition.getKey()));
                }
                return returnValue;
            });
            EasyMock.expect((Object)manager.getDynamicEndpointDescriptions()).andStubReturn(Collections.emptySet());
            EasyMock.replay((Object[])new Object[]{manager});
            return manager;
        });
        EasyMock.expect((Object)this.node.getIdentifierAsObject()).andStubReturn((Object)new WorkflowNodeIdentifier(this.workflowIdentifier));
        EasyMock.expect((Object)this.node.getComponentDescription()).andStubAnswer(() -> {
            ComponentDescription description = (ComponentDescription)EasyMock.createMock(ComponentDescription.class);
            EasyMock.expect((Object)description.getComponentInstallation()).andStubAnswer(() -> {
                ComponentInstallation installation = (ComponentInstallation)EasyMock.createMock(ComponentInstallation.class);
                EasyMock.expect((Object)installation.getComponentRevision()).andStubAnswer(() -> {
                    ComponentRevision revision = (ComponentRevision)EasyMock.createMock(ComponentRevision.class);
                    EasyMock.expect((Object)revision.getClassName()).andStubReturn((Object)"some implementing class name");
                    EasyMock.replay((Object[])new Object[]{revision});
                    return revision;
                });
                EasyMock.replay((Object[])new Object[]{installation});
                return installation;
            });
            EasyMock.replay((Object[])new Object[]{description});
            return description;
        });
        EasyMock.replay((Object[])new Object[]{this.node});
        return this.node;
    }
}

