/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.excel.execution;

import de.rcenvironment.components.excel.common.ExcelService;
import de.rcenvironment.components.excel.common.ExcelUtils;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.execution.api.ComponentLog;
import de.rcenvironment.core.component.model.api.LazyDisposal;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.datamodel.api.TypedDatumConverter;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.notification.DistributedNotificationService;
import java.io.File;

@LazyDisposal
public abstract class ExcelRCEComponent
extends DefaultComponent {
    private static final int NOTIFICATION_BUFFER = 1000;
    protected DistributedNotificationService notificationService;
    protected ExcelService excelService;
    protected TypedDatumFactory typedDatumFactory;
    protected TypedDatumConverter typedDatumConverter;
    protected ComponentDataManagementService dataManagementService;
    protected ComponentContext componentContext;
    protected ComponentLog componentLog;

    protected abstract void executingOneStep() throws ComponentException;

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
        this.componentLog = componentContext.getLog();
    }

    public boolean treatStartAsComponentRun() {
        boolean isDriver = Boolean.valueOf(this.componentContext.getConfigurationValue("Driver"));
        return isDriver || this.componentContext.getInputs().isEmpty();
    }

    public void start() throws ComponentException {
        this.notificationService = (DistributedNotificationService)this.componentContext.getService(DistributedNotificationService.class);
        this.excelService = (ExcelService)this.componentContext.getService(ExcelService.class);
        this.typedDatumFactory = ((TypedDatumService)this.componentContext.getService(TypedDatumService.class)).getFactory();
        this.typedDatumConverter = ((TypedDatumService)this.componentContext.getService(TypedDatumService.class)).getConverter();
        this.dataManagementService = (ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class);
        File originExcelFile = ExcelUtils.getAbsoluteFile((String)this.componentContext.getConfigurationValue("xlFilename"));
        if (originExcelFile == null) {
            throw new ComponentException("Cannot prepare Excel component. Maybe filename/path is wrong?");
        }
        this.notificationService.setBufferSize(String.valueOf(this.componentContext.getExecutionIdentifier()) + ":rce.component.excel", 1000);
        if (this.treatStartAsComponentRun()) {
            this.executingOneStep();
        }
    }

    public void processInputs() throws ComponentException {
        this.executingOneStep();
    }

    public void dispose() {
        if (this.componentContext != null && this.notificationService != null) {
            this.notificationService.removePublisher(String.valueOf(this.componentContext.getExecutionIdentifier()) + ":rce.component.excel");
        }
    }
}

