/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.transport.virtual;

import de.rcenvironment.core.communication.channel.MessageChannelIdFactory;
import de.rcenvironment.core.communication.channel.ServerContactPoint;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.model.InitialNodeInformation;
import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.transport.spi.BrokenMessageChannelListener;
import de.rcenvironment.core.communication.transport.spi.MessageChannel;
import de.rcenvironment.core.communication.transport.spi.MessageChannelEndpointHandler;
import de.rcenvironment.core.communication.transport.spi.NetworkTransportProvider;
import de.rcenvironment.core.communication.transport.virtual.VirtualNetworkMessageChannel;
import java.util.HashMap;
import java.util.Map;

public class VirtualNetworkTransportProvider
implements NetworkTransportProvider {
    public static final String TRANSPORT_ID = "virtual";
    private Map<NetworkContactPoint, ServerContactPoint> virtualServices = new HashMap<NetworkContactPoint, ServerContactPoint>();
    private Map<InstanceNodeSessionId, MessageChannelEndpointHandler> remoteInitiatedConnectionEndpointHandlerMap = new HashMap<InstanceNodeSessionId, MessageChannelEndpointHandler>();
    private boolean supportRemoteInitiatedConnections;
    private MessageChannelIdFactory connectionIdFactory;

    public VirtualNetworkTransportProvider(boolean supportRemoteInitiatedConnections, MessageChannelIdFactory connectionIdFactory) {
        this.supportRemoteInitiatedConnections = supportRemoteInitiatedConnections;
        this.connectionIdFactory = connectionIdFactory;
    }

    @Override
    public String getTransportId() {
        return TRANSPORT_ID;
    }

    @Override
    public synchronized MessageChannel connect(NetworkContactPoint ncp, InitialNodeInformation initiatingNodeInformation, String ownProtocolVersion, boolean allowDuplex, MessageChannelEndpointHandler initiatingEndpointHandler, BrokenMessageChannelListener brokenConnectionListener) throws CommunicationException {
        ServerContactPoint receivingSCP = this.virtualServices.get(ncp);
        if (receivingSCP == null) {
            throw new IllegalStateException("No matching SCP found for NCP " + ncp + "; was the server stated before connecting to it?");
        }
        if (receivingSCP.isSimulatingBreakdown()) {
            throw new CommunicationException("Failed to open connection: " + receivingSCP + " is simulating breakdown");
        }
        MessageChannelEndpointHandler receivingEndpointHandler = receivingSCP.getEndpointHandler();
        VirtualNetworkMessageChannel newChannel = new VirtualNetworkMessageChannel(initiatingNodeInformation, ownProtocolVersion, receivingEndpointHandler, receivingSCP);
        InitialNodeInformation receivingNodeInformation = receivingEndpointHandler.exchangeNodeInformation(initiatingNodeInformation);
        newChannel.setRemoteNodeInformation(receivingNodeInformation);
        newChannel.setChannelId(this.connectionIdFactory.generateId(true));
        if (allowDuplex && this.supportRemoteInitiatedConnections) {
            VirtualNetworkMessageChannel remoteChannel = new VirtualNetworkMessageChannel(receivingNodeInformation, receivingSCP.getExpectedProtocolVersion(), initiatingEndpointHandler, receivingSCP);
            remoteChannel.setRemoteNodeInformation(initiatingNodeInformation);
            remoteChannel.setChannelId(this.connectionIdFactory.generateId(false));
            remoteChannel.setInitiatedByRemote(true);
            remoteChannel.setAssociatedMirrorChannelId(newChannel.getChannelId());
            newChannel.setAssociatedMirrorChannelId(remoteChannel.getChannelId());
            remoteChannel.markAsEstablished();
            receivingEndpointHandler.onRemoteInitiatedChannelEstablished(remoteChannel, receivingSCP);
        }
        newChannel.markAsEstablished();
        return newChannel;
    }

    @Override
    public boolean supportsRemoteInitiatedConnections() {
        return this.supportRemoteInitiatedConnections;
    }

    @Override
    public synchronized void startServer(ServerContactPoint scp) {
        this.virtualServices.put(scp.getNetworkContactPoint(), scp);
    }

    @Override
    public synchronized void stopServer(ServerContactPoint scp) {
        ServerContactPoint removed = this.virtualServices.remove(scp.getNetworkContactPoint());
        if (removed == null) {
            throw new IllegalStateException("No matching SCP registered: " + scp);
        }
    }
}

