/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.testutils;

import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.toolkit.utils.common.AutoCreationMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VirtualServiceRegistry {
    private List<VirtualService> unboundServices = new ArrayList<VirtualService>();
    private AutoCreationMap<Class<?>, List<VirtualService>> activatedServices = new AutoCreationMap<Class<?>, List<VirtualService>>(){

        protected List<VirtualService> createNewEntry(Class<?> key) {
            return new ArrayList<VirtualService>();
        }
    };
    private final boolean verboseLogging = DebugSettings.getVerboseLoggingEnabled(this.getClass());
    private final Log log = LogFactory.getLog(this.getClass());

    public void registerProvidedService(Object implementation, Class<?> ... serviceClasses) {
        VirtualService service = new VirtualService(implementation, false, serviceClasses);
        Class<?>[] classArray = serviceClasses;
        int n = serviceClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            ((List)this.activatedServices.get(clazz)).add(service);
            ++n2;
        }
    }

    public void registerManagedService(Object implementation, Class<?> ... serviceClasses) {
        this.registerManagedService(implementation, true, serviceClasses);
    }

    public void registerManagedService(Object implementation, boolean expectActivator, Class<?> ... serviceClasses) {
        VirtualService service = new VirtualService(implementation, expectActivator, serviceClasses);
        this.unboundServices.add(service);
    }

    public <T> T getService(Class<T> clazz) {
        List list = (List)this.activatedServices.get(clazz);
        if (list.isEmpty()) {
            return null;
        }
        return (T)((VirtualService)list.get(0)).getImplementation();
    }

    public Collection<?> getServices(Class<?> clazz) {
        return new ArrayList();
    }

    public void bindAndActivateServices() {
        VirtualService activatedService;
        do {
            int n;
            activatedService = null;
            for (VirtualService service : this.unboundServices) {
                n = this.checkDependencies(service);
                if (n == 0) continue;
                this.bindDependencies(service);
                this.activate(service);
                activatedService = service;
                break;
            }
            if (activatedService == null) continue;
            this.unboundServices.remove(activatedService);
            Class<?>[] classArray = activatedService.getServiceClasses();
            n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> serviceClass = classArray[n2];
                ((List)this.activatedServices.get(serviceClass)).add(activatedService);
                ++n2;
            }
        } while (activatedService != null);
        if (!this.unboundServices.isEmpty()) {
            this.log.warn((Object)"After bindAndActivateServices(), there are still unbound services left:");
            for (VirtualService service : this.unboundServices) {
                this.log.warn((Object)("  " + service.getImplementation().getClass()));
                for (Class clazz : service.getBindMethods().keySet()) {
                    String warningSuffix = "";
                    if (this.getService(clazz) == null) {
                        warningSuffix = " [unsatisfied]";
                    }
                    this.log.warn((Object)("    -> depends on " + clazz.getName() + warningSuffix));
                }
                Class<?>[] classArray = service.getServiceClasses();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> clazz = classArray[n2];
                    this.log.warn((Object)("    <- provides " + clazz.getName()));
                    ++n2;
                }
            }
            throw new RuntimeException("Failed to bind and activate all services; see log output for details");
        }
    }

    private boolean checkDependencies(VirtualService service) {
        boolean satisfied = true;
        for (Map.Entry<Class<?>, Method> bindMethod : service.getBindMethods().entrySet()) {
            Class<?> type = bindMethod.getKey();
            if (this.getService(type) != null) continue;
            satisfied = false;
            break;
        }
        return satisfied;
    }

    private void bindDependencies(VirtualService service) {
        if (this.verboseLogging) {
            this.log.debug((Object)("Dependencies of service " + service.getImplementation().getClass().getName() + " are satisfied, starting to bind"));
        }
        for (Map.Entry<Class<?>, Method> bindMethod : service.getBindMethods().entrySet()) {
            Class<?> type = bindMethod.getKey();
            Object dependency = this.getService(type);
            if (this.verboseLogging) {
                this.log.debug((Object)("Binding dependency of service " + service.getImplementation().getClass().getName() + " with instance of type " + dependency.getClass().getName()));
            }
            Exception error = null;
            try {
                bindMethod.getValue().invoke(service.getImplementation(), dependency);
            }
            catch (IllegalArgumentException e) {
                error = e;
            }
            catch (IllegalAccessException e) {
                error = e;
            }
            catch (InvocationTargetException e) {
                error = e;
            }
            if (error == null) continue;
            throw new RuntimeException("Error calling bind method", error);
        }
    }

    private void activate(VirtualService service) {
        Exception error = null;
        Object implementation = service.getImplementation();
        Class<?> implementationClass = implementation.getClass();
        try {
            try {
                Method noArgs = implementationClass.getMethod("activate", new Class[0]);
                if (!service.expectActivator) {
                    throw new IllegalArgumentException("Activator found in " + implementationClass.getName() + ", but it was specified to not have one");
                }
                if (this.verboseLogging) {
                    this.log.debug((Object)("Activating service " + implementationClass.getName()));
                }
                noArgs.invoke(implementation, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (service.expectActivator) {
                    throw new IllegalArgumentException("No activator method found in " + implementationClass.getName() + ", but it was specified to have one");
                }
                return;
            }
        }
        catch (IllegalArgumentException e) {
            error = e;
        }
        catch (SecurityException e) {
            error = e;
        }
        catch (IllegalAccessException e) {
            error = e;
        }
        catch (InvocationTargetException e) {
            error = e;
        }
        if (error != null) {
            throw new RuntimeException("Error activating service", error);
        }
    }

    private final class VirtualService {
        private final Object implementation;
        private final boolean expectActivator;
        private final Class<?>[] serviceClasses;
        private final Map<Class<?>, Method> bindMethods = new HashMap();

        VirtualService(Object implementation, boolean expectActivator, Class<?>[] serviceClasses) {
            Method[] methods;
            this.implementation = implementation;
            this.expectActivator = expectActivator;
            this.serviceClasses = serviceClasses;
            Method[] methodArray = methods = implementation.getClass().getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().startsWith("bind") && method.getParameterTypes().length == 1) {
                    Class<?> type = method.getParameterTypes()[0];
                    if (VirtualServiceRegistry.this.verboseLogging) {
                        VirtualServiceRegistry.this.log.debug((Object)("Found bind method: " + implementation.getClass().getName() + "." + method.getName() + "() -> " + type.getName()));
                    }
                    this.bindMethods.put(type, method);
                }
                ++n2;
            }
        }

        public Class<?>[] getServiceClasses() {
            return this.serviceClasses;
        }

        public Object getImplementation() {
            return this.implementation;
        }

        public Map<Class<?>, Method> getBindMethods() {
            return this.bindMethods;
        }
    }
}

