/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.rpc.internal;

import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.rpc.api.CallbackService;
import de.rcenvironment.core.communication.rpc.api.RemotableCallbackService;
import de.rcenvironment.core.communication.rpc.internal.CallbackInvocationHandler;
import de.rcenvironment.core.communication.rpc.internal.CallbackProxy;
import de.rcenvironment.core.communication.rpc.internal.CleanJob;
import de.rcenvironment.core.communication.rpc.internal.MethodCaller;
import de.rcenvironment.core.communication.spi.CallbackObject;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import de.rcenvironment.core.utils.common.security.MethodPermissionCheck;
import de.rcenvironment.core.utils.common.security.MethodPermissionCheckHasAnnotation;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.osgi.framework.BundleContext;

public class CallbackServiceImpl
implements CallbackService,
RemotableCallbackService {
    private static final MethodPermissionCheck METHOD_PERMISSION_CHECK = new MethodPermissionCheckHasAnnotation(AllowRemoteAccess.class);
    private Map<String, WeakReference<Object>> objects = Collections.synchronizedMap(new HashMap());
    private Map<String, InstanceNodeSessionId> remotePlatforms = Collections.synchronizedMap(new HashMap());
    private Map<String, Long> ttls = Collections.synchronizedMap(new HashMap());
    private PlatformService platformService;

    protected void activate(BundleContext context) {
        CleanJob.scheduleJob(CallbackService.class, this.objects, this.ttls, this.remotePlatforms);
    }

    protected void deactivate(BundleContext context) {
        CleanJob.unscheduleJob(CallbackService.class);
    }

    protected void bindPlatformService(PlatformService newPlatformService) {
        this.platformService = newPlatformService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addCallbackObject(Object callbackObject, InstanceNodeSessionId nodeId) {
        String identifier = null;
        Map<String, WeakReference<Object>> map = this.objects;
        synchronized (map) {
            for (String id : this.objects.keySet()) {
                if (this.objects.get(id).get() != callbackObject) continue;
                return id;
            }
        }
        identifier = UUID.randomUUID().toString();
        this.objects.put(identifier, new WeakReference<Object>(callbackObject));
        this.remotePlatforms.put(identifier, nodeId);
        this.ttls.put(identifier, new Date(System.currentTimeMillis() + 600000L).getTime());
        return identifier;
    }

    @Override
    public Object getCallbackObject(String objectIdentifier) {
        WeakReference<Object> weakRef = this.objects.get(objectIdentifier);
        if (weakRef != null) {
            return weakRef.get();
        }
        return null;
    }

    @Override
    @AllowRemoteAccess
    public Object callback(String objectIdentifier, String methodName, List<? extends Serializable> parameters) throws RemoteOperationException {
        Object objectToCall;
        WeakReference<Object> weakRef = this.objects.get(objectIdentifier);
        if (weakRef != null && (objectToCall = weakRef.get()) != null) {
            try {
                return MethodCaller.callMethod(objectToCall, methodName, parameters, METHOD_PERMISSION_CHECK);
            }
            catch (InvocationTargetException e) {
                throw new RemoteOperationException("Callback method threw an exception: " + e.toString());
            }
        }
        throw new RemoteOperationException("The object to call back is not reachable anymore, requested method: " + methodName + "(...)");
    }

    @Override
    @AllowRemoteAccess
    public void setTTL(String objectIdentifier, Long ttl) {
        this.ttls.put(objectIdentifier, ttl);
    }

    @Override
    public Object createCallbackProxy(CallbackObject callbackObject, String objectIdentifier, InstanceNodeSessionId proxyHome) {
        CallbackInvocationHandler handler = new CallbackInvocationHandler(callbackObject, objectIdentifier, this.platformService.getLocalInstanceNodeSessionId(), proxyHome);
        Object proxy = Proxy.newProxyInstance(CallbackProxy.class.getClassLoader(), new Class[]{callbackObject.getInterface(), CallbackProxy.class}, (InvocationHandler)handler);
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCallbackObjectIdentifier(Object callbackObject) {
        Map<String, WeakReference<Object>> map = this.objects;
        synchronized (map) {
            for (String id : this.objects.keySet()) {
                if (this.objects.get(id).get() == null || this.objects.get(id).get() != callbackObject) continue;
                return id;
            }
        }
        return null;
    }
}

