/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.routing.internal;

import de.rcenvironment.core.communication.channel.MessageChannelLifecycleListenerAdapter;
import de.rcenvironment.core.communication.channel.MessageChannelService;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.SerializationException;
import de.rcenvironment.core.communication.messaging.NetworkRequestHandler;
import de.rcenvironment.core.communication.messaging.NetworkRequestHandlerMap;
import de.rcenvironment.core.communication.messaging.direct.api.DirectMessagingSender;
import de.rcenvironment.core.communication.messaging.internal.InternalMessagingException;
import de.rcenvironment.core.communication.messaging.internal.NetworkRequestUtils;
import de.rcenvironment.core.communication.model.InitialNodeInformation;
import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.model.NetworkRequest;
import de.rcenvironment.core.communication.model.NetworkResponse;
import de.rcenvironment.core.communication.model.NetworkResponseHandler;
import de.rcenvironment.core.communication.protocol.MessageMetaData;
import de.rcenvironment.core.communication.protocol.NetworkRequestFactory;
import de.rcenvironment.core.communication.protocol.NetworkResponseFactory;
import de.rcenvironment.core.communication.routing.internal.LinkStateAdvertisement;
import de.rcenvironment.core.communication.routing.internal.LinkStateAdvertisementBatch;
import de.rcenvironment.core.communication.routing.internal.NetworkStats;
import de.rcenvironment.core.communication.routing.internal.TopologyLink;
import de.rcenvironment.core.communication.routing.internal.TopologyMap;
import de.rcenvironment.core.communication.routing.internal.TopologyNode;
import de.rcenvironment.core.communication.spi.NetworkTopologyChangeListener;
import de.rcenvironment.core.communication.transport.spi.MessageChannel;
import de.rcenvironment.core.communication.utils.MessageUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LinkStateRoutingProtocolManager {
    private static final int DEFAULT_TIME_TO_LIVE = 200;
    private static int timeToLive = 200;
    private static final int MESSAGE_BUFFER_SIZE = 50;
    private static final boolean DEBUG_DUMP_INITIAL_LSA_BATCHES = false;
    public volatile boolean sendCompactLsaLists = false;
    private final Log log = LogFactory.getLog(this.getClass());
    private final TopologyMap topologyMap;
    private final NetworkRequestHandler networkRequestHandler;
    private final InitialNodeInformation ownNodeInformation;
    private final InstanceNodeSessionId ownNodeId;
    private final DirectMessagingSender directMessagingSender;
    private NetworkTopologyChangeListener topologyChangeListener;
    private final Map<String, Serializable> messageBuffer = new LinkedHashMap<String, Serializable>(50);
    private final NetworkStats networkStats;
    private final Map<String, MessageChannel> connectionsById = new HashMap<String, MessageChannel>();

    public LinkStateRoutingProtocolManager(TopologyMap topologyMap, MessageChannelService connectionService, NetworkTopologyChangeListener changeListener) {
        this.topologyMap = topologyMap;
        this.networkRequestHandler = new LSANetworkRequestHandler(this);
        this.ownNodeInformation = topologyMap.getLocalNodeInformation();
        this.ownNodeId = this.ownNodeInformation.getInstanceNodeSessionId();
        this.directMessagingSender = connectionService;
        this.networkStats = new NetworkStats();
        connectionService.addChannelLifecycleListener(new MessageChannelLifecycleHandler());
        TopologyNode ownNode = topologyMap.addNode(this.ownNodeId);
        ownNode.setDisplayName(this.ownNodeInformation.getDisplayName());
        ownNode.setIsWorkflowHost(false);
        ownNode.invalidateSequenceNumber();
        this.topologyChangeListener = changeListener;
        this.fireTopologyChangedListener();
    }

    public NetworkRequestHandlerMap getNetworkRequestHandlers() {
        return new NetworkRequestHandlerMap("lsa", this.networkRequestHandler);
    }

    public void announceShutdown() throws CommunicationException {
        this.broadcastLsa(this.topologyMap.generateShutdownLSA());
    }

    public boolean messageReivedById(String messageId) {
        return this.messageBuffer.containsKey(messageId);
    }

    public boolean messageReivedByContent(Serializable messageContent) {
        return this.messageBuffer.containsValue(messageContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable handleSingleLinkStateAdvertisement(Serializable messageContent, Map<String, String> metaData) {
        boolean topologyChanged = false;
        TopologyMap topologyMap = this.topologyMap;
        synchronized (topologyMap) {
            if (!(messageContent instanceof LinkStateAdvertisement)) {
                throw new IllegalStateException("Received a non-LSA in handleLinkStateAdvertisement()");
            }
            LinkStateAdvertisement lsa = (LinkStateAdvertisement)messageContent;
            this.networkStats.incReceivedLSAs();
            if (this.topologyMap.update(lsa)) {
                topologyChanged = true;
                this.networkStats.setMaxTimeToLive(this.getTimeToLive());
                this.broadcastLsa(lsa);
            } else {
                this.networkStats.incRejectedLSAs();
                this.networkStats.incHopCountOfRejectedLSAs(MessageMetaData.wrap(metaData).getHopCount());
            }
        }
        if (topologyChanged) {
            this.fireTopologyChangedListener();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable handleReceivedInitialLSABatch(Serializable messageContent) {
        LinkStateAdvertisementBatch response;
        boolean topologyChanged = false;
        TopologyMap topologyMap = this.topologyMap;
        synchronized (topologyMap) {
            if (!(messageContent instanceof LinkStateAdvertisementBatch)) {
                throw new IllegalStateException("Message content of wrong type.");
            }
            LinkStateAdvertisementBatch lsaCache = (LinkStateAdvertisementBatch)messageContent;
            new LinkStateAdvertisementBatch();
            for (LinkStateAdvertisement lsa : lsaCache.values()) {
                if (!this.topologyMap.update(lsa)) continue;
                topologyChanged = true;
                this.broadcastLsa(lsa);
            }
            response = this.topologyMap.generateLsaBatchOfAllNodes();
        }
        if (topologyChanged) {
            this.fireTopologyChangedListener();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleInitialLSABatchResponse(Serializable messageContent) {
        boolean topologyChanged = false;
        TopologyMap topologyMap = this.topologyMap;
        synchronized (topologyMap) {
            block5: {
                if (messageContent instanceof LinkStateAdvertisementBatch) break block5;
                this.log.warn((Object)"Message content was of wrong type.");
                return false;
            }
            LinkStateAdvertisementBatch lsaCache = (LinkStateAdvertisementBatch)messageContent;
            for (LinkStateAdvertisement lsa : lsaCache.values()) {
                if (!this.topologyMap.update(lsa)) continue;
                topologyChanged = true;
                this.broadcastLsa(lsa);
            }
        }
        return topologyChanged;
    }

    private void onOutgoingChannelHandshakeCompleted(MessageChannel connection, boolean topologyChanged) {
        this.broadcastNewLocalLSA();
        if (topologyChanged) {
            this.fireTopologyChangedListener();
        }
    }

    public String broadcastNewLocalLSA() {
        LinkStateAdvertisement ownLsa = this.topologyMap.generateNewLocalLSA();
        return this.broadcastLsa(ownLsa);
    }

    private String broadcastLsa(LinkStateAdvertisement lsa) {
        byte[] lsaBytes = MessageUtils.serializeSafeObject(lsa);
        String messageId = "";
        ArrayList<TopologyNode> neighbors = new ArrayList<TopologyNode>(this.topologyMap.getSuccessors());
        Collections.shuffle(neighbors);
        Collection<TopologyLink> links = this.topologyMap.getAllOutgoingLinks(this.ownNodeId);
        for (TopologyLink link : links) {
            this.networkStats.incSentLSAs();
            NetworkRequest request = NetworkRequestFactory.createNetworkRequest(lsaBytes, "lsa", this.ownNodeId, null);
            final String channelId = link.getConnectionId();
            this.directMessagingSender.sendDirectMessageAsync(request, this.connectionsById.get(channelId), new NetworkResponseHandler(){

                @Override
                public void onResponseAvailable(NetworkResponse response) {
                    if (!response.isSuccess()) {
                        LinkStateRoutingProtocolManager.this.log.warn((Object)("Failed to send LSA via channel " + channelId));
                    }
                }
            });
        }
        return messageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageChannel getMessageChannelById(String id) {
        MessageChannel connection = null;
        Map<String, MessageChannel> map = this.connectionsById;
        synchronized (map) {
            connection = this.connectionsById.get(id);
        }
        if (connection == null) {
            throw new IllegalStateException("No registered connection for connection id " + id);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TopologyLink registerNewConnection(MessageChannel connection) {
        String connectionId = connection.getChannelId();
        Map<String, MessageChannel> map = this.connectionsById;
        synchronized (map) {
            if (this.connectionsById.get(connectionId) != null) {
                throw new IllegalStateException("Existing connection found for connection id " + connectionId);
            }
            this.connectionsById.put(connectionId, connection);
            InstanceNodeSessionId remoteNodeId = connection.getRemoteNodeInformation().getInstanceNodeSessionId();
            this.topologyMap.addNode(remoteNodeId);
            if (this.topologyMap.hasLinkForConnection(connection.getChannelId())) {
                throw new IllegalStateException("Found existing link for new connection " + connectionId);
            }
            TopologyLink newLink = this.topologyMap.addLink(this.getOwner(), remoteNodeId, connection.getChannelId());
            return newLink;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOutgoingChannelEstablished(final MessageChannel connection) {
        TopologyMap topologyMap = this.topologyMap;
        synchronized (topologyMap) {
            this.log.debug((Object)("Registering connection " + connection.getChannelId() + " at node " + this.ownNodeId));
            this.registerNewConnection(connection);
            if (!connection.getInitiatedByRemote()) {
                LinkStateAdvertisementBatch payloadLsaCache = this.topologyMap.generateLsaBatchOfAllNodes();
                this.log.debug((Object)("Sending initial LSA batch into connection " + connection.getChannelId()));
                byte[] lsaBytes = MessageUtils.serializeSafeObject(payloadLsaCache);
                NetworkRequest lsaRequest = NetworkRequestFactory.createNetworkRequest(lsaBytes, "lsa", this.ownNodeId, connection.getRemoteNodeInformation().getInstanceNodeSessionId());
                this.directMessagingSender.sendDirectMessageAsync(lsaRequest, connection, new NetworkResponseHandler(){

                    @Override
                    public void onResponseAvailable(NetworkResponse response) {
                        if (!response.isSuccess()) {
                            LinkStateRoutingProtocolManager.this.log.warn((Object)("Failed to send initial LSA batch via connection " + connection.getChannelId() + ": Code " + (Object)((Object)response.getResultCode())));
                            return;
                        }
                        try {
                            Serializable deserializedContent = response.getDeserializedContent();
                            if (deserializedContent instanceof LinkStateAdvertisementBatch) {
                                boolean topologyChanged = LinkStateRoutingProtocolManager.this.handleInitialLSABatchResponse(deserializedContent);
                                LinkStateRoutingProtocolManager.this.onOutgoingChannelHandshakeCompleted(connection, topologyChanged);
                            } else {
                                LinkStateRoutingProtocolManager.this.log.error((Object)("Unexpected response to initial LSA batch: " + deserializedContent));
                            }
                        }
                        catch (SerializationException e) {
                            LinkStateRoutingProtocolManager.this.log.error((Object)"Failed to deserialize response to initial LSA batch", (Throwable)e);
                        }
                    }
                });
            } else {
                this.broadcastNewLocalLSA();
            }
        }
        this.fireTopologyChangedListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOutgoingChannelTerminated(MessageChannel connection) {
        Map<String, MessageChannel> map = this.connectionsById;
        synchronized (map) {
            String channelId = connection.getChannelId();
            TopologyLink link = this.topologyMap.getLinkForConnection(channelId);
            if (link == null) {
                this.log.debug((Object)("Channel " + channelId + " to unregister does not exist in the topology; " + "the usual cause is that the remote node " + connection.getRemoteNodeInformation().getInstanceNodeSessionId() + " was removed after a shutdown notice"));
            } else if (!this.topologyMap.removeLink(link)) {
                this.log.warn((Object)("Unexpected state: Channel was found in topology, but could not be removed; id=" + channelId));
            }
            MessageChannel registeredConnection = this.connectionsById.get(channelId);
            if (registeredConnection == null) {
                this.log.warn((Object)("No registered connection for id " + channelId));
                return;
            }
            if (registeredConnection != connection) {
                this.log.warn((Object)("Another connection is registered under id " + channelId + "; ignoring unregistration"));
                return;
            }
            this.connectionsById.remove(channelId);
            this.log.debug((Object)StringUtils.format((String)"Unregistered connection %s from %s", (Object[])new Object[]{connection.toString(), this.ownNodeInformation.getLogDescription()}));
        }
        this.broadcastNewLocalLSA();
        this.fireTopologyChangedListener();
    }

    private void onMaxTimeToLiveReached(Serializable messageContent, Map<String, String> metaData, NetworkContactPoint ncp) {
        this.networkStats.incFailedCommunications();
        this.log.debug((Object)StringUtils.format((String)"'%s' reports that a message that was issued by '%s' exeeded the maximum time to live (%s).", (Object[])new Object[]{this.ownNodeId, MessageMetaData.wrap(metaData).getSender(), timeToLive}));
    }

    private void onMessageReceived(String messageId, Serializable messageContent) {
    }

    public InstanceNodeSessionId getOwner() {
        return this.ownNodeId;
    }

    protected void addToMessageBuffer(String messageId, Serializable messageContent) {
        this.messageBuffer.put(messageId, messageContent);
        this.onMessageReceived(messageId, messageContent);
    }

    public TopologyMap getTopologyMap() {
        return this.topologyMap;
    }

    public NetworkStats getNetworkStats() {
        return this.networkStats;
    }

    public int getTimeToLive() {
        return timeToLive;
    }

    public Map<String, Serializable> getMessageBuffer() {
        return this.messageBuffer;
    }

    private void fireTopologyChangedListener() {
        if (this.topologyChangeListener != null) {
            this.topologyChangeListener.onNetworkTopologyChanged();
        }
    }

    private static class LSANetworkRequestHandler
    implements NetworkRequestHandler {
        private LinkStateRoutingProtocolManager protocolManager;

        LSANetworkRequestHandler(LinkStateRoutingProtocolManager protocolManager) {
            this.protocolManager = protocolManager;
        }

        @Override
        public NetworkResponse handleRequest(NetworkRequest request, InstanceNodeSessionId sourceId) throws InternalMessagingException {
            Serializable messageContent = NetworkRequestUtils.deserializeWithExceptionHandling(request);
            Serializable responseBody = messageContent instanceof LinkStateAdvertisementBatch ? this.protocolManager.handleReceivedInitialLSABatch(messageContent) : this.protocolManager.handleSingleLinkStateAdvertisement(messageContent, request.accessRawMetaData());
            byte[] responseBodyBytes = MessageUtils.serializeSafeObject(responseBody);
            return NetworkResponseFactory.generateSuccessResponse(request, responseBodyBytes);
        }
    }

    private class MessageChannelLifecycleHandler
    extends MessageChannelLifecycleListenerAdapter {
        private MessageChannelLifecycleHandler() {
        }

        @Override
        public void onOutgoingChannelEstablished(MessageChannel connection) {
            LinkStateRoutingProtocolManager.this.handleOutgoingChannelEstablished(connection);
        }

        @Override
        public void onOutgoingChannelTerminated(MessageChannel connection) {
            LinkStateRoutingProtocolManager.this.handleOutgoingChannelTerminated(connection);
        }
    }
}

