/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.model.impl;

import de.rcenvironment.core.communication.model.NetworkResponse;
import de.rcenvironment.core.communication.model.internal.AbstractNetworkMessage;
import de.rcenvironment.core.communication.protocol.ProtocolConstants;
import java.util.Map;

public class NetworkResponseImpl
extends AbstractNetworkMessage
implements NetworkResponse {
    public static final String METADATA_KEY_RESULT_CODE = "response.resultCode";
    private static final String SUCCESS_CODE_STRING = Integer.toString(ProtocolConstants.ResultCode.SUCCESS.getCode());

    public NetworkResponseImpl(byte[] body, String requestId, ProtocolConstants.ResultCode resultCode) {
        this.setContentBytes(body);
        this.setRequestId(requestId);
        this.setResultCode(resultCode.getCode());
    }

    public NetworkResponseImpl(byte[] body, Map<String, String> metaData) {
        super(metaData);
        this.setContentBytes(body);
    }

    @Override
    public boolean isSuccess() {
        return SUCCESS_CODE_STRING.equals(this.metaDataWrapper.getValue(METADATA_KEY_RESULT_CODE));
    }

    @Override
    public ProtocolConstants.ResultCode getResultCode() {
        try {
            return ProtocolConstants.ResultCode.fromCode(Integer.parseInt(this.metaDataWrapper.getValue(METADATA_KEY_RESULT_CODE)));
        }
        catch (NumberFormatException numberFormatException) {
            return ProtocolConstants.ResultCode.UNDEFINED;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return ProtocolConstants.ResultCode.UNDEFINED;
        }
    }

    private void setResultCode(int code) {
        this.metaDataWrapper.setValue(METADATA_KEY_RESULT_CODE, Integer.toString(code));
    }
}

