/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.palette.toolidentification;

import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.gui.palette.toolidentification.ToolType;
import java.util.Optional;

public class ToolIdentification {
    private static final String INTEGRATION_ID_PREFIX = "de.rcenvironment.integration.";
    private static final String WORKFLOW_ID_PREFIX = "de.rcenvironment.integration.workflow";
    private String toolID;
    private String toolName;
    private ToolType toolType;
    private Optional<String> integrationType = Optional.empty();

    protected ToolIdentification(String toolID, String toolName, ToolType toolType) {
        this.toolID = toolID;
        this.toolName = toolName;
        this.toolType = toolType;
    }

    public static ToolIdentification createToolIdentification(DistributedComponentEntry componentEntry) {
        ToolType toolType;
        String toolID = componentEntry.getComponentInterface().getIdentifierAndVersion();
        String toolName = componentEntry.getDisplayName();
        Optional<String> integrationType = Optional.empty();
        if (toolID.startsWith(WORKFLOW_ID_PREFIX)) {
            toolType = ToolType.INTEGRATED_WORKFLOW;
        } else if (toolID.startsWith(INTEGRATION_ID_PREFIX)) {
            toolType = ToolType.INTEGRATED_TOOL;
            integrationType = Optional.of(toolID.substring(INTEGRATION_ID_PREFIX.length(), toolID.indexOf(".", INTEGRATION_ID_PREFIX.length())));
        } else {
            toolType = ToolType.STANDARD_COMPONENT;
        }
        ToolIdentification identification = new ToolIdentification(toolID, toolName, toolType);
        if (integrationType.isPresent()) {
            identification.setIntegrationType(integrationType);
        }
        return identification;
    }

    public static ToolIdentification createIntegratedToolIdentification(String toolID, String toolName) {
        return new ToolIdentification(toolID, toolName, ToolType.INTEGRATED_TOOL);
    }

    public static ToolIdentification createIntegratedWorkflowIdentification(String toolID, String toolName) {
        return new ToolIdentification(toolID, toolName, ToolType.INTEGRATED_WORKFLOW);
    }

    public static ToolIdentification createStandardComponentIdentification(String toolID, String toolName) {
        return new ToolIdentification(toolID, toolName, ToolType.STANDARD_COMPONENT);
    }

    public String getToolID() {
        return this.toolID;
    }

    public String getToolName() {
        return this.toolName;
    }

    public ToolType getType() {
        return this.toolType;
    }

    public int hashCode() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getToolName());
        builder.append((Object)this.getType());
        builder.append(ComponentUtils.getComponentInterfaceIdentifierWithoutVersion((String)this.getToolID()));
        return builder.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolIdentification)) {
            return false;
        }
        ToolIdentification other = (ToolIdentification)obj;
        if (this.getToolName() == null ? other.getToolName() != null : !this.getToolName().equals(other.getToolName())) {
            return false;
        }
        if (this.getType() == null ? other.getType() != null : !this.getType().equals((Object)other.getType())) {
            return false;
        }
        return !(this.toolID == null ? other.toolID != null : !ComponentUtils.getComponentInterfaceIdentifierWithoutVersion((String)this.toolID).equals(ComponentUtils.getComponentInterfaceIdentifierWithoutVersion((String)other.toolID)));
    }

    public Optional<String> getIntegrationType() {
        return this.integrationType;
    }

    public void setIntegrationType(Optional<String> integrationType) {
        this.integrationType = integrationType;
    }
}

