/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view;

import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionHandle;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionService;
import de.rcenvironment.core.gui.workflow.view.WorkflowRunEditor;
import de.rcenvironment.core.gui.workflow.view.WorkflowRunEditorService;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public abstract class WorkflowRunCommandHandler
extends AbstractHandler {
    private WorkflowExecutionService executionService;
    private WorkflowRunEditorService workflowRunEditorService;

    protected WorkflowRunCommandHandler() {
        ServiceRegistryAccess serviceAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
        this.executionService = (WorkflowExecutionService)serviceAccess.getService(WorkflowExecutionService.class);
        this.workflowRunEditorService = (WorkflowRunEditorService)serviceAccess.getService(WorkflowRunEditorService.class);
    }

    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        Optional<WorkflowRunEditor> editor = this.workflowRunEditorService.getCurrentWorkflowRunEditor();
        if (!editor.isPresent()) {
            return null;
        }
        WorkflowExecutionHandle executionInformation = editor.get().getWorkflowExecutionInformation().getWorkflowExecutionHandle();
        try {
            this.manipulateWorkflow(executionInformation);
        }
        catch (ExecutionControllerException | RemoteOperationException throwable) {}
        return null;
    }

    protected WorkflowExecutionService getWorkflowExecutionService() {
        return this.executionService;
    }

    protected abstract void manipulateWorkflow(WorkflowExecutionHandle var1) throws ExecutionControllerException, RemoteOperationException;
}

