/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.properties;

import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNodeUtil;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.gui.workflow.editor.commands.CompositeCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.AbstractWorkflowNodeCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowPropertySection;
import de.rcenvironment.core.gui.workflow.parts.WorkflowNodePart;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class WorkflowNodePropertySection
extends WorkflowPropertySection
implements WorkflowNodeCommand.Executor {
    public static final String CONTROL_PROPERTY_KEY = "property.control";
    public static final String ENUM_TYPE_KEY = "property.enum.type";
    public static final String ENUM_VALUE_KEY = "property.enum.value";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected WorkflowNode node;
    private final Map<String, Map<Enum<?>, Set<Control>>> enumGroups = new HashMap();
    private ComponentInstanceProperties modelBindingTarget;
    private ComponentInstanceProperties lastRefreshConfiguration;
    private EditConfigurationValueCommand openEditCommand;
    private Composite composite;
    private final Controller controller = this.createController();
    private final Synchronizer synchronizer = this.createSynchronizer();
    private final SynchronizerAdapter synchronizerAdapter = new SynchronizerAdapter();
    private final Updater updater = this.createUpdater();

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        Object firstSelectionElement = ((IStructuredSelection)selection).getFirstElement();
        WorkflowNodePart workflowNodePart = (WorkflowNodePart)firstSelectionElement;
        WorkflowNode workflowNode = (WorkflowNode)workflowNodePart.getModel();
        if (this.getPart() == null || !this.getPart().equals(part) || this.node == null || !this.node.equals((Object)workflowNode)) {
            super.setInput(part, selection);
            this.setWorkflowNodeBase(workflowNode);
        }
    }

    protected Composite getComposite() {
        return this.composite;
    }

    private void setWorkflowNodeBase(WorkflowNode workflowNode) {
        this.tearDownModelBindingBase();
        this.node = workflowNode;
        this.initializeModelBindingBase();
        this.setWorkflowNode(workflowNode);
    }

    protected void setWorkflowNode(WorkflowNode workflowNode) {
    }

    private void initializeModelBindingBase() {
        if (this.modelBindingTarget == null) {
            this.modelBindingTarget = this.getConfiguration();
            this.modelBindingTarget.addPropertyChangeListener((PropertyChangeListener)this.synchronizerAdapter);
            this.afterInitializingModelBinding();
        }
    }

    protected void afterInitializingModelBinding() {
    }

    public void dispose() {
        this.tearDownModelBindingBase();
        super.dispose();
    }

    private void tearDownModelBindingBase() {
        if (this.modelBindingTarget != null) {
            RuntimeException exception = null;
            try {
                this.beforeTearingDownModelBinding();
            }
            catch (RuntimeException e) {
                exception = e;
            }
            this.modelBindingTarget.removePropertyChangeListener((PropertyChangeListener)this.synchronizerAdapter);
            this.modelBindingTarget = null;
            if (exception != null) {
                throw new RuntimeException("Tearing down model binding failed in derived class:", exception);
            }
        }
    }

    protected void beforeTearingDownModelBinding() {
    }

    @Deprecated
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.composite = parent;
        this.createCompositeContent(this.composite, aTabbedPropertySheetPage);
        this.initializeController();
        this.initializeEnumGroups();
    }

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
    }

    protected final Controller getController() {
        return this.controller;
    }

    protected Controller createController() {
        return new DefaultController();
    }

    protected void initializeController() {
        Controller controller2 = this.getController();
        if (this.composite != null && controller2 != null) {
            this.initializeController(controller2, this.composite);
        }
    }

    protected void initializeController(Controller controller2, Composite parent) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            String property = (String)control.getData(CONTROL_PROPERTY_KEY);
            if (control instanceof CTabFolder) {
                CTabFolder tabFolder = (CTabFolder)control;
                CTabItem[] cTabItemArray = tabFolder.getItems();
                int n3 = cTabItemArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    CTabItem item = cTabItemArray[n4];
                    if (item.getControl() != null && item.getControl() instanceof Composite) {
                        this.initializeController(controller2, (Composite)item.getControl());
                    }
                    ++n4;
                }
            } else if (control instanceof Composite) {
                this.initializeController(controller2, (Composite)control);
            }
            boolean activeControl = control instanceof Button;
            if (activeControl || property != null) {
                control.addFocusListener((FocusListener)controller2);
                control.addKeyListener((KeyListener)controller2);
                if (control instanceof Button) {
                    ((Button)control).addSelectionListener((SelectionListener)controller2);
                } else if (control instanceof Text) {
                    ((Text)control).addSelectionListener((SelectionListener)controller2);
                    ((Text)control).addModifyListener((ModifyListener)controller2);
                } else if (control instanceof StyledText) {
                    ((StyledText)control).addSelectionListener((SelectionListener)controller2);
                    ((StyledText)control).addModifyListener((ModifyListener)controller2);
                } else if (control instanceof Combo) {
                    ((Combo)control).addSelectionListener((SelectionListener)controller2);
                } else if (control instanceof CCombo) {
                    ((CCombo)control).addSelectionListener((SelectionListener)controller2);
                    ((CCombo)control).addModifyListener((ModifyListener)controller2);
                } else if (control instanceof Spinner) {
                    ((Spinner)control).addSelectionListener((SelectionListener)controller2);
                    ((Spinner)control).addModifyListener((ModifyListener)controller2);
                }
            }
            ++n2;
        }
    }

    protected void initializeEnumGroups() {
        if (this.composite != null) {
            this.initializeEnumGroups(this.composite);
        }
    }

    protected void initializeEnumGroups(Composite composite2) {
        Control[] controlArray = composite2.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                this.initializeEnumGroups((Composite)control);
            }
            String property = (String)control.getData(CONTROL_PROPERTY_KEY);
            Class enumType = (Class)control.getData(ENUM_TYPE_KEY);
            Enum enumValue = (Enum)control.getData(ENUM_VALUE_KEY);
            if (property != null && enumType != null && enumValue != null) {
                Map<Enum<?>, Set<Control>> enumGroup;
                if (!enumType.isAssignableFrom(enumValue.getClass())) {
                    throw new RuntimeException();
                }
                if (!this.enumGroups.containsKey(property)) {
                    this.enumGroups.put(property, new HashMap());
                }
                if (!(enumGroup = this.enumGroups.get(property)).containsKey(enumValue)) {
                    enumGroup.put(enumValue, new HashSet());
                }
                enumGroup.get(enumValue).add(control);
            }
            ++n2;
        }
    }

    protected boolean isEnumControl(Control control) {
        String property = (String)control.getData(CONTROL_PROPERTY_KEY);
        Class enumType = (Class)control.getData(ENUM_TYPE_KEY);
        Enum enumValue = (Enum)control.getData(ENUM_VALUE_KEY);
        boolean result = control instanceof Button && (control.getStyle() & 0x10) != 0;
        return result &= property != null && enumType != null && enumValue != null;
    }

    protected final Synchronizer getSynchronizer() {
        return this.synchronizer;
    }

    protected Synchronizer createSynchronizer() {
        return new DefaultSynchronizer();
    }

    protected Updater getUpdater() {
        return this.updater;
    }

    protected Updater createUpdater() {
        return new DefaultUpdater();
    }

    protected void addPropertyChangeListener(PropertyChangeListener listener) {
        this.node.addPropertyChangeListener(listener);
    }

    protected void removePropertyChangeListener(PropertyChangeListener listener) {
        this.node.removePropertyChangeListener(listener);
    }

    protected ComponentInstanceProperties getReadableConfiguration() {
        return this.node;
    }

    public ComponentInstanceProperties getConfiguration() {
        if (this.getCommandStack() == null || this.node == null) {
            throw new IllegalStateException("Property input not set");
        }
        return this.node;
    }

    protected boolean hasInputs() {
        return WorkflowNodeUtil.hasInputs((WorkflowNode)this.node);
    }

    protected boolean hasOutputs() {
        return WorkflowNodeUtil.hasOutputs((WorkflowNode)this.node);
    }

    protected boolean hasInputs(DataType type) {
        return WorkflowNodeUtil.hasInputs((WorkflowNode)this.node, (DataType)type);
    }

    protected boolean hasOutputs(DataType type) {
        return WorkflowNodeUtil.hasOutputs((WorkflowNode)this.node, (DataType)type);
    }

    protected Set<EndpointDescription> getInputs() {
        return WorkflowNodeUtil.getInputs((WorkflowNode)this.node);
    }

    protected Set<EndpointDescription> getInputs(DataType type) {
        return WorkflowNodeUtil.getInputsByDataType((WorkflowNode)this.node, (DataType)type);
    }

    protected Set<EndpointDescription> getOutputs() {
        return WorkflowNodeUtil.getOutputs((WorkflowNode)this.node);
    }

    protected Set<EndpointDescription> getOutputs(DataType type) {
        return WorkflowNodeUtil.getOutputs((WorkflowNode)this.node, (DataType)type);
    }

    protected boolean isPropertySet(String key) {
        return WorkflowNodeUtil.isConfigurationValueSet((ComponentInstanceProperties)this.node, (String)key);
    }

    protected String getProperty(String key) {
        if (this.node != null) {
            String s = WorkflowNodeUtil.getConfigurationValue((ComponentInstanceProperties)this.node, (String)key);
            return s;
        }
        return null;
    }

    protected void setProperty(String key, String value) {
        String oldValue = WorkflowNodeUtil.getConfigurationValue((ComponentInstanceProperties)this.node, (String)key);
        this.setProperty(key, oldValue, value);
    }

    protected void setProperty(String key, String oldValue, String newValue) {
        if (oldValue != null && !oldValue.equals(newValue) || oldValue == null && oldValue != newValue) {
            SetConfigurationValueCommand command = new SetConfigurationValueCommand(key, oldValue, newValue);
            this.execute(command);
        }
    }

    protected void setPropertyNotUndoable(String key, String value) {
        String oldValue = WorkflowNodeUtil.getConfigurationValue((ComponentInstanceProperties)this.node, (String)key);
        this.setPropertyNotUndoable(key, oldValue, value);
    }

    protected void setPropertyNotUndoable(String key, String oldValue, String newValue) {
        if (oldValue != null && !oldValue.equals(newValue) || oldValue == null && oldValue != newValue) {
            SetConfigurationValueCommand command = new SetConfigurationValueCommand(key, oldValue, newValue);
            command.setCommandStack(this.getCommandStack());
            command.setWorkflowNode(this.node);
            ((WorkflowCommand)command).initialize();
            ((WorkflowCommand)command).execute();
        }
    }

    protected void setProperties(String key1, String newValue1, String ... keysAndValues) {
        if (keysAndValues.length % 2 == 1) {
            throw new InvalidParameterException("Method setProperties must be called with an even number of arguments.");
        }
        WorkflowCommand currentCommand = this.reduceKeyValueListToWorkflowCommand(key1, newValue1, keysAndValues);
        if (currentCommand != null) {
            currentCommand.setCommandStack(this.getCommandStack());
            currentCommand.initialize();
            if (currentCommand.canExecute()) {
                this.getCommandStack().execute((Command)new WorkflowPropertySection.CommandWrapper(currentCommand));
            }
        }
    }

    private WorkflowCommand reduceKeyValueListToWorkflowCommand(String key1, String newValue1, String ... keysAndValues) {
        WorkflowCommand currentCommand = null;
        String oldValue1 = WorkflowNodeUtil.getConfigurationValue((ComponentInstanceProperties)this.node, (String)key1);
        WorkflowCommand initialCommand = this.buildSetConfigurationValueCommand(key1, oldValue1, newValue1);
        if (initialCommand != null) {
            currentCommand = initialCommand;
        }
        int i = 0;
        while (i < keysAndValues.length) {
            String key = keysAndValues[i];
            String newValue = keysAndValues[i + 1];
            String oldValue = WorkflowNodeUtil.getConfigurationValue((ComponentInstanceProperties)this.node, (String)key);
            WorkflowCommand newCommand = this.buildSetConfigurationValueCommand(key, oldValue, newValue);
            if (currentCommand != null && newCommand != null) {
                currentCommand = new CompositeCommand(currentCommand, newCommand);
            } else if (currentCommand == null && newCommand != null) {
                currentCommand = newCommand;
            }
            i += 2;
        }
        return currentCommand;
    }

    private WorkflowCommand buildSetConfigurationValueCommand(String key, String oldValue, String newValue) {
        if (newValue != null && !newValue.equals(oldValue) || newValue == null && oldValue != null) {
            SetConfigurationValueCommand newCommand = new SetConfigurationValueCommand(key, oldValue, newValue);
            newCommand.setWorkflowNode(this.node);
            return newCommand;
        }
        return null;
    }

    protected EditConfigurationValueCommand editProperty(String key) {
        String oldValue = WorkflowNodeUtil.getConfigurationValue((ComponentInstanceProperties)this.node, (String)key);
        EditConfigurationValueCommand command = new EditConfigurationValueCommand(key, oldValue);
        this.execute(command);
        return command;
    }

    public void execute(WorkflowNode workflowNode, WorkflowNodeCommand command) {
        if (this.openEditCommand != null) {
            this.openEditCommand.finishEditing();
            this.openEditCommand = null;
        }
        command.setCommandStack(this.getCommandStack());
        command.setWorkflowNode(workflowNode);
        command.initialize();
        if (command.canExecute()) {
            this.getCommandStack().execute((Command)new NodeCommandWrapper(command));
            if (command instanceof EditConfigurationValueCommand) {
                this.openEditCommand = (EditConfigurationValueCommand)command;
            }
        }
    }

    @Override
    public void execute(WorkflowNodeCommand command) {
        this.execute(this.node, command);
    }

    public final void refresh() {
        if (this.lastRefreshConfiguration == null || this.lastRefreshConfiguration != this.getConfiguration()) {
            this.refreshSection();
            this.lastRefreshConfiguration = this.getConfiguration();
        }
    }

    protected void refreshSection() {
        if (this.composite != null) {
            this.refreshComposite(this.composite);
        }
    }

    protected void refreshComposite(Composite composite2) {
        if (composite2.isDisposed()) {
            return;
        }
        Control[] controlArray = composite2.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (!control.isDisposed()) {
                String propertyKey;
                if (control instanceof Composite) {
                    this.refreshComposite((Composite)control);
                }
                if ((propertyKey = (String)control.getData(CONTROL_PROPERTY_KEY)) != null) {
                    String propertyValue = this.getProperty(propertyKey);
                    this.getUpdater().initializeControl(control, propertyKey, propertyValue);
                }
            }
            ++n2;
        }
    }

    private static boolean isBooleanButton(Control button) {
        return button instanceof Button && (button.getStyle() & 0x20) != 0 || (button.getStyle() & 2) != 0 || (button.getStyle() & 0x10) != 0;
    }

    protected static interface Controller
    extends SelectionListener,
    FocusListener,
    KeyListener,
    ModifyListener {
    }

    protected class DefaultController
    implements Controller {
        protected EditConfigurationValueCommand editCommand;

        protected DefaultController() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }

        public void widgetSelected(SelectionEvent event) {
            Object source = event.getSource();
            if (source instanceof Control) {
                Enum enumValue;
                Control control = (Control)source;
                this.widgetSelected(event, control);
                String property = (String)control.getData(WorkflowNodePropertySection.CONTROL_PROPERTY_KEY);
                if (property != null) {
                    this.widgetSelected(event, control, property);
                }
                if ((enumValue = (Enum)control.getData(WorkflowNodePropertySection.ENUM_VALUE_KEY)) != null) {
                    this.widgetSelected(event, control, property, enumValue);
                }
            }
        }

        protected void widgetSelected(SelectionEvent event, Control source) {
        }

        protected void widgetSelected(SelectionEvent event, Control source, String property) {
            if (source instanceof Button) {
                Button button = (Button)source;
                if (WorkflowNodePropertySection.isBooleanButton((Control)button)) {
                    boolean selected = button.getSelection();
                    WorkflowNodePropertySection.this.setProperty(property, String.valueOf(selected));
                }
            } else if (source instanceof Spinner) {
                Spinner spinner = (Spinner)source;
                Integer spinnerValue = spinner.getSelection();
                if (this.getProperty(property) != null) {
                    Integer propertyValue = Integer.valueOf(this.getProperty(property));
                    if (spinnerValue != null && !spinnerValue.equals(propertyValue)) {
                        WorkflowNodePropertySection.this.setProperty(property, String.valueOf(spinnerValue));
                    }
                } else if (spinnerValue != null) {
                    WorkflowNodePropertySection.this.setProperty(property, String.valueOf(spinnerValue));
                }
            }
        }

        protected void widgetSelected(SelectionEvent event, Control source, String property, Object value) {
            if (value instanceof Enum) {
                Enum enumValue = (Enum)value;
                WorkflowNodePropertySection.this.setProperty(property, enumValue.name());
            }
        }

        public void focusGained(FocusEvent event) {
        }

        public void focusLost(FocusEvent event) {
            if (this.editCommand != null) {
                this.editCommand.finishEditing();
                this.editCommand = null;
            }
        }

        public void modifyText(ModifyEvent event) {
            Object source = event.getSource();
            if (source instanceof Control) {
                String propertyContent;
                CCombo text;
                String textContent;
                Control control = (Control)source;
                String property = (String)control.getData(WorkflowNodePropertySection.CONTROL_PROPERTY_KEY);
                if (source instanceof Text && property != null) {
                    String propertyContent2;
                    Text text2 = (Text)source;
                    String textContent2 = text2.getText();
                    if (!textContent2.equals(propertyContent2 = this.getProperty(property))) {
                        if (this.editCommand == null || !this.editCommand.isEditable()) {
                            this.editCommand = this.editProperty(property);
                        }
                        this.editCommand.setNewValue(textContent2);
                    }
                } else if (source instanceof StyledText && property != null) {
                    String propertyContent3;
                    StyledText text3 = (StyledText)source;
                    String textContent3 = text3.getText();
                    if (!textContent3.equals(propertyContent3 = this.getProperty(property))) {
                        if (this.editCommand == null || !this.editCommand.isEditable()) {
                            this.editCommand = this.editProperty(property);
                        }
                        this.editCommand.setNewValue(textContent3);
                    }
                } else if (source instanceof CCombo && property != null && !(textContent = (text = (CCombo)source).getText()).equals(propertyContent = this.getProperty(property))) {
                    if (this.editCommand == null || !this.editCommand.isEditable()) {
                        this.editCommand = this.editProperty(property);
                    }
                    this.editCommand.setNewValue(textContent);
                }
            }
        }

        public void keyPressed(KeyEvent event) {
            Object source = event.getSource();
            if (source instanceof Text) {
                Text text = (Text)source;
                if (this.isCarriageReturn(event) && !this.isMultiLineText(text)) {
                    text.traverse(16);
                }
            } else if (source instanceof StyledText) {
                StyledText text = (StyledText)source;
                if (this.isCarriageReturn(event) && !this.isMultiLineText(text)) {
                    text.traverse(16);
                }
            } else if (source instanceof CCombo) {
                CCombo text = (CCombo)source;
                if (this.isCarriageReturn(event)) {
                    text.traverse(16);
                }
            }
        }

        protected boolean isCarriageReturn(KeyEvent event) {
            return event.keyCode == 13 || event.keyCode == 0x1000050;
        }

        protected boolean isMultiLineText(Text text) {
            return (text.getStyle() & 2) != 0;
        }

        protected boolean isMultiLineText(StyledText text) {
            return (text.getStyle() & 2) != 0;
        }

        public void keyReleased(KeyEvent event) {
        }

        protected void replace(Text text, String replacement) {
            String textValue = text.getText();
            Point selection = text.getSelection();
            String newValue = String.valueOf(textValue.substring(0, selection.x)) + replacement + textValue.substring(selection.y);
            String property = (String)text.getData(WorkflowNodePropertySection.CONTROL_PROPERTY_KEY);
            if (!newValue.equals(textValue)) {
                int newY;
                int newX;
                if (property != null) {
                    if (this.editCommand == null) {
                        this.editCommand = this.editProperty(property);
                    }
                    this.editCommand.setNewValue(newValue);
                }
                text.setText(newValue);
                if (selection.x != selection.y) {
                    newX = selection.x;
                    newY = selection.x + replacement.length();
                } else {
                    newY = newX = selection.x + replacement.length();
                }
                text.setSelection(newX, newY);
            }
        }

        protected String getProperty(String key) {
            if (this.editCommand != null && this.editCommand.isEditable() && key.equals(this.editCommand.getKey())) {
                return this.editCommand.getNewValue();
            }
            return WorkflowNodePropertySection.this.getProperty(key);
        }

        protected EditConfigurationValueCommand editProperty(String key) {
            return WorkflowNodePropertySection.this.editProperty(key);
        }
    }

    protected class DefaultSynchronizer
    implements Synchronizer {
        protected DefaultSynchronizer() {
        }

        @Override
        public void handlePropertyChange(String propertyName, String newValue, String oldValue) {
            Composite compositeInst = WorkflowNodePropertySection.this.getComposite();
            if (compositeInst != null) {
                this.recursePropertyChange(compositeInst, propertyName, newValue, oldValue);
            }
        }

        protected void recursePropertyChange(Composite compositeInst, String key, String newValue, String oldValue) {
            Control[] controlArray = compositeInst.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                String linkedKey;
                Control control = controlArray[n2];
                if (control instanceof Composite) {
                    this.recursePropertyChange((Composite)control, key, newValue, oldValue);
                }
                if ((linkedKey = (String)control.getData(WorkflowNodePropertySection.CONTROL_PROPERTY_KEY)) != null && linkedKey.equals(key)) {
                    this.handlePropertyChange(control, key, newValue, oldValue);
                }
                ++n2;
            }
        }

        protected void handlePropertyChange(Control control, String key, String newValue, String oldValue) {
            WorkflowNodePropertySection.this.getUpdater().updateControl(control, key, newValue, oldValue);
        }
    }

    protected class DefaultUpdater
    implements Updater {
        protected DefaultUpdater() {
        }

        @Override
        public void initializeControl(Control control, String propertyName, String value) {
            this.updateControl(control, propertyName, value, null);
        }

        @Override
        public void updateControl(Control control, String propertyName, String newValue, String oldValue) {
            if (control instanceof Text && (newValue == null || newValue instanceof String)) {
                Text textControl = (Text)control;
                String valueOrDefault = this.valueOrDefault(newValue, "");
                if (!valueOrDefault.equals(textControl.getText())) {
                    textControl.setText(valueOrDefault);
                }
            } else if (control instanceof StyledText && (newValue == null || newValue instanceof String)) {
                StyledText textControl = (StyledText)control;
                String valueOrDefault = this.valueOrDefault(newValue, "");
                if (!valueOrDefault.equals(textControl.getText())) {
                    textControl.setText(valueOrDefault);
                }
            } else if (control instanceof Label) {
                Label labelControl = (Label)control;
                String valueOrDefault = this.stringValue(control, newValue, "");
                if (!valueOrDefault.equals(labelControl.getText())) {
                    labelControl.setText(valueOrDefault);
                }
            } else if (control instanceof Button && WorkflowNodePropertySection.isBooleanButton(control)) {
                Button buttonControl = (Button)control;
                String valueOrDefault = this.valueOrDefault(newValue, Boolean.FALSE.toString());
                if (!valueOrDefault.equals(buttonControl.getSelection())) {
                    buttonControl.setSelection(Boolean.valueOf(valueOrDefault).booleanValue());
                }
            } else if (control instanceof Spinner) {
                Spinner spinnerControl = (Spinner)control;
                String valueOrDefault = this.stringValue(control, newValue, "0");
                if (!valueOrDefault.equals(spinnerControl.getSelection())) {
                    spinnerControl.setSelection(Integer.valueOf(valueOrDefault).intValue());
                }
            } else if (control instanceof Button && WorkflowNodePropertySection.this.isEnumControl(control)) {
                Class enumType = (Class)control.getData(WorkflowNodePropertySection.ENUM_TYPE_KEY);
                Enum enumValue = (Enum)control.getData(WorkflowNodePropertySection.ENUM_VALUE_KEY);
                Enum<?> newEnumValue = this.getEnum(enumType, newValue);
                boolean isSelected = enumValue.equals(newEnumValue);
                ((Button)control).setSelection(isSelected);
            } else if (control instanceof CCombo && (newValue == null || newValue instanceof String)) {
                CCombo combobox = (CCombo)control;
                String valueOrDefault = this.valueOrDefault(newValue, "");
                if (!valueOrDefault.equals(combobox.getText())) {
                    combobox.setText(valueOrDefault);
                }
            } else if (control instanceof Combo && (newValue == null || newValue instanceof String)) {
                Combo combobox = (Combo)control;
                String valueOrDefault = this.valueOrDefault(newValue, "");
                if (!valueOrDefault.equals(combobox.getText())) {
                    combobox.setText(valueOrDefault);
                }
            }
        }

        private Enum<?> getEnum(Class<? extends Enum<?>> enumType, String name) {
            Enum result = null;
            Field[] fieldArray = enumType.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.isEnumConstant()) {
                    try {
                        Enum enumValue = (Enum)field.get(enumType);
                        if (enumValue.name().equals(name)) {
                            result = enumValue;
                            break;
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                ++n2;
            }
            return result;
        }

        private String stringValue(Control control, String value, String defaultValue) {
            String result = value != null ? value : defaultValue;
            return result;
        }

        protected String valueOrDefault(String value, String defaultValue) {
            String result = value != null ? value : defaultValue;
            return result;
        }
    }

    protected static final class EditConfigurationValueCommand
    extends AbstractWorkflowNodeCommand {
        private final String key;
        private final String oldValue;
        private String newValue;
        private boolean editable = true;

        private EditConfigurationValueCommand(String key, String oldValue) {
            this(key, oldValue, oldValue);
        }

        private EditConfigurationValueCommand(String key, String oldValue, String newValue) {
            this.key = key;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public void finishEditing() {
            if (this.editable) {
                this.editable = false;
                ConfigurationDescription configDesc = this.getProperties().getConfigurationDescription();
                configDesc.setConfigurationValue(this.key, this.newValue);
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getOldValue() {
            return this.oldValue;
        }

        public String getNewValue() {
            return this.newValue;
        }

        public void setNewValue(String newValue) {
            if (!this.editable) {
                throw new IllegalStateException();
            }
            this.newValue = newValue;
        }

        @Override
        public void execute2() {
            if (!this.editable) {
                ConfigurationDescription configDesc = this.getProperties().getConfigurationDescription();
                configDesc.setConfigurationValue(this.key, this.newValue);
            }
        }

        @Override
        public void undo2() {
            if (this.editable) {
                this.finishEditing();
            }
            ConfigurationDescription configDesc = this.getProperties().getConfigurationDescription();
            configDesc.setConfigurationValue(this.key, this.oldValue);
        }
    }

    public static final class LayoutComposite
    extends Composite {
        private boolean first = true;
        private Integer widthHint = 0;

        public LayoutComposite(Composite parent) {
            this(parent, 0x40000000);
        }

        public LayoutComposite(Composite parent, int style) {
            super(parent, style);
            FillLayout layout = new FillLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.spacing = 0;
            this.setLayout((Layout)layout);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            if (wHint != -1) {
                if (!this.first) {
                    this.widthHint = wHint;
                }
                this.first = false;
            }
            if (this.widthHint != null) {
                wHint = Math.min(this.widthHint, this.getClientArea().width);
            }
            Point result = super.computeSize(wHint, hHint, changed);
            if (this.first && wHint == -1) {
                this.widthHint = result.x;
            }
            result.x = 0;
            return result;
        }
    }

    private static final class NodeCommandWrapper
    extends WorkflowPropertySection.CommandWrapper {
        private final WorkflowNodeCommand command;

        private NodeCommandWrapper(WorkflowNodeCommand command) {
            super(command);
            this.command = command;
        }

        public String getLabel() {
            return this.command.getLabel();
        }
    }

    protected static class SetConfigurationValueCommand
    extends AbstractWorkflowNodeCommand {
        protected final String key;
        protected String oldValue;
        protected String newValue;

        public SetConfigurationValueCommand(String key, String oldValue, String newValue) {
            this.key = key;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void execute2() {
            ConfigurationDescription configDesc = this.getProperties().getConfigurationDescription();
            configDesc.setConfigurationValue(this.key, this.newValue);
        }

        @Override
        public void undo2() {
            ConfigurationDescription configDesc = this.getProperties().getConfigurationDescription();
            configDesc.setConfigurationValue(this.key, this.oldValue);
        }
    }

    public static interface Synchronizer {
        public void handlePropertyChange(String var1, String var2, String var3);
    }

    private final class SynchronizerAdapter
    implements PropertyChangeListener {
        private SynchronizerAdapter() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String propertyNameValue = event.getPropertyName();
            Matcher propertiesPatternMatcher = WorkflowNode.PROPERTIES_PATTERN.matcher(propertyNameValue);
            if (propertiesPatternMatcher.matches()) {
                String propertyName = propertiesPatternMatcher.group(1);
                WorkflowNodePropertySection.this.synchronizer.handlePropertyChange(propertyName, (String)event.getNewValue(), (String)event.getOldValue());
            }
        }
    }

    protected static interface Updater {
        public void initializeControl(Control var1, String var2, String var3);

        public void updateControl(Control var1, String var2, String var3, String var4);
    }
}

