/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.properties;

import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessageStore;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNodeIdentifier;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPropertyListener;

public abstract class ValidatingWorkflowNodePropertySection
extends WorkflowNodePropertySection {
    protected static final String CONTROL_COLORIZED_KEY = "property.control.colorized";
    protected static final String CONTROL_COLOR_KEY = "property.control.color";
    private WorkflowNodeIdentifier componentId;
    private final ComponentValidationMessageStore messageStore = ComponentValidationMessageStore.getInstance();
    private IPropertyListener propertyListener = new IPropertyListener(){

        public void propertyChanged(Object obj, int property) {
            if (property == 1024) {
                ValidatingWorkflowNodePropertySection.this.updateErrorStates();
            }
        }
    };

    @Override
    protected final void afterInitializingModelBinding() {
        this.componentId = ((WorkflowNode)this.getConfiguration()).getIdentifierAsObject();
        this.updateErrorStates();
        this.afterInitializingModelBindingWithValidation();
        this.getPart().addPropertyListener(this.propertyListener);
    }

    protected void afterInitializingModelBindingWithValidation() {
    }

    @Override
    protected void beforeTearingDownModelBinding() {
        try {
            this.beforeTearingDownModelBindingWithValidation();
        }
        finally {
            this.getPart().removePropertyListener(this.propertyListener);
        }
    }

    protected void beforeTearingDownModelBindingWithValidation() {
    }

    protected void updateErrorStates() {
        List messages = this.messageStore.getMessagesByComponentId(this.componentId.toString());
        this.updateErrorStates(messages);
    }

    protected ComponentValidationMessageStore getMessageStore() {
        return this.messageStore;
    }

    protected void updateErrorStates(List<ComponentValidationMessage> messages) {
        this.updateErrorStates(messages, this.getComposite());
    }

    protected void updateErrorStates(List<ComponentValidationMessage> messages, Composite parent) {
        if (parent != null && !parent.isDisposed()) {
            Control[] controlArray = parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (!control.isDisposed()) {
                    String key;
                    if (control instanceof Composite) {
                        this.updateErrorStates(messages, (Composite)control);
                    }
                    if ((key = (String)control.getData("property.control")) != null) {
                        boolean valid = true;
                        for (ComponentValidationMessage message : messages) {
                            if (!key.equals(message.getProperty())) continue;
                            control.setData(CONTROL_COLORIZED_KEY, (Object)true);
                            if (control.getData(CONTROL_COLOR_KEY) == null) {
                                control.setData(CONTROL_COLOR_KEY, (Object)control.getBackground());
                            }
                            if (message.getType() == ComponentValidationMessage.Type.WARNING) {
                                control.setBackground(Display.getDefault().getSystemColor(7));
                            } else {
                                control.setBackground(Display.getDefault().getSystemColor(3));
                            }
                            control.setToolTipText(message.getRelativeMessage());
                            valid = false;
                            break;
                        }
                        Boolean colorized = (Boolean)control.getData(CONTROL_COLORIZED_KEY);
                        if (valid && Boolean.TRUE.equals(colorized)) {
                            control.setData(CONTROL_COLORIZED_KEY, (Object)false);
                            control.setBackground((Color)control.getData(CONTROL_COLOR_KEY));
                            control.setData(CONTROL_COLOR_KEY, null);
                            control.setToolTipText("");
                        }
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public void refreshSection() {
        super.refreshSection();
        this.refreshBeforeValidation();
        this.updateErrorStates();
    }

    protected void refreshBeforeValidation() {
    }
}

