/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.properties;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.AddDynamicInputWithOutputCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.EditDynamicInputCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.EditDynamicInputWithOutputCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.RemoveDynamicInputWithOutputCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.ForwardingEndpointSelectionPane;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InputCoupledWithOutputSelectionPane
extends ForwardingEndpointSelectionPane {
    private final String dynEndpointId;
    private final Refreshable outputPane;
    private Map<String, String> metaDataInput = new HashMap<String, String>();
    private Map<String, String> metaDataOutput = new HashMap<String, String>();

    public InputCoupledWithOutputSelectionPane(String title, String endpointId, WorkflowNodeCommand.Executor executor, Refreshable outputPane) {
        super(title, EndpointType.INPUT, endpointId, new String[0], executor);
        this.dynEndpointId = endpointId;
        this.outputPane = outputPane;
    }

    @Override
    protected void executeAddCommand(String name, DataType type, Map<String, String> metaData) {
        this.metaDataInput.putAll(metaData);
        AddDynamicInputWithOutputCommand command = new AddDynamicInputWithOutputCommand(this.dynEndpointId, name, type, this.metaDataInput, this, this.outputPane);
        command.setMetaDataOutput(this.metaDataOutput);
        this.execute(command);
    }

    @Override
    protected void executeEditCommand(EndpointDescription oldDescription, EndpointDescription newDescription) {
        WorkflowNodeCommand command;
        if (oldDescription.getDynamicEndpointIdentifier().equals(this.dynEndpointIdToManage)) {
            command = new EditDynamicInputWithOutputCommand(oldDescription, newDescription, this, this.outputPane);
            command.setMetaDataOutput(this.metaDataOutput);
        } else {
            command = new EditDynamicInputCommand(oldDescription.getDynamicEndpointIdentifier(), oldDescription.getName(), newDescription.getName(), newDescription.getDataType(), (Map<String, String>)newDescription.getMetaData(), this);
        }
        this.execute(command);
    }

    @Override
    protected void executeRemoveCommand(List<String> names) {
        RemoveDynamicInputWithOutputCommand command = new RemoveDynamicInputWithOutputCommand(this.dynEndpointId, names, this, this.outputPane);
        this.execute(command);
    }

    @Override
    public void setMetaDataInput(Map<String, String> metaDataInput) {
        this.metaDataInput = metaDataInput;
    }

    public void setMetaDataOutput(Map<String, String> metaDataOutput) {
        this.metaDataOutput = metaDataOutput;
    }
}

