/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands;

import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowLabel;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class WorkflowNodeLabelConnectionCreateCommand
extends Command {
    private static final int MINUS_ONE = -1;
    private static final String OPEN_BRACKET = "(";
    private static final String CLOSE_BRACKET = ")";
    private final WorkflowDescription model;
    private final List<WorkflowNode> nodes;
    private final List<Connection> connections;
    private final List<WorkflowLabel> labels;
    private final List<Rectangle> nodeConstraints;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final List<Rectangle> labelConstraints;

    public WorkflowNodeLabelConnectionCreateCommand(List<WorkflowNode> nodes, List<WorkflowLabel> labels, List<Connection> connections, WorkflowDescription model, List<Rectangle> nodeConstraints, List<Rectangle> labelConstraintsToCreate) {
        this.nodes = nodes;
        this.connections = connections;
        this.labels = labels;
        this.model = model;
        this.nodeConstraints = nodeConstraints;
        this.labelConstraints = labelConstraintsToCreate;
    }

    public void undo() {
        if (this.connections != null) {
            this.model.removeConnections(this.connections);
        }
        if (this.nodes != null) {
            this.model.removeWorkflowNodes(this.nodes);
        }
        if (this.labels != null) {
            for (WorkflowLabel label : this.labels) {
                this.model.removeWorkflowLabel(label);
            }
        }
    }

    public void redo() {
        int positionCounter = 0;
        if (this.nodes != null) {
            ArrayList<WorkflowNode> nodesToAdd = new ArrayList<WorkflowNode>();
            int i = 0;
            while (i < this.nodes.size()) {
                this.nodes.get(i).setLocation(this.nodeConstraints.get((int)positionCounter).getLocation().x, this.nodeConstraints.get((int)positionCounter).getLocation().y);
                ++positionCounter;
                nodesToAdd.add(this.nodes.get(i));
                ++i;
            }
            this.model.addWorkflowNodes(nodesToAdd);
        }
        if (this.connections != null) {
            this.model.addConnections(this.connections);
        }
        positionCounter = 0;
        if (this.labels != null) {
            int i = 0;
            while (i < this.labels.size()) {
                this.labels.get(i).setLocation(this.labelConstraints.get((int)positionCounter).getLocation().x, this.labelConstraints.get((int)positionCounter).getLocation().y);
                Dimension size = new Dimension(121, 61);
                if (this.labelConstraints.get((int)positionCounter).getSize().width != -1 && this.labelConstraints.get((int)positionCounter).getSize().height != -1) {
                    size = new Dimension(this.labelConstraints.get((int)positionCounter).getSize().width, this.labelConstraints.get((int)positionCounter).getSize().height);
                }
                if (size.width == 0) {
                    size.width = 121;
                }
                if (size.height == 0) {
                    size.height = 61;
                }
                this.labels.get(i).setSize(size.width, size.height);
                ++positionCounter;
                this.model.addWorkflowLabel(this.labels.get(i));
                ++i;
            }
        }
        positionCounter = 0;
    }

    public void execute() {
        if (this.nodes != null) {
            for (WorkflowNode node : this.nodes) {
                if (node.getName() != null && !node.getName().isEmpty()) continue;
                node.setName(this.getName(node.getComponentDescription().getName()));
            }
        }
        this.redo();
        String message = "Open Properties view failed";
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.PropertySheet");
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().setFocus();
        }
        catch (PartInitException e) {
            this.log.error((Object)message, (Throwable)e);
        }
        catch (NullPointerException e) {
            this.log.error((Object)message, (Throwable)e);
        }
    }

    private String getName(String name) {
        int count = 0;
        for (WorkflowNode n : this.model.getWorkflowNodes()) {
            if (!n.getName().equals(name)) continue;
            if (name.contains(OPEN_BRACKET)) {
                try {
                    int index = name.lastIndexOf(OPEN_BRACKET) + 1;
                    count = Integer.valueOf(name.substring(index, name.lastIndexOf(CLOSE_BRACKET)));
                }
                catch (NumberFormatException numberFormatException) {
                    count = 0;
                }
                name = name.substring(0, name.lastIndexOf(OPEN_BRACKET));
            }
            if (++count == 1) {
                name = String.valueOf(name) + " ";
            }
            return this.getName(String.valueOf(name) + OPEN_BRACKET + count + CLOSE_BRACKET);
        }
        return name;
    }
}

