/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor;

import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.WorkflowActionBarContributor;
import de.rcenvironment.core.gui.workflow.editor.ShowNumberOfConnectionsAction;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.ui.actions.DeleteRetargetAction;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;

public class WorkflowEditorActionBarContributor
extends WorkflowActionBarContributor {
    private static final String SHOW_NUMBER_OF_CONNECTIONS = "ShowNumberOfConnections";

    @Override
    protected void buildActions() {
        super.buildActions();
        this.addRetargetAction((RetargetAction)new DeleteRetargetAction());
        this.addRetargetAction((RetargetAction)new UndoRetargetAction());
        this.addRetargetAction((RetargetAction)new RedoRetargetAction());
        RetargetAction gridAction = new RetargetAction("org.eclipse.gef.toggle_grid_visibility", "Show grid", 2);
        gridAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.SNAP_TO_GRID));
        this.addRetargetAction(gridAction);
        RetargetAction geometryAction = new RetargetAction("org.eclipse.gef.toggle_snapto_geometry", "Snap to geometry", 2);
        geometryAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.SNAP_TO_GEOMETRY));
        this.addRetargetAction(geometryAction);
        ShowNumberOfConnectionsAction showNumberOfConnectionAction = new ShowNumberOfConnectionsAction(SHOW_NUMBER_OF_CONNECTIONS, "Show number of connections in workflow editor");
        showNumberOfConnectionAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.SHOW_CONNECTION_NUMBERS));
        showNumberOfConnectionAction.setToolTipText("Show number of connections in workflow editor");
        this.addRetargetAction(showNumberOfConnectionAction);
        this.addRetargetAction(new RetargetAction(ActionFactory.SELECT_ALL.getId(), GEFMessages.SelectAllAction_Label));
    }

    @Override
    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add(this.getAction(ActionFactory.UNDO.getId()));
        toolBarManager.add(this.getAction(ActionFactory.REDO.getId()));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.getAction("org.eclipse.gef.toggle_grid_visibility"));
        toolBarManager.add(this.getAction("org.eclipse.gef.toggle_snapto_geometry"));
        toolBarManager.add(this.getAction(SHOW_NUMBER_OF_CONNECTIONS));
        toolBarManager.add((IContributionItem)new Separator());
        super.contributeToToolBar(toolBarManager);
    }

    @Override
    protected void declareGlobalActionKeys() {
        super.declareGlobalActionKeys();
    }
}

