/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.command.spi;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.AbstractCommandParameter;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.ParsedStringParameter;
import java.util.Arrays;
import java.util.Optional;

public class MultiStateParameter
extends AbstractCommandParameter {
    private String[] states;

    public MultiStateParameter(String name, String desc, String ... states) {
        super(name, desc);
        this.states = states;
    }

    public String[] getStates() {
        return this.states;
    }

    public String getFormattedStates() {
        String format = "[" + this.states[0];
        int i = 1;
        while (i < this.states.length) {
            format = String.valueOf(format) + " | " + this.states[i];
            ++i;
        }
        format = String.valueOf(format) + "]";
        return format;
    }

    @Override
    public ParsedStringParameter parseToken(String token, CommandContext context) throws CommandException {
        Optional<String> optional = Arrays.stream(this.states).filter(state -> token.equalsIgnoreCase((String)state)).findAny();
        if (optional.isPresent()) {
            return new ParsedStringParameter(optional.get());
        }
        throw CommandException.syntaxError(String.valueOf(token) + " is not one of the possible states", context);
    }

    @Override
    public ParsedStringParameter standardValue() {
        return new ParsedStringParameter(this.states[0]);
    }
}

