/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.modules.concurrency.internal;

import de.rcenvironment.toolkit.modules.concurrency.api.AsyncExceptionListener;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.CallablesGroup;
import de.rcenvironment.toolkit.modules.concurrency.api.ThreadGuard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CallablesGroupImpl<T>
implements CallablesGroup<T> {
    private static final Log sharedLog = LogFactory.getLog(CallablesGroupImpl.class);
    private List<Callable<T>> tasks = new ArrayList<Callable<T>>();
    private Map<Callable<T>, String> taskIds = new HashMap<Callable<T>, String>();
    private final AsyncTaskService asyncTaskService;

    public CallablesGroupImpl(AsyncTaskService asyncTaskService) {
        this.asyncTaskService = asyncTaskService;
    }

    @Override
    public void add(Callable<T> task) {
        this.tasks.add(task);
    }

    @Override
    public void add(Callable<T> task, String taskId) {
        this.add(task);
        String previousValue = this.taskIds.put(task, taskId);
        if (previousValue != null) {
            sharedLog.warn((Object)("Add the same task instance again, but with a different task id; the new id (" + taskId + ") takes precedence over the old id (" + previousValue + ")"));
        }
    }

    @Override
    public List<T> executeParallel(AsyncExceptionListener exceptionListener) {
        ThreadGuard.checkForForbiddenThread();
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>();
        for (Callable<T> task : this.tasks) {
            futures.add(this.asyncTaskService.submit(task, this.taskIds.get(task)));
        }
        ArrayList results = new ArrayList();
        for (Future future : futures) {
            try {
                results.add(future.get());
            }
            catch (InterruptedException e) {
                results.add(null);
                if (exceptionListener == null) continue;
                exceptionListener.onAsyncException(e);
            }
            catch (ExecutionException e) {
                results.add(null);
                if (exceptionListener == null) continue;
                exceptionListener.onAsyncException(e);
            }
        }
        return results;
    }
}

