/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.resources.internal;

import de.rcenvironment.core.gui.resources.api.ColorManager;
import de.rcenvironment.core.gui.resources.api.ColorSource;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.graphics.Color;

public class ColorManagerImpl
extends ColorManager {
    private final Map<ColorSource, Color> sharedColors = new HashMap<ColorSource, Color>();
    private final Log log = LogFactory.getLog(this.getClass());

    public ColorManagerImpl() {
        this.log.debug((Object)"Color manager initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Color getSharedColor(ColorSource source) {
        Map<ColorSource, Color> map = this.sharedColors;
        synchronized (map) {
            Color color = this.sharedColors.get(source);
            if (color == null) {
                color = source.getColorDescriptor().createColor(null);
                this.sharedColors.put(source, color);
            }
            return color;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Map<ColorSource, Color> map = this.sharedColors;
        synchronized (map) {
            this.log.debug((Object)("Disposing " + this.sharedColors.values().size() + " shared colors"));
            for (Color color : this.sharedColors.values()) {
                color.dispose();
            }
            this.sharedColors.clear();
        }
        this.log.debug((Object)"Color manager disposed");
    }
}

