/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.FunctionFactory;
import org.jpedal.function.PDFFunction;
import org.jpedal.images.ImageOps;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.FunctionObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;

public class ImageCommands {
    public static final int ID = 0;
    public static final int XOBJECT = 2;
    static boolean sharpenDownsampledImages;
    static boolean JAImessageShow;
    public static boolean trackImages;
    public static boolean rejectSuperimposedImages;

    static BufferedImage addMaskObject(GenericColorSpace genericColorSpace, int n, boolean bl, boolean bl2, BufferedImage bufferedImage, int n2, byte[] byArray, PdfObject pdfObject, int n3, PdfObjectReader pdfObjectReader) {
        int[] nArray = pdfObject.getIntArray(489767739);
        if (nArray != null && bufferedImage.getWidth() == 1 && bufferedImage.getHeight() == 1 && nArray[0] == nArray[1]) {
            return null;
        }
        if (nArray != null && nArray.length == 2 && nArray[0] == nArray[1] && nArray[0] > 0 && byArray != null && byArray[nArray[0]] == 0 && genericColorSpace.getIndexedMap().length == 768) {
            nArray = null;
        }
        if (nArray != null) {
            int n4;
            int n5;
            int n6 = genericColorSpace.getColorComponentCount();
            if (byArray != null) {
                int n7 = nArray.length;
                int[] nArray2 = new int[n6 * n7];
                for (n5 = 0; n5 < n7; ++n5) {
                    int n8 = nArray[n5];
                    for (n4 = 0; n4 < n6; ++n4) {
                        nArray2[n4 + n5 * n6] = byArray[n8 * n6 + n4] & 0xFF;
                    }
                }
                nArray = nArray2;
            }
            if (bufferedImage.getType() == 10 && nArray.length == 6 && nArray[0] == nArray[1] && nArray[2] == nArray[3] && nArray[4] == nArray[5]) {
                DataBufferByte dataBufferByte = (DataBufferByte)bufferedImage.getRaster().getDataBuffer();
                byte[] byArray2 = dataBufferByte.getData();
                int n9 = byArray2.length;
                for (n5 = 0; n5 < n9; ++n5) {
                    byArray2[n5] = (byte)(byArray2[n5] ^ 0xFF);
                }
                int[] nArray3 = new int[]{0};
                n4 = bufferedImage.getWidth();
                int n10 = bufferedImage.getHeight();
                WritableRaster writableRaster = Raster.createInterleavedRaster(new DataBufferByte(byArray2, n9), n4, n10, n4, 1, nArray3, null);
                bufferedImage.setData(writableRaster);
            } else {
                bufferedImage = ImageCommands.convertPixelsToTransparent(bufferedImage, nArray);
            }
        } else {
            int n11;
            int n12;
            byte[] byArray3 = pdfObjectReader.readStream(pdfObject, true, true, false, false, false, pdfObject.getCacheName(pdfObjectReader.getObjectReader()));
            int n13 = pdfObject.getInt(959726687);
            int n14 = pdfObject.getInt(959926393);
            float[] fArray = pdfObject.getFloatArray(859785322);
            if (fArray != null && (n2 == 1785221209 || n2 == -2073385820)) {
                ImageCommands.applyDecodeArray(byArray3, fArray.length / 2, fArray, n2);
            }
            if ((n3 & (n12 = 3)) == n12) {
                byte[] byArray4 = ImageOps.rotateImage(byArray3, n13, n14, 1, 1, null);
                if (byArray4 != null && (byArray4 = ImageOps.rotateImage(byArray4, n13 = (n11 = n14), n14 = n13, n, 1, null)) != null) {
                    n11 = n14;
                    n14 = n13;
                    n13 = n11;
                }
                byArray3 = byArray4;
            } else if ((n3 & 1) == 1) {
                byArray3 = ImageOps.invertImage(byArray3, n13, n14, 1, 1, null);
            }
            if ((n3 & 2) == 2) {
                byArray3 = ImageOps.rotateImage(byArray3, n13, n14, 1, 1, null);
            }
            if (byArray3 != null) {
                boolean bl3 = genericColorSpace != null && (genericColorSpace.getID() == 1568372915 || genericColorSpace.getID() == 1008872003) && !bl2;
                int n15 = n11 = genericColorSpace != null && genericColorSpace.getID() == 1785221209 ? 1 : 0;
                if (bl3 && (genericColorSpace.getID() == 1568372915 || genericColorSpace.getID() == 1008872003) || !bl3 && n11 == 0 && bl) {
                    PdfArrayIterator pdfArrayIterator = pdfObject.getMixedArray(1011108731);
                    boolean bl4 = false;
                    if (pdfArrayIterator != null && pdfArrayIterator.hasMoreTokens()) {
                        while (pdfArrayIterator.hasMoreTokens()) {
                            int n16 = pdfArrayIterator.getNextValueAsConstant(true);
                            bl4 = n16 == 2108391315 || n16 == 1247500931;
                        }
                    }
                    if (genericColorSpace.getID() == 1008872003) {
                        boolean bl5 = bl4 = !bl4;
                    }
                    if (!bl4) {
                        bl3 = false;
                    } else if (bl3 && genericColorSpace.getID() == 1568372915) {
                        bl3 = false;
                    }
                    if (fArray != null && genericColorSpace.getID() == 1568372915 && fArray[0] == 1.0f && fArray[1] == 0.0f) {
                        bl3 = !bl3;
                    }
                }
                bufferedImage = ImageCommands.overlayImage(bufferedImage, byArray3, pdfObject, bl3);
            }
        }
        return bufferedImage;
    }

    static BufferedImage makeBlackandWhiteTransparent(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        boolean bl = false;
        int[] nArray = new int[3];
        int[] nArray2 = new int[]{255, 0, 0, 0};
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                boolean bl2;
                writableRaster.getPixels(j, i, 1, 1, nArray);
                boolean bl3 = nArray[0] > 245 && nArray[1] > 245 && nArray[2] > 245;
                boolean bl4 = bl2 = nArray[0] < 10 && nArray[1] < 10 && nArray[2] < 10;
                if (bl3 || bl2) {
                    bufferedImage2.getRaster().setPixels(j, i, 1, 1, nArray2);
                    continue;
                }
                bl = true;
                int[] nArray3 = new int[4];
                nArray3[3] = 255;
                nArray3[0] = nArray[0];
                nArray3[1] = nArray[1];
                nArray3[2] = nArray[2];
                bufferedImage2.getRaster().setPixels(j, i, 1, 1, nArray3);
            }
        }
        if (bl) {
            return bufferedImage2;
        }
        return null;
    }

    private static BufferedImage overlayImage(BufferedImage bufferedImage, byte[] byArray, PdfObject pdfObject, boolean bl) {
        bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = pdfObject.getInt(959726687);
        int n2 = pdfObject.getInt(959926393);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        boolean bl2 = n3 != n || n4 != n2;
        float f = 0.0f;
        if (bl2) {
            float f2 = (float)n3 / (float)n;
            float f3 = (float)n4 / (float)n2;
            f = f2 > f3 ? f2 : f3;
        }
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        int n5 = n;
        if ((n5 & 7) != 0) {
            n5 += 8;
        }
        n5 >>= 3;
        int n6 = 0;
        int[] nArray = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
        for (int i = 0; i < n2; ++i) {
            int n7;
            if (bl2) {
                n7 = (int)(f * (float)i);
                if (n7 > n4) {
                    n7 = n4;
                }
            } else {
                n7 = i;
            }
            for (int j = 0; j < n; ++j) {
                boolean bl3;
                int n8;
                if (bl2) {
                    n8 = (int)(f * (float)j);
                    if (n8 > n3) {
                        n8 = n4;
                    }
                } else {
                    n8 = j;
                }
                int n9 = j >> 3;
                byte by = byArray[n6 + n9];
                if (bl) {
                    bl3 = (by & nArray[j & 7]) == 0;
                } else {
                    boolean bl4 = bl3 = (by & nArray[j & 7]) != 0;
                }
                if (bl3 || n8 >= n3 || n7 >= n4) continue;
                int[] nArray2 = new int[3];
                nArray2 = writableRaster.getPixel(n8, n7, nArray2);
                writableRaster2.setPixel(j, i, new int[]{nArray2[0], nArray2[1], nArray2[2], 255});
            }
            n6 += n5;
        }
        return bufferedImage2;
    }

    private static BufferedImage convertPixelsToTransparent(BufferedImage bufferedImage, int[] nArray) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = writableRaster.getNumBands();
        bufferedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                int[] nArray2 = new int[n];
                writableRaster.getPixel(j, i, nArray2);
                boolean bl = true;
                for (int k = 0; k < n; ++k) {
                    if (nArray[2 * k] <= nArray2[k] && nArray2[k] <= nArray[2 * k + 1]) continue;
                    bl = false;
                    k = n;
                }
                if (bl) continue;
                if (n == 1) {
                    bufferedImage.getRaster().setPixel(j, i, new int[]{nArray2[0], nArray2[0], nArray2[0], 255});
                    continue;
                }
                bufferedImage.getRaster().setPixel(j, i, new int[]{nArray2[0], nArray2[1], nArray2[2], 255});
            }
        }
        return bufferedImage;
    }

    static BufferedImage simulateOP(BufferedImage bufferedImage, boolean bl) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        bufferedImage = ColorSpaceConvertor.convertToARGB(bufferedImage);
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        boolean bl2 = false;
        int[] nArray = new int[]{255, 0, 0, 0};
        int[] nArray2 = new int[4];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                boolean bl3;
                writableRaster.getPixel(j, i, nArray2);
                if (bl) {
                    bl3 = nArray2[0] > 243 && nArray2[1] > 243 && nArray2[2] > 243;
                } else {
                    boolean bl4 = bl3 = nArray2[1] < 3 && nArray2[2] < 3 && nArray2[3] < 3;
                }
                if (bl3) {
                    bufferedImage.getRaster().setPixel(j, i, nArray);
                    continue;
                }
                bl2 = true;
            }
        }
        if (bl2) {
            return bufferedImage;
        }
        return null;
    }

    static void getMaskColor(byte[] byArray, GraphicsState graphicsState) {
        int n = graphicsState.nonstrokeColorSpace.getColor().getRGB();
        byArray[0] = (byte)(n >> 16 & 0xFF);
        byArray[1] = (byte)(n >> 8 & 0xFF);
        byArray[2] = (byte)(n & 0xFF);
    }

    static boolean isRepeatingLine(byte[] byArray, int n) {
        if (byArray.length % n != 0) {
            return false;
        }
        int n2 = byArray.length / n;
        for (int i = 0; i < byArray.length / n - 1; ++i) {
            for (int j = n2; j < byArray.length - 1; j += n2) {
                if (byArray[i] == byArray[j]) continue;
                return false;
            }
        }
        return true;
    }

    public static BufferedImage applySmask(BufferedImage bufferedImage, BufferedImage bufferedImage2, PdfObject pdfObject, boolean bl, boolean bl2, PdfObject pdfObject2) {
        Object object;
        int n = bufferedImage.getType();
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        int[] nArray3 = new int[]{0, 0, 0, 0};
        PdfArrayIterator pdfArrayIterator = pdfObject.getMixedArray(1011108731);
        boolean bl3 = false;
        if (pdfArrayIterator != null && pdfArrayIterator.hasMoreTokens()) {
            while (pdfArrayIterator.hasMoreTokens()) {
                int n2 = pdfArrayIterator.getNextValueAsConstant(true);
                bl3 = n2 == 1180911742;
            }
        }
        boolean bl4 = pdfObject2 != null && pdfObject2.getParameterConstant(2087749783) == 1568372915;
        boolean bl5 = bl3 && bl4;
        int n3 = -1;
        if (pdfObject2 != null) {
            n3 = pdfObject2.getParameterConstant(2087749783);
        }
        boolean bl6 = bl5 = !bl5 && bl && pdfObject2 != null && (n3 == 1498837125 || n3 == 1247168582);
        if (bl5) {
            bufferedImage2 = ColorSpaceConvertor.convertColorspace(bufferedImage2, 10);
            nArray2 = nArray;
        }
        WritableRaster writableRaster = bufferedImage2.getRaster();
        WritableRaster writableRaster2 = null;
        boolean bl7 = false;
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        int n6 = bufferedImage2.getWidth();
        int n7 = bufferedImage2.getHeight();
        float f = 0.0f;
        float f2 = 0.0f;
        if (n4 != n6 || n5 != n7) {
            f = (float)n4 / (float)n6;
            f2 = (float)n5 / (float)n7;
            if (bl2 && (double)f == 0.5 && (double)f2 == 0.5) {
                BufferedImage bufferedImage3 = new BufferedImage(n6, n7, bufferedImage.getType());
                object = bufferedImage3.createGraphics();
                ((Graphics)object).dispose();
                ((Graphics2D)object).setComposite(AlphaComposite.Src);
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                ((Graphics)object).drawImage(bufferedImage, 0, 0, n6, n7, null);
                bufferedImage = bufferedImage3;
                n4 = n6;
                n5 = n7;
                f = 1.0f;
                f2 = 1.0f;
            }
        }
        int n8 = bufferedImage2.getColorModel().getNumComponents();
        object = new int[n8];
        int[] nArray4 = new int[4];
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                if (f == 0.0f) {
                    writableRaster.getPixels(j, i, 1, 1, (int[])object);
                } else {
                    writableRaster.getPixels((int)((float)j / f), (int)((float)i / f2), 1, 1, (int[])object);
                }
                boolean bl8 = false;
                if (n8 == 1) {
                    if (object[0] > 127 && bl3) {
                        bl8 = true;
                    }
                } else {
                    for (int k = 0; k < n8; ++k) {
                        if (object[k] == nArray2[k]) continue;
                        k = n8;
                        bl8 = true;
                    }
                }
                if (bl8) continue;
                if (!bl7) {
                    bufferedImage = ColorSpaceConvertor.convertToARGB(bufferedImage);
                    writableRaster2 = bufferedImage.getRaster();
                    bl7 = true;
                }
                if (n8 == 1) {
                    writableRaster2.getPixels(j, i, 1, 1, nArray4);
                    if (object[0] == nArray4[0]) {
                        if (nArray4[0] == 255 && (n == 1 || n == 5) && bl4) {
                            writableRaster2.setPixels(j, i, 1, 1, new int[]{nArray4[0], nArray4[1], nArray4[2], (int)object[0]});
                            continue;
                        }
                        writableRaster2.setPixels(j, i, 1, 1, nArray3);
                        continue;
                    }
                    writableRaster2.setPixels(j, i, 1, 1, new int[]{nArray4[0], nArray4[1], nArray4[2], (int)object[0]});
                    continue;
                }
                writableRaster2.setPixels(j, i, 1, 1, nArray3);
            }
        }
        return bufferedImage;
    }

    static BufferedImage simulateOverprint(GenericColorSpace genericColorSpace, byte[] byArray, boolean bl, boolean bl2, BufferedImage bufferedImage, int n, PdfObject pdfObject, PdfObject pdfObject2, DynamicVectorRenderer dynamicVectorRenderer, GraphicsState graphicsState) {
        if ((n == 1498837125 || n == 1247168582) && graphicsState.getOPM() == 1.0f) {
            boolean bl3 = dynamicVectorRenderer.hasObjectsBehind(graphicsState.CTM);
            boolean bl4 = false;
            byte[] byArray2 = genericColorSpace.getIndexedMap();
            if (bl3 && byArray2 == null) {
                bl4 = true;
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] == 0) continue;
                    i = byArray.length;
                    bl4 = false;
                }
            }
            if (bl4) {
                bufferedImage.flush();
                bufferedImage = null;
            } else if ((bl || bl2) && graphicsState.getNonStrokeOP()) {
                bufferedImage = ImageCommands.simulateOP(bufferedImage, bl2);
            } else if (bl && pdfObject2 == null && pdfObject == null && genericColorSpace.isImageYCCK() && genericColorSpace.getIntent() != null && genericColorSpace.getIntent().equals("RelativeColorimetric")) {
                bufferedImage = ImageCommands.simulateOP(bufferedImage, true);
            } else if (graphicsState.getNonStrokeOP()) {
                bufferedImage = n == 1498837125 ? ImageCommands.simulateOP(bufferedImage, false) : ImageCommands.simulateOP(bufferedImage, bufferedImage.getType() == 1);
            }
        }
        return bufferedImage;
    }

    static BufferedImage addBackgroundToMask(BufferedImage bufferedImage, boolean bl) {
        if (bl) {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            BufferedImage bufferedImage2 = new BufferedImage(n, n2, 1);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            bufferedImage = bufferedImage2;
        }
        return bufferedImage;
    }

    static BufferedImage applyTR(BufferedImage bufferedImage, PdfObject pdfObject, PdfObjectReader pdfObjectReader) {
        Object object;
        PDFFunction[] pDFFunctionArray = new PDFFunction[4];
        int n = 0;
        byte[][] byArray = pdfObject.getKeyArray(9250);
        if (byArray != null) {
            n = byArray.length;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == null) continue;
            object = new String(byArray[i]);
            FunctionObject functionObject = new FunctionObject((String)object);
            byte[] byArray2 = byArray[i];
            if (byArray2 != null && byArray2.length > 4 && byArray2[0] == 47 && byArray2[1] == 73 && byArray2[2] == 100 && byArray2[3] == 101) {
                functionObject = null;
            } else {
                pdfObjectReader.readObject(functionObject);
            }
            if (functionObject == null) continue;
            pDFFunctionArray[i] = FunctionFactory.getFunction(functionObject, pdfObjectReader);
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        object = new int[4];
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                writableRaster.getPixels(j, i, 1, 1, (int[])object);
                for (int k = 0; k < 3; ++k) {
                    float[] fArray = new float[]{(float)object[k] / 255.0f};
                    if (pDFFunctionArray[k] == null) continue;
                    float[] fArray2 = pDFFunctionArray[k].compute(fArray);
                    object[k] = (int)(255.0f * fArray2[0]);
                }
                bufferedImage.getRaster().setPixels(j, i, 1, 1, (int[])object);
            }
        }
        return bufferedImage;
    }

    static void applyDecodeArray(byte[] byArray, int n, float[] fArray, int n2) {
        int n3;
        int n4;
        int n5 = fArray.length;
        int n6 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            if (!((float)n6 < fArray[n4])) continue;
            n6 = (int)fArray[n4];
        }
        n4 = 1;
        int n7 = fArray.length;
        for (n3 = 0; n3 < n7; n3 += 2) {
            if (fArray[n3] == 0.0f && (fArray[n3 + 1] == 1.0f || fArray[n3 + 1] == 255.0f)) continue;
            n4 = 0;
            n3 = n7;
        }
        if (n4 != 0) {
            return;
        }
        if (n == 1) {
            n3 = byArray.length;
            for (int i = 0; i < n3; ++i) {
                byArray[i] = ~byArray[i];
            }
        } else if (n == 8 && n6 > 1 && (n2 == 1785221209 || n2 == 1008872003 || n2 == 1498837125)) {
            n3 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                int n8 = byArray[i] & 0xFF;
                if ((float)n8 < fArray[n3]) {
                    n8 = (int)fArray[n3];
                } else if ((float)n8 > fArray[n3 + 1]) {
                    n8 = (int)fArray[n3 + 1];
                }
                if ((n3 += 2) == fArray.length) {
                    n3 = 0;
                }
                byArray[i] = (byte)n8;
            }
        } else {
            n6 = n << 1;
            n3 = n6 - 1;
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 1;
                for (int j = 7; j > -1; --j) {
                    int n13 = by >> j & 1;
                    if ((n13 = (int)(fArray[n11] + (float)n13 * ((fArray[n12] - fArray[n11]) / (float)n3))) > n6) {
                        n13 = n6;
                    }
                    if (n13 < 0) {
                        n13 = 0;
                    }
                    n13 = (n13 & 1) << j;
                    n10 += n13;
                    if ((n9 += 2) == n5) {
                        n9 = 0;
                        n11 = 0;
                        n12 = 1;
                        continue;
                    }
                    n11 += 2;
                    n12 += 2;
                }
                byArray[i] = (byte)n10;
            }
        }
    }

    static boolean isExtractionAllowed(PdfObjectReader pdfObjectReader) {
        PdfFileReader pdfFileReader = pdfObjectReader.getObjectReader();
        DecryptionFactory decryptionFactory = pdfFileReader.getDecryptionObject();
        return decryptionFactory == null || decryptionFactory.getBooleanValue(103);
    }

    static {
        String string;
        String string2;
        sharpenDownsampledImages = false;
        JAImessageShow = false;
        trackImages = false;
        rejectSuperimposedImages = true;
        String string3 = System.getProperty("org.jpedal.rejectsuperimposedimages");
        if (string3 != null) {
            boolean bl = rejectSuperimposedImages = string3 != null && string3.toLowerCase().indexOf("true") != -1;
        }
        if ((string2 = System.getProperty("org.jpedal.trackImages")) != null) {
            boolean bl = trackImages = string2 != null && string2.toLowerCase().indexOf("true") != -1;
        }
        if ((string = System.getProperty("org.jpedal.sharpendownsampledimages")) != null) {
            sharpenDownsampledImages = string.toLowerCase().indexOf("true") != -1;
        }
    }
}

