/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jpedal.PdfDecoder;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.Messages;

public class JAIHelper {
    private static boolean JAI_TESTED;
    private static boolean useJAI;
    private static boolean isJAIFound;

    public static void confirmJAIOnClasspath() {
        block5: {
            if (JAI_TESTED) {
                return;
            }
            JAI_TESTED = true;
            if (useJAI) {
                try {
                    Class.forName("javax.media.jai.JAI");
                    isJAIFound = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!PdfDecoder.showErrorMessages) break block5;
                    String string = Messages.getMessage("PdfViewer.JAINotOnClasspathWarning") + Messages.getMessage("PdfViewer.JAINotOnClasspathWarning1") + Messages.getMessage("PdfViewer.JAINotOnClasspathWarning2");
                    if (string.indexOf("PdfViewer") != -1) {
                        string = "We recommend you add JAI to classpath";
                    }
                    JEditorPane jEditorPane = new JEditorPane("text/html", string);
                    jEditorPane.setEditable(false);
                    jEditorPane.setOpaque(false);
                    jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                            block3: {
                                if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                                    try {
                                        BrowserLauncher.openURL("http://java.sun.com/products/java-media/jai/current.html");
                                    }
                                    catch (IOException iOException) {
                                        if (!PdfDecoder.showErrorMessages) break block3;
                                        JOptionPane.showMessageDialog(null, Messages.getMessage("PdfViewer.ErrorWebsite"));
                                    }
                                }
                            }
                        }
                    });
                    if (!PdfDecoder.showErrorMessages) break block5;
                    JOptionPane.showMessageDialog(null, jEditorPane);
                }
            }
        }
    }

    public static boolean isJAIused() {
        return useJAI;
    }

    public static boolean isJAIOnClasspath() {
        String string;
        if (!isJAIFound && (string = System.getProperty("java.class.path")).indexOf("jai") != -1) {
            isJAIFound = true;
        }
        return isJAIFound;
    }

    public static void useJAI(boolean bl) {
        useJAI = bl;
        JAI_TESTED = false;
    }

    static {
        useJAI = false;
        isJAIFound = false;
        String string = System.getProperty("org.jpedal.jai");
        if (string != null && string.toLowerCase().equals("true")) {
            useJAI = true;
        }
    }
}

