/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.PdfReader;

public class FileAccess {
    Certificate certificate;
    PrivateKey key;

    public boolean isFileViewable(PdfObjectReader pdfObjectReader) {
        if (pdfObjectReader != null) {
            PdfFileReader pdfFileReader = pdfObjectReader.getObjectReader();
            DecryptionFactory decryptionFactory = pdfFileReader.getDecryptionObject();
            return decryptionFactory == null || decryptionFactory.getBooleanValue(100) || this.certificate != null;
        }
        return false;
    }

    public boolean isPasswordSupplied(PdfObjectReader pdfObjectReader) {
        if (pdfObjectReader != null) {
            PdfFileReader pdfFileReader = pdfObjectReader.getObjectReader();
            DecryptionFactory decryptionFactory = pdfFileReader.getDecryptionObject();
            return decryptionFactory != null && (decryptionFactory.getBooleanValue(104) || this.certificate != null);
        }
        return false;
    }

    public void setUserEncryption(Certificate certificate, PrivateKey privateKey) {
        this.certificate = certificate;
        this.key = privateKey;
    }

    public PdfObjectReader getNewReader() {
        PdfReader pdfReader = this.certificate != null ? new PdfReader(this.certificate, this.key) : new PdfReader();
        return pdfReader;
    }
}

