/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.spi;

import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.api.LoopComponentConstants;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.execution.api.ComponentLog;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointCharacter;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.NotAValueTD;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractLoopComponent
extends DefaultComponent {
    private static final String FAIL_WORKFLOW_MESSAGE = "-> fail workflow (as defined by behavior declaration in configuration tab 'Fault Tolerance')";
    private static final String RECEIVED_NAV_VALUES = "Received value(s) of type 'Not a value' (explicitly sent by a component in the loop) ";
    private static final String COMPONENT_FAILED = "A component in the loop failed ";
    protected ComponentContext componentContext;
    protected ComponentLog componentLog;
    protected TypedDatumFactory typedDatumFactory;
    protected LoopComponentConstants.LoopBehaviorInCaseOfFailure loopBehaviorInCaseOfNAV;
    protected ComponentException compExceptionToThrow = null;
    protected boolean loopFailed = false;
    private boolean anyRunFailedNAV = false;
    private int maximumReruns;
    private int rerunCount = 0;
    private Map<String, TypedDatum> outputValuesSentInLastLoop = new HashMap<String, TypedDatum>();

    @Override
    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
        this.componentLog = componentContext.getLog();
    }

    @Override
    public void start() throws ComponentException {
        this.typedDatumFactory = this.componentContext.getService(TypedDatumService.class).getFactory();
        this.loopBehaviorInCaseOfNAV = LoopComponentConstants.LoopBehaviorInCaseOfFailure.fromString(this.componentContext.getConfigurationValue("faultTolerance-NAV_5e0ed1cd"));
        switch (this.loopBehaviorInCaseOfNAV) {
            case RerunAndFail: {
                this.maximumReruns = this.getRerunCount("maxRerunBeforeFail-NAV_5e0ed1cd");
                break;
            }
            case RerunAndDiscard: {
                this.maximumReruns = this.getRerunCount("maxRerunBeforeDiscard-NAV_5e0ed1cd");
                break;
            }
        }
        this.startComponentSpecific();
        if (this.treatStartAsComponentRun()) {
            this.sendLoopDoneValuesIfDone();
        }
    }

    private int getRerunCount(String configKey) throws ComponentException {
        String rerunConfigValue = this.componentContext.getConfigurationValue(configKey);
        try {
            return Integer.valueOf(rerunConfigValue);
        }
        catch (NumberFormatException numberFormatException) {
            if (rerunConfigValue == null || rerunConfigValue.isEmpty()) {
                throw new ComponentException("No number of reruns given");
            }
            throw new ComponentException(StringUtils.format((String)"Given number of reruns is invalid: %s", (Object[])new Object[]{rerunConfigValue}));
        }
    }

    @Override
    public void processInputs() throws ComponentException {
        if (this.hasNaVInputValues(this.componentContext.getInputsWithDatum())) {
            boolean failureCausedByCompFailure = this.hasNaVInputValuesCausedByComponentFailure(this.componentContext.getInputsWithDatum());
            if (!failureCausedByCompFailure) {
                this.anyRunFailedNAV = true;
            }
            if (this.handleFaultTolerance(failureCausedByCompFailure)) {
                return;
            }
        }
        this.outputValuesSentInLastLoop.clear();
        this.rerunCount = 0;
        this.processInputsComponentSpecific();
        if (!this.isReset()) {
            this.sendLoopDoneValuesIfDone();
            if (this.isFinallyDone()) {
                this.componentContext.closeAllOutputs();
            } else {
                this.forwardValues();
            }
        }
    }

    protected void writeOutput(String outputName, TypedDatum value) {
        if (this.componentContext.getOutputCharacter(outputName).equals((Object)EndpointCharacter.SAME_LOOP)) {
            this.outputValuesSentInLastLoop.put(outputName, value);
        }
        this.componentContext.writeOutput(outputName, value);
    }

    protected boolean hasNaVInputValues(Set<String> inputsWithDatum) {
        return this.hasNaVInputValues(inputsWithDatum, false);
    }

    protected boolean hasNaVInputValuesCausedByComponentFailure(Set<String> inputsWithDatum) {
        return this.hasNaVInputValues(inputsWithDatum, true);
    }

    protected boolean hasNaVInputValues(Set<String> inputsWithDatum, boolean causedByCompFailureOnly) {
        for (String inputName : inputsWithDatum) {
            TypedDatum typedDatum;
            if (!this.componentContext.getInputCharacter(inputName).equals((Object)EndpointCharacter.SAME_LOOP) || !(typedDatum = this.componentContext.readInput(inputName)).getDataType().equals((Object)DataType.NotAValue)) continue;
            if (!causedByCompFailureOnly) {
                return true;
            }
            if (!((NotAValueTD)typedDatum).getCause().equals((Object)NotAValueTD.Cause.Failure)) continue;
            return true;
        }
        return false;
    }

    private boolean handleFaultTolerance(boolean failureCausedByCompFailure) throws ComponentException {
        boolean handled = false;
        if (failureCausedByCompFailure) {
            handled = this.discardLoopRun();
        } else {
            switch (this.loopBehaviorInCaseOfNAV) {
                case Fail: {
                    handled = this.handleFailure(new ComponentException(String.valueOf(this.getErrorMessage(failureCausedByCompFailure)) + FAIL_WORKFLOW_MESSAGE));
                    break;
                }
                case Discard: {
                    handled = this.discardLoopRun();
                    break;
                }
                case RerunAndFail: {
                    handled = this.rerunOrFailLoopRun();
                    break;
                }
                case RerunAndDiscard: {
                    handled = this.rerunOrDiscardLoopRun(handled);
                    break;
                }
            }
        }
        return handled;
    }

    private boolean discardLoopRun() throws ComponentException {
        boolean handled;
        String inputName = this.guardAgainstNaVValueAtForwardingInputs(this.componentContext.getInputsWithDatum());
        if (inputName != null) {
            NotAValueTD readInput = (NotAValueTD)this.componentContext.readInput(inputName);
            switch (readInput.getCause()) {
                case InvalidInputs: {
                    handled = this.handleFailure(new ComponentException(StringUtils.format((String)"Received value of type 'Not a value' at input '%s' that is not allowed to be forwarded; most likely reason: sent by a component of a fault-tolerant loop", (Object[])new Object[]{inputName})));
                    break;
                }
                default: {
                    handled = this.handleFailure(new ComponentException(StringUtils.format((String)"Failure in fault-tolerant loop but loop run cannot be discarded as no reasonable value to forward exists for '%s' now", (Object[])new Object[]{inputName})));
                    break;
                }
            }
        } else {
            this.componentLog.componentInfo("Received value(s) of type 'Not a value' (explicitly sent by a component in the loop) -> discard evaluation loop run (as defined by behavior declaration in configuration tab 'Fault Tolerance')");
            handled = false;
        }
        return handled;
    }

    private boolean rerunOrFailLoopRun() throws ComponentException {
        boolean handled;
        if (this.rerunCount >= this.maximumReruns) {
            handled = this.handleFailure(new ComponentException(StringUtils.format((String)"Received value(s) of type 'Not a value' (explicitly sent by a component in the loop)  and maximum number of reruns execeeded (%d) -> fail workflow (as defined by behavior declaration in configuration tab 'Fault Tolerance')", (Object[])new Object[]{this.maximumReruns})));
        } else {
            this.rerunLoop();
            handled = true;
        }
        return handled;
    }

    private boolean rerunOrDiscardLoopRun(boolean handled) throws ComponentException {
        if (this.rerunCount >= this.maximumReruns) {
            String inputName2 = this.guardAgainstNaVValueAtForwardingInputs(this.componentContext.getInputsWithDatum());
            if (inputName2 != null) {
                handled = this.handleFailure(new ComponentException(StringUtils.format((String)"Received value of type 'Not a value' at input '%s' that is not allowed to be forwarded; most likely reason: failure in a fault-tolerant loop so that no reasonable value to forward was provided", (Object[])new Object[]{inputName2})));
            }
        } else {
            this.rerunLoop();
            handled = true;
        }
        return handled;
    }

    private String getErrorMessage(boolean failureCausedByComponentCrash) {
        if (failureCausedByComponentCrash) {
            return COMPONENT_FAILED;
        }
        return RECEIVED_NAV_VALUES;
    }

    private boolean handleFailure(ComponentException e) throws ComponentException {
        if (!this.isNestedLoop()) {
            throw e;
        }
        this.loopFailed = true;
        this.compExceptionToThrow = e;
        return false;
    }

    private boolean isFailLoopOnly() {
        return Boolean.valueOf(this.componentContext.getConfigurationValue("failLoopOnly-NAV_5e0ed1cd"));
    }

    private boolean isFinallyFail() {
        return Boolean.valueOf(this.componentContext.getConfigurationValue("finallyFailIfDiscarded-NAV_5e0ed1cd"));
    }

    protected boolean isNestedLoop() {
        return Boolean.valueOf(this.componentContext.getConfigurationValue("isNestedLoop_5e0ed1cd"));
    }

    private void rerunLoop() {
        ++this.rerunCount;
        this.componentLog.componentInfo(StringUtils.format((String)"Received value(s) of type 'Not a value' (explicitly sent by a component in the loop) -> re-run evaluation loop (rerun count: %d) (as defined by behavior declaration in configuration tab 'Fault Tolerance')", (Object[])new Object[]{this.rerunCount}));
        for (String outputName : this.outputValuesSentInLastLoop.keySet()) {
            this.componentContext.writeOutput(outputName, this.outputValuesSentInLastLoop.get(outputName));
        }
    }

    private String guardAgainstNaVValueAtForwardingInputs(Set<String> inputsWithDatum) throws ComponentException {
        for (String inputName : inputsWithDatum) {
            TypedDatum typedDatum;
            if (!this.componentContext.getDynamicInputIdentifier(inputName).equals("toForward") || !(typedDatum = this.componentContext.readInput(inputName)).getDataType().equals((Object)DataType.NotAValue)) continue;
            return inputName;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void reset() throws ComponentException {
        if (this.loopFailed) {
            this.resetComponentSpecific();
            this.loopFailed = false;
            ComponentException tempE = this.compExceptionToThrow;
            this.compExceptionToThrow = null;
            boolean failureCausedByCompFailure = this.hasNaVInputValuesCausedByComponentFailure(this.componentContext.getInputsWithDatum());
            if (!this.isFailLoopOnly() || failureCausedByCompFailure) throw tempE;
            this.componentLog.componentInfo(String.valueOf(tempE.getMessage()) + "-> forward to outer loop (as defined by behavior declaration in configuration tab 'Fault Tolerance')");
            this.writeNAVValueToOuterLoop();
            return;
        } else {
            this.finishLoopComponentSpecific(false);
            this.sendLoopDoneValue(true);
            this.resetComponentSpecific();
        }
    }

    private void writeNAVValueToOuterLoop() {
        for (String outputName : this.getOuterLoopOutputs()) {
            this.componentContext.writeOutput(outputName, (TypedDatum)this.typedDatumFactory.createNotAValue(NotAValueTD.Cause.InvalidInputs));
        }
    }

    private Set<String> getOuterLoopOutputs() {
        HashSet<String> outerLoopOutputs = new HashSet<String>();
        for (String outputName : this.componentContext.getOutputs()) {
            if (!this.componentContext.getOutputCharacter(outputName).equals((Object)EndpointCharacter.OUTER_LOOP)) continue;
            outerLoopOutputs.add(outputName);
        }
        return outerLoopOutputs;
    }

    protected void addOutputValueSentInSelfLoop(String outputName, TypedDatum value) {
        this.outputValuesSentInLastLoop.put(outputName, value);
    }

    protected boolean hasForwardingStartInputs() {
        Set<String> inputs = this.componentContext.getInputs();
        for (String input : inputs) {
            if (!this.componentContext.isDynamicInput(input) || !this.componentContext.getDynamicInputIdentifier(input).equals("startToForward")) continue;
            return true;
        }
        return false;
    }

    private void forwardValues() {
        Set<String> inputs = this.componentContext.getInputsWithDatum();
        for (String input : inputs) {
            if (this.componentContext.isStaticInput(input) || !this.componentContext.getDynamicInputIdentifier(input).equals("toForward") && !this.componentContext.getDynamicInputIdentifier(input).equals("startToForward")) continue;
            String output = input.endsWith("_start") ? input.substring(0, input.indexOf("_start")) : input;
            this.writeOutput(output, this.componentContext.readInput(input));
        }
    }

    private void sendLoopDoneValuesIfDone() throws ComponentException {
        if ((this.isDone() || this.isFinallyDone()) && this.anyRunFailedNAV && this.isFinallyFail()) {
            throw new ComponentException("Evaluation loop terminated and at least one evaluation loop run was discarded - fail (as defined by behavior declaration in configuration tab 'Fault Tolerance')");
        }
        if (this.isDone()) {
            this.sendLoopDoneValue(true);
        }
    }

    private void sendLoopDoneValue(boolean done) {
        this.componentContext.writeOutput("Done", (TypedDatum)this.typedDatumFactory.createBoolean(done));
    }

    protected boolean isReset() {
        return false;
    }

    protected abstract void finishLoopComponentSpecific(boolean var1) throws ComponentException;

    protected void resetComponentSpecific() throws ComponentException {
    }

    protected abstract void processInputsComponentSpecific() throws ComponentException;

    protected abstract void startComponentSpecific() throws ComponentException;

    protected abstract boolean isFinallyDone();

    protected abstract boolean isDone();
}

