/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.impl;

import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.impl.ComponentImageCacheService;
import de.rcenvironment.core.component.model.impl.ComponentImageManagerImpl;
import de.rcenvironment.core.component.model.impl.ComponentImageUtility;
import de.rcenvironment.core.component.spi.DistributedComponentKnowledgeListener;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.utils.common.service.AdditionalServiceDeclaration;
import de.rcenvironment.core.utils.common.service.AdditionalServicesProvider;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ComponentImageCacheImpl
implements ComponentImageCacheService,
AdditionalServicesProvider {
    private static final String CACHE_DIRECTORY = "componentIconCache";
    private static final String INDEX = "queue";
    private static final String MAPPING = "mapping";
    private static final int CACHE_SIZE = 512;
    private static final String NULL_HASH = "d41d8cd98f00b204e9800998ecf8427e";
    private Map<String, String> idIconMap;
    private List<String> hashesToRemove;
    private LinkedList<String> iconHashes = new LinkedList();
    private ConfigurationService configService;
    private DistributedComponentKnowledgeService knowledgService;
    private Path indexFile;
    private Path mappingFile;

    public ComponentImageCacheImpl() {
        this.hashesToRemove = new ArrayList<String>();
        this.idIconMap = new HashMap<String, String>();
    }

    @Activate
    private void activate() {
        this.readCache();
        this.addUnknownComponentsToCache(this.knowledgService.getCurrentSnapshot());
    }

    private synchronized void putInCache(String iconHash, String componentId, byte[] icon16, byte[] icon24, byte[] icon32) {
        if (!NULL_HASH.equals(iconHash)) {
            componentId = ComponentImageUtility.getNormalId(componentId);
            this.idIconMap.put(componentId, iconHash);
            if (!this.iconHashes.contains(iconHash)) {
                this.createRawDataFile(iconHash, icon16, icon24, icon32);
                this.moveItemToTopinQueue(iconHash);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getImageData(String iconHash, ComponentImageManagerImpl.IconSize size) {
        if (this.idIconMap.containsValue(iconHash)) {
            Path rawDataPath = Paths.get(this.indexFile.getParent().toString(), iconHash);
            try {
                byte[] toReturn;
                List<String> rawDataList;
                ComponentImageCacheImpl componentImageCacheImpl = this;
                synchronized (componentImageCacheImpl) {
                    rawDataList = Files.readAllLines(rawDataPath, StandardCharsets.UTF_8);
                }
                switch (size) {
                    case ICON16: {
                        toReturn = Base64.getDecoder().decode(rawDataList.get(0));
                        break;
                    }
                    case ICON24: {
                        toReturn = Base64.getDecoder().decode(rawDataList.get(1));
                        break;
                    }
                    case ICON32: {
                        toReturn = Base64.getDecoder().decode(rawDataList.get(2));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Requested icon size is not defined inside this switch case");
                    }
                }
                componentImageCacheImpl = this;
                synchronized (componentImageCacheImpl) {
                    this.moveItemToTopinQueue(iconHash);
                    this.syncFilesWithQueue();
                }
                return toReturn;
            }
            catch (IOException e) {
                LogFactory.getLog(this.getClass()).error((Object)("Could not read raw data file of the ComponentImageCache for hash " + iconHash), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private void readCache() {
        this.setMainCacheFiles();
        this.readIndex();
        this.readMappingFile();
    }

    private synchronized void moveItemToTopinQueue(String iconhash) {
        if (this.iconHashes.contains(iconhash)) {
            this.iconHashes.remove(iconhash);
        }
        this.iconHashes.addFirst(iconhash);
        if (this.iconHashes.size() > 512) {
            this.hashesToRemove.add(this.iconHashes.removeLast());
        }
    }

    private synchronized void syncFilesWithQueue() {
        for (String entry : this.iconHashes) {
            this.hashesToRemove.remove(entry);
        }
        for (String entry : this.hashesToRemove) {
            try {
                Path pathToDelete = Paths.get(this.indexFile.getParent().toString(), entry);
                if (pathToDelete.toFile().exists()) {
                    Files.delete(pathToDelete);
                }
            }
            catch (IOException e) {
                LogFactory.getLog(this.getClass()).error((Object)("Could not delete raw data file of the ComponentImageCache with icon hash: " + entry), (Throwable)e);
            }
            if (!this.idIconMap.containsValue(entry)) continue;
            Iterator<Map.Entry<String, String>> iterator = this.idIconMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> tmpEntry = iterator.next();
                if (!tmpEntry.getValue().equals(entry)) continue;
                iterator.remove();
            }
        }
        this.hashesToRemove.clear();
        try {
            Files.write(this.indexFile, this.iconHashes, StandardOpenOption.WRITE);
            this.writeMappingFile();
        }
        catch (IOException e) {
            LogFactory.getLog(this.getClass()).error((Object)"Could not write index file of the ComponentImageCache", (Throwable)e);
        }
    }

    private synchronized void createRawDataFile(String iconhash, byte[] icon16, byte[] icon24, byte[] icon32) {
        Path rawDataPath = Paths.get(this.indexFile.getParent().toString(), iconhash);
        if (!rawDataPath.toFile().exists()) {
            try {
                rawDataPath.toFile().createNewFile();
            }
            catch (IOException e) {
                LogFactory.getLog(this.getClass()).error((Object)("Could not create raw data file to cache for icon hash: " + iconhash), (Throwable)e);
            }
            try {
                LinkedList<String> byteList = new LinkedList<String>();
                if (icon16 == null) {
                    icon16 = new byte[]{};
                }
                byteList.add(Base64.getEncoder().encodeToString(icon16));
                if (icon24 == null) {
                    icon24 = new byte[]{};
                }
                byteList.add(Base64.getEncoder().encodeToString(icon24));
                if (icon32 == null) {
                    icon32 = new byte[]{};
                }
                byteList.add(Base64.getEncoder().encodeToString(icon32));
                Files.write(rawDataPath, byteList, StandardOpenOption.WRITE);
            }
            catch (IOException e) {
                LogFactory.getLog(this.getClass()).error((Object)("Could not write to raw data file to cache for icon hash: " + iconhash), (Throwable)e);
            }
        }
    }

    @Reference
    private void bindConfigurationService(ConfigurationService configurationService) {
        this.configService = configurationService;
    }

    @Reference
    private void bindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService knowledgeService) {
        this.knowledgService = knowledgeService;
    }

    private void setMainCacheFiles() {
        if (this.configService != null) {
            Path cachePath = Paths.get(this.configService.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_INTERNAL_DATA).toString(), CACHE_DIRECTORY);
            if (!cachePath.toFile().exists()) {
                cachePath.toFile().mkdir();
            }
            this.indexFile = Paths.get(cachePath.toString(), INDEX);
            this.mappingFile = Paths.get(cachePath.toString(), MAPPING);
            ArrayList<Path> pathList = new ArrayList<Path>();
            pathList.add(this.indexFile);
            pathList.add(this.mappingFile);
            for (Path entry : pathList) {
                if (entry.toFile().exists()) continue;
                try {
                    entry.toFile().createNewFile();
                }
                catch (IOException e) {
                    LogFactory.getLog(this.getClass()).error((Object)("Could not create " + entry.toString() + " file of component image cache."), (Throwable)e);
                }
            }
        } else {
            LogFactory.getLog(this.getClass()).debug((Object)"Could not set files of component image cache because ConfigurationService was not available.");
        }
    }

    private void readIndex() {
        if (this.indexFile != null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (Stream<String> stream = Files.lines(this.indexFile, StandardCharsets.UTF_8);){
                    stream.forEach(s -> {
                        boolean bl = this.iconHashes.add((String)s);
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LogFactory.getLog(this.getClass()).error((Object)"Could not read index file of the ComponentImageCache", (Throwable)e);
            }
        }
    }

    private void writeMappingFile() {
        ArrayList<String> linesToWrite = new ArrayList<String>();
        String divider = ":";
        for (Map.Entry<String, String> entry : this.idIconMap.entrySet()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(entry.getKey());
            stringBuilder.append(divider);
            stringBuilder.append(entry.getValue());
            linesToWrite.add(stringBuilder.toString());
        }
        try {
            Files.write(this.mappingFile, linesToWrite, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            LogFactory.getLog(this.getClass()).error((Object)"Could not create to mapping file of component image cache.", (Throwable)e);
        }
    }

    private void readMappingFile() {
        ArrayList mappingList = new ArrayList();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<String> stream = Files.lines(this.mappingFile, StandardCharsets.UTF_8);){
                stream.forEach(mappingList::add);
                for (String entry : mappingList) {
                    String[] stringParts = entry.split(":");
                    this.idIconMap.put(stringParts[0], stringParts[1]);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LogFactory.getLog(this.getClass()).error((Object)"Could not read mapping file of the ComponentImageCache", (Throwable)e);
        }
    }

    private synchronized void addUnknownComponentsToCache(DistributedComponentKnowledge knowledge) {
        Collection<DistributedComponentEntry> installations = ComponentImageUtility.getDistinctInstallations(knowledge.getAllInstallations());
        for (DistributedComponentEntry entry : installations) {
            ComponentInterface tmpCi = entry.getComponentInterface();
            this.putInCache(tmpCi.getIconHash(), tmpCi.getIdentifierAndVersion(), tmpCi.getIcon16(), tmpCi.getIcon24(), tmpCi.getIcon32());
        }
        this.syncFilesWithQueue();
    }

    @Override
    public String getIconHash(String componentId) {
        if (this.idIconMap.containsKey(componentId)) {
            return this.idIconMap.get(componentId);
        }
        return null;
    }

    public Collection<AdditionalServiceDeclaration> defineAdditionalServices() {
        ArrayList<AdditionalServiceDeclaration> result = new ArrayList<AdditionalServiceDeclaration>();
        result.add(new AdditionalServiceDeclaration(DistributedComponentKnowledgeListener.class, (Object)new DistributedComponentKnowledgeListener(){

            @Override
            public void onDistributedComponentKnowledgeChanged(DistributedComponentKnowledge newState) {
                ComponentImageCacheImpl.this.addUnknownComponentsToCache(newState);
            }
        }));
        return result;
    }
}

