/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.endpoint.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataDefinition;
import de.rcenvironment.core.component.model.endpoint.api.InitialDynamicEndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.impl.EndpointGroupDefinitionImpl;
import de.rcenvironment.core.component.model.endpoint.impl.EndpointMetaDataDefinitionImpl;
import de.rcenvironment.core.component.model.endpoint.impl.InitialDynamicEndpointDefinitionImpl;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointCharacter;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EndpointDefinitionImpl
extends EndpointGroupDefinitionImpl
implements Serializable,
EndpointDefinition {
    private static final String KEY_CHARACTER = "character";
    private static final String KEY_DATATYPE = "datatype";
    private static final String READ_ONLY_NAME = "readOnlyName";
    private static final String KEY_READ_ONLY = "readOnly";
    private static final String KEY_INITIAL_ENDPOINTS = "initialEndpoints";
    private static final long serialVersionUID = -3853446362359127472L;
    private Map<String, Object> rawEndpointDefinition;
    private Map<String, Object> rawEndpointDefinitionExtension = new HashMap<String, Object>();
    private EndpointType endpointType;
    @JsonIgnore
    private Map<String, Object> definition;
    @JsonIgnore
    private Map<String, Object> endpointDefinitionExtension;
    @JsonIgnore
    private List<DataType> dataTypes;
    @JsonIgnore
    private List<EndpointDefinition.InputDatumHandling> inputDatumHandlings;
    @JsonIgnore
    private List<EndpointDefinition.InputExecutionContraint> inputExecutionContraints;
    @JsonIgnore
    private EndpointMetaDataDefinitionImpl metaDataDefinition;
    @JsonIgnore
    private List<InitialDynamicEndpointDefinitionImpl> initialEndpointDefinitions;

    @Override
    @JsonIgnore
    public boolean isStatic() {
        return this.getName() != null;
    }

    @Override
    @JsonIgnore
    public boolean isReadOnly() {
        return this.definition.containsKey(KEY_READ_ONLY) && Boolean.parseBoolean((String)this.definition.get(KEY_READ_ONLY));
    }

    @Override
    @JsonIgnore
    public boolean isNameReadOnly() {
        return this.isStatic() || this.definition.containsKey(READ_ONLY_NAME) && Boolean.parseBoolean((String)this.definition.get(READ_ONLY_NAME));
    }

    @Override
    @JsonIgnore
    public List<DataType> getPossibleDataTypes() {
        return Collections.unmodifiableList(this.dataTypes);
    }

    @Override
    @JsonIgnore
    public DataType getDefaultDataType() {
        return DataType.valueOf((String)((String)this.definition.get("defaultDataType")));
    }

    @Override
    @JsonIgnore
    public List<EndpointDefinition.InputDatumHandling> getInputDatumOptions() {
        return Collections.unmodifiableList(this.inputDatumHandlings);
    }

    @Override
    @JsonIgnore
    public EndpointDefinition.InputDatumHandling getDefaultInputDatumHandling() {
        if (this.definition.containsKey("defaultInputHandling")) {
            return EndpointDefinition.InputDatumHandling.valueOf((String)this.definition.get("defaultInputHandling"));
        }
        return this.getInputDatumOptions().get(0);
    }

    @Override
    @JsonIgnore
    public List<EndpointDefinition.InputExecutionContraint> getInputExecutionConstraintOptions() {
        return Collections.unmodifiableList(this.inputExecutionContraints);
    }

    @Override
    @JsonIgnore
    public EndpointDefinition.InputExecutionContraint getDefaultInputExecutionConstraint() {
        if (this.definition.containsKey("defaultInputExecutionConstraint")) {
            return EndpointDefinition.InputExecutionContraint.valueOf((String)this.definition.get("defaultInputExecutionConstraint"));
        }
        return this.getInputExecutionConstraintOptions().get(0);
    }

    @Override
    @JsonIgnore
    public EndpointMetaDataDefinition getMetaDataDefinition() {
        return this.metaDataDefinition;
    }

    @Override
    @JsonIgnore
    public EndpointCharacter getEndpointCharacter() {
        if (this.definition.containsKey(KEY_CHARACTER)) {
            return EndpointCharacter.fromEndpointDefinitionValue((String)((String)this.definition.get(KEY_CHARACTER)));
        }
        return EndpointCharacter.SAME_LOOP;
    }

    @Override
    @JsonIgnore
    public List<InitialDynamicEndpointDefinition> getInitialDynamicEndpointDefinitions() {
        return new ArrayList<InitialDynamicEndpointDefinition>(this.initialEndpointDefinitions);
    }

    @Override
    public EndpointType getEndpointType() {
        return this.endpointType;
    }

    public Map<String, Object> getRawEndpointDefinition() {
        return this.rawEndpointDefinition;
    }

    public Map<String, Object> getRawEndpointDefinitionExtension() {
        return this.rawEndpointDefinitionExtension;
    }

    public void setEndpointType(EndpointType type) {
        this.endpointType = type;
    }

    public void setRawEndpointDefinition(Map<String, Object> rawEndpointDefinition) {
        this.rawEndpointDefinition = rawEndpointDefinition;
        this.rawEndpointGroupDefinition = rawEndpointDefinition;
        this.definition = new HashMap<String, Object>(rawEndpointDefinition);
        this.dataTypes = new ArrayList<DataType>();
        for (String dataType : (List)this.definition.get("dataTypes")) {
            this.dataTypes.add(DataType.valueOf((String)dataType));
        }
        Collections.sort(this.dataTypes);
        this.inputDatumHandlings = new ArrayList<EndpointDefinition.InputDatumHandling>();
        if (this.definition.containsKey("inputHandlingOptions")) {
            for (String inputDatumHandling : (List)this.definition.get("inputHandlingOptions")) {
                this.inputDatumHandlings.add(EndpointDefinition.InputDatumHandling.valueOf(inputDatumHandling));
            }
        } else {
            this.inputDatumHandlings.add(EndpointDefinition.InputDatumHandling.Single);
        }
        this.inputExecutionContraints = new ArrayList<EndpointDefinition.InputExecutionContraint>();
        if (this.definition.containsKey("inputExecutionConstraintOptions")) {
            for (String inputExecutionContraint : (List)this.definition.get("inputExecutionConstraintOptions")) {
                this.inputExecutionContraints.add(EndpointDefinition.InputExecutionContraint.valueOf(inputExecutionContraint));
            }
        } else {
            this.inputExecutionContraints.add(EndpointDefinition.InputExecutionContraint.Required);
        }
        HashMap<String, Map<String, Object>> metaData = (HashMap<String, Map<String, Object>>)this.definition.get("metaData");
        if (metaData == null) {
            metaData = new HashMap<String, Map<String, Object>>();
        }
        this.metaDataDefinition = new EndpointMetaDataDefinitionImpl();
        this.metaDataDefinition.setRawMetaData(metaData);
        this.definition.remove("metaData");
        if (!this.dataTypes.contains(this.getDefaultDataType())) {
            throw new IllegalArgumentException(StringUtils.format((String)"Declared default data type '%s' not in declared list of allowed data types '%s'", (Object[])new Object[]{this.getDefaultDataType(), this.dataTypes}));
        }
        if (!this.inputDatumHandlings.contains((Object)this.getDefaultInputDatumHandling())) {
            throw new IllegalArgumentException(StringUtils.format((String)"Declared default input handling option '%s' not in declared list of allowed input handling options '%s'", (Object[])new Object[]{this.getDefaultInputDatumHandling(), this.inputDatumHandlings}));
        }
        if (!this.inputExecutionContraints.contains((Object)this.getDefaultInputExecutionConstraint())) {
            throw new IllegalArgumentException(StringUtils.format((String)"Declared default input execution constraint option '%s' not in declared list of allowed input execution constraint options '%s'", (Object[])new Object[]{this.getDefaultInputExecutionConstraint(), this.inputExecutionContraints}));
        }
        this.initialEndpointDefinitions = new ArrayList<InitialDynamicEndpointDefinitionImpl>();
        List rawInitialEndpoints = (List)this.definition.get(KEY_INITIAL_ENDPOINTS);
        if (rawInitialEndpoints != null) {
            for (Map defaultEndpoint : rawInitialEndpoints) {
                DataType dataType = this.getDefaultDataType();
                if (defaultEndpoint.containsKey(KEY_DATATYPE)) {
                    dataType = DataType.valueOf((String)((String)defaultEndpoint.get(KEY_DATATYPE)));
                }
                this.initialEndpointDefinitions.add(new InitialDynamicEndpointDefinitionImpl((String)defaultEndpoint.get("name"), dataType));
            }
        }
    }

    public void setRawEndpointDefinitionExtension(Map<String, Object> rawEndpointDefinitionExtension) {
        this.rawEndpointDefinitionExtension = rawEndpointDefinitionExtension;
        this.endpointDefinitionExtension = new HashMap<String, Object>(rawEndpointDefinitionExtension);
        HashMap<String, Map<String, Object>> metaData = (HashMap<String, Map<String, Object>>)this.endpointDefinitionExtension.get("metaData");
        if (metaData == null) {
            metaData = new HashMap<String, Map<String, Object>>();
        }
        this.metaDataDefinition.setRawMetaDataExtensions(metaData);
    }
}

