/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.management.utils;

import de.rcenvironment.core.authorization.cryptography.api.CryptographyOperationsProvider;
import de.rcenvironment.core.authorization.cryptography.api.SymmetricKey;
import de.rcenvironment.core.component.management.utils.JsonDataWithOptionalEncryption;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.LogFactory;

public final class JsonDataEncryptionUtils {
    private JsonDataEncryptionUtils() {
    }

    public static JsonDataWithOptionalEncryption asPublicData(String inputData) {
        return new JsonDataWithOptionalEncryption(inputData, null);
    }

    public static JsonDataWithOptionalEncryption encryptForKeys(String inputData, Map<String, SymmetricKey> providedEncryptionKeys, CryptographyOperationsProvider cryptographyOperationsProvider) throws OperationFailureException {
        SymmetricKey commonEncryptionKey = cryptographyOperationsProvider.generateSymmetricKey();
        String encodedCommonEncryptionKey = commonEncryptionKey.getEncodedForm();
        String encryptedData = cryptographyOperationsProvider.encryptAndEncodeString(commonEncryptionKey, inputData);
        HashMap<String, String> individualCiphertextsOfCommonKey = new HashMap<String, String>();
        for (Map.Entry<String, SymmetricKey> e : providedEncryptionKeys.entrySet()) {
            String id = e.getKey();
            SymmetricKey individualKey = e.getValue();
            individualCiphertextsOfCommonKey.put(id, cryptographyOperationsProvider.encryptAndEncodeString(individualKey, encodedCommonEncryptionKey));
        }
        return new JsonDataWithOptionalEncryption(encryptedData, individualCiphertextsOfCommonKey);
    }

    public static boolean isPublic(JsonDataWithOptionalEncryption wrapper) {
        return wrapper.getAuthData() == null;
    }

    public static String getPublicData(JsonDataWithOptionalEncryption wrapper) {
        return wrapper.getData();
    }

    public static Set<String> getKeyIds(JsonDataWithOptionalEncryption wrapper) {
        Map<String, String> authData = wrapper.getAuthData();
        if (authData == null) {
            return new HashSet<String>();
        }
        return authData.keySet();
    }

    public static String attemptDecryption(JsonDataWithOptionalEncryption wrapper, String keyId, SymmetricKey decryptionKey, CryptographyOperationsProvider cryptographyOperationsProvider) throws OperationFailureException {
        String encryptedCommonKey = wrapper.getAuthData().get(keyId);
        SymmetricKey commonKey = cryptographyOperationsProvider.decodeSymmetricKey(cryptographyOperationsProvider.decodeAndDecryptString(decryptionKey, encryptedCommonKey));
        String decryptedComponentData = cryptographyOperationsProvider.decodeAndDecryptString(commonKey, wrapper.getData());
        if (JsonDataEncryptionUtils.isPlausibleJsonObjectString(decryptedComponentData)) {
            return decryptedComponentData;
        }
        LogFactory.getLog(JsonDataEncryptionUtils.class).warn((Object)("Data decrypted using key " + keyId + " does not match the expected format: " + decryptedComponentData));
        throw new OperationFailureException("Decryption using key " + keyId + " was successful, but the resulting data has an unexpected format; see the log file for details");
    }

    public static boolean isPlausibleJsonObjectString(String data) {
        return data != null && data.startsWith("{") && data.endsWith("}");
    }
}

