/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.api;

import de.rcenvironment.core.component.execution.api.WorkflowGraphEdge;
import de.rcenvironment.core.component.execution.api.WorkflowGraphNode;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class WorkflowGraphEdges
implements Serializable {
    private static final long serialVersionUID = 3520020437759252474L;
    private final Map<String, Set<WorkflowGraphEdge>> values = new HashMap<String, Set<WorkflowGraphEdge>>();

    WorkflowGraphEdges() {
    }

    private static String createEdgeKey(WorkflowGraphEdge edge) {
        return StringUtils.escapeAndConcat((String[])new String[]{edge.getSourceExecutionIdentifier().toString(), edge.getOutputIdentifier()});
    }

    private static String createEdgeKey(WorkflowGraphNode node, String outputIdentifier) {
        return StringUtils.escapeAndConcat((String[])new String[]{node.getExecutionIdentifier().toString(), outputIdentifier});
    }

    public static WorkflowGraphEdges create(Set<WorkflowGraphEdge> edgeSet) {
        WorkflowGraphEdges returnValue = new WorkflowGraphEdges();
        for (WorkflowGraphEdge edge : edgeSet) {
            returnValue.addEdge(edge);
        }
        return returnValue;
    }

    public boolean containsEdge(WorkflowGraphEdge edge) {
        return this.values.containsKey(WorkflowGraphEdges.createEdgeKey(edge));
    }

    public boolean containsOutgoingEdge(WorkflowGraphNode node, String outputIdentifier) {
        return this.values.containsKey(WorkflowGraphEdges.createEdgeKey(node, outputIdentifier));
    }

    public Iterable<WorkflowGraphEdge> getOutgoingEdges(WorkflowGraphNode node, String outputIdentifier) {
        String edgeKey = WorkflowGraphEdges.createEdgeKey(node, outputIdentifier);
        if (this.values.containsKey(edgeKey)) {
            return this.values.get(edgeKey);
        }
        return new HashSet<WorkflowGraphEdge>();
    }

    public void addEdge(WorkflowGraphEdge edge) {
        String edgeKey = WorkflowGraphEdges.createEdgeKey(edge);
        if (!this.values.containsKey(edgeKey)) {
            this.values.put(edgeKey, new HashSet());
        }
        this.values.get(edgeKey).add(edge);
    }

    public Iterable<Set<WorkflowGraphEdge>> getAllEdges() {
        return this.values.values();
    }

    public int hashCode() {
        return 31 + this.values.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkflowGraphEdges other = (WorkflowGraphEdges)obj;
        return this.values.equals(other.values);
    }
}

